/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public enum DistanceUnit {
    M(1.0, new String[]{"m", "meter", "meters"}),
    MM(M, 0.001, new String[]{"mm", "millimeter", "millimeters"}),
    CM(M, 0.01, new String[]{"cm", "centimeter", "centimeters"}),
    KM(M, 1000.0, new String[]{"km", "kilometer", "kilometers"}),
    FT(0.30479999999999996, new String[]{"ft", "foot", "feet"}),
    IN(FT, 0.08333333333333333, new String[]{"in", "inch"}),
    YD(FT, 3.0, new String[]{"yd", "yard", "yards"}),
    MI(FT, 5280.0, new String[]{"mi", "mile", "miles"}),
    DEGREES(111226.30555555556, new String[]{"\u00b0", "dd", "deg", "degree", "degrees"}),
    MINUTE(DEGREES, 0.016666666666666666, new String[]{"min", "minute", "minutes"}),
    SECOND(MINUTE, 0.016666666666666666, new String[]{"sec", "second", "seconds"}),
    PX(3.5277777777777776E-4, new String[]{"px", "pixel"}),
    PT(IN, 0.013888888888888888, new String[]{"pt", "point"}),
    PC(PT, 12.0, new String[]{"pc", "pica"});

    private static Map<String, DistanceUnit> translations;
    private final DistanceUnit baseUnit;
    private final double baseFactor;
    private final double metersFactor;
    private final String[] texts;
    private DistanceUnit[] allUnits = null;

    private DistanceUnit(double factor, String[] texts) {
        this.baseUnit = this;
        this.baseFactor = 1.0;
        this.metersFactor = factor;
        this.texts = texts;
    }

    private DistanceUnit(DistanceUnit baseUnit, double factor, String[] texts) {
        this.baseUnit = baseUnit.baseUnit;
        this.baseFactor = factor * baseUnit.baseFactor;
        this.metersFactor = baseUnit.metersFactor * factor;
        this.texts = texts;
    }

    public static DistanceUnit fromString(String val) {
        return DistanceUnit.getTranslations().get(val.toLowerCase());
    }

    public static DistanceUnit getBestUnit(double value, DistanceUnit unit) {
        DistanceUnit[] units = unit.getAllUnits();
        for (int i = units.length - 1; i >= 0; --i) {
            DistanceUnit cur = units[i];
            double converted = Math.abs(unit.convertTo(1.0, cur) * value);
            if (!(converted >= 1.0)) continue;
            return cur;
        }
        return units[0];
    }

    private static synchronized Map<String, DistanceUnit> getTranslations() {
        if (translations == null) {
            DistanceUnit[] values;
            translations = new HashMap<String, DistanceUnit>();
            for (DistanceUnit cur : values = DistanceUnit.values()) {
                for (int j = 0; j < cur.texts.length; ++j) {
                    translations.put(cur.texts[j], cur);
                }
            }
        }
        return translations;
    }

    public static DistanceUnit fromProjection(CoordinateReferenceSystem projection) {
        Unit projectionUnit = projection.getCoordinateSystem().getAxis(0).getUnit();
        return DistanceUnit.fromString(projectionUnit.toString());
    }

    public boolean isBase() {
        return this.baseUnit == this;
    }

    public double convertTo(double value, DistanceUnit targetUnit) {
        if (targetUnit == this) {
            return value;
        }
        if (this.isSameBaseUnit(targetUnit)) {
            return value * this.baseFactor / targetUnit.baseFactor;
        }
        return value * this.metersFactor / targetUnit.metersFactor;
    }

    public boolean isSameBaseUnit(DistanceUnit target) {
        return target.baseUnit == this.baseUnit || target == this.baseUnit || target.baseUnit == this;
    }

    public final String toString() {
        return this.texts[0];
    }

    public final synchronized DistanceUnit[] getAllUnits() {
        if (this.allUnits == null) {
            if (this.baseUnit != this) {
                this.allUnits = this.baseUnit.getAllUnits();
            } else {
                DistanceUnit[] values = DistanceUnit.values();
                ArrayList<DistanceUnit> list = new ArrayList<DistanceUnit>(values.length);
                for (DistanceUnit value : values) {
                    if (value.baseUnit != this) continue;
                    list.add(value);
                }
                DistanceUnit[] result = new DistanceUnit[list.size()];
                list.toArray(result);
                Arrays.sort(result, Comparator.comparingDouble(o -> o.baseFactor));
                this.allUnits = result;
            }
        }
        return this.allUnits;
    }

    static {
        translations = null;
    }
}

