/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image;

import com.codahale.metrics.MetricRegistry;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.MapLayerFactoryPlugin;
import org.mapfish.print.map.geotools.AbstractGridCoverageLayerPlugin;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.AbstractSingleImageLayer;
import org.mapfish.print.parser.HasDefaultValue;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class ImageLayer
extends AbstractSingleImageLayer {
    private final ImageParam params;
    private final StyleSupplier<GridCoverage2D> styleSupplier;
    private final ExecutorService executorService;

    protected ImageLayer(@Nonnull ExecutorService executorService, @Nonnull StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull ImageParam params, @Nonnull Configuration configuration, @Nonnull MetricRegistry registry) {
        super(executorService, styleSupplier, params, registry, configuration);
        this.params = params;
        this.styleSupplier = styleSupplier;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BufferedImage loadImage(MfClientHttpRequestFactory requestFactory, MapfishMapContext transformer) throws Throwable {
        ImageParam layerParam = this.params;
        URI commonUri = new URI(layerParam.getBaseUrl());
        Rectangle paintArea = transformer.getPaintArea();
        ReferencedEnvelope envelope = transformer.getBounds().toReferencedEnvelope(paintArea);
        CoordinateReferenceSystem mapProjection = envelope.getCoordinateReferenceSystem();
        BufferedImage bufferedImage = new BufferedImage(paintArea.width, paintArea.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        MapBounds bounds = transformer.getBounds();
        MapContent content = new MapContent();
        ClientHttpRequest request = requestFactory.createRequest(commonUri, HttpMethod.GET);
        BufferedImage image = this.fetchImage(request, transformer);
        try {
            GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
            GeneralEnvelope gridEnvelope = new GeneralEnvelope(mapProjection);
            gridEnvelope.setEnvelope(layerParam.extent);
            GridCoverage2D coverage = factory.create((CharSequence)layerParam.getBaseUrl(), (RenderedImage)image, (Envelope)gridEnvelope, null, null, null);
            Style style = this.styleSupplier.load(requestFactory, coverage);
            GridCoverageLayer l = new GridCoverageLayer(coverage, style);
            content.addLayers(Collections.singletonList(l));
            StreamingRenderer renderer = new StreamingRenderer();
            RenderingHints hints = new RenderingHints(Collections.emptyMap());
            hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.addRenderingHints(hints);
            renderer.setJava2DHints(hints);
            HashMap<String, Boolean> renderHints = new HashMap<String, Boolean>();
            if (transformer.isForceLongitudeFirst() != null) {
                renderHints.put("ForceEPSGAxisOrder", transformer.isForceLongitudeFirst());
            }
            renderer.setRendererHints(renderHints);
            renderer.setMapContent(content);
            renderer.setThreadPool(this.executorService);
            ReferencedEnvelope mapArea = bounds.toReferencedEnvelope(paintArea);
            renderer.paint(graphics, paintArea, mapArea);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            graphics.dispose();
            content.dispose();
        }
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.UNKNOWN;
    }

    public static final class ImageParam
    extends AbstractLayerParams {
        private static final int NUMBER_OF_EXTENT_COORDS = 4;
        public String baseURL;
        public double[] extent;
        @HasDefaultValue
        public String style = "raster";

        public void postConstruct() {
            Assert.equals((Object)4, (Object)this.extent.length, (String)("maxExtent must have exactly 4 elements to the array.  Was: " + Arrays.toString(this.extent)));
        }

        public String getBaseUrl() {
            return this.baseURL;
        }
    }

    public static final class ImageLayerPlugin
    extends AbstractGridCoverageLayerPlugin
    implements MapLayerFactoryPlugin<ImageParam> {
        private static final String TYPE = "image";
        @Autowired
        private ForkJoinPool forkJoinPool;
        @Autowired
        private MetricRegistry metricRegistry;

        @Override
        public Set<String> getTypeNames() {
            return Collections.singleton(TYPE);
        }

        @Override
        public ImageParam createParameter() {
            return new ImageParam();
        }

        @Nonnull
        public ImageLayer parse(@Nonnull Template template, @Nonnull ImageParam layerData) {
            String styleRef = layerData.style;
            return new ImageLayer((ExecutorService)this.forkJoinPool, super.createStyleSupplier(template, styleRef), layerData, template.getConfiguration(), this.metricRegistry);
        }
    }
}

