/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.processor.ExecutionStats;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.wrapper.ObjectMissingException;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="print_accountings")
@TypeDef(name="jsonb-node", typeClass=JsonBinaryType.class, defaultForType=ObjectNode.class)
public class HibernateAccountingEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateAccountingEntry.class);
    @Id
    @Column(name="reference_id")
    @Type(type="org.hibernate.type.TextType")
    private String referenceId;
    @Column(nullable=false, name="app_id")
    @Type(type="org.hibernate.type.TextType")
    private String appId;
    @Column
    @Type(type="org.hibernate.type.TextType")
    private String referer;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private PrintJobStatus.Status status;
    @Column(nullable=false, name="completion_time")
    private Date completionTime = new Date();
    @Column(name="processing_time_ms")
    private Long processingTimeMS = null;
    @Column(name="total_time_ms", nullable=false)
    private long totalTimeMS;
    @Column(nullable=false, name="output_format")
    @Type(type="org.hibernate.type.TextType")
    private String outputFormat;
    @Column(nullable=false)
    @Type(type="org.hibernate.type.TextType")
    private String layout;
    @Column(name="file_size")
    private Long fileSize = null;
    @Column(columnDefinition="jsonb")
    private ObjectNode stats = null;
    @Column(nullable=false)
    private boolean mapExport;

    public HibernateAccountingEntry() {
    }

    public HibernateAccountingEntry(PrintJobEntry entry, PrintJobStatus.Status status, Configuration configuration) {
        this.referenceId = entry.getReferenceId();
        this.appId = entry.getAppId();
        PJsonObject specJson = entry.getRequestData();
        try {
            PObject headers = specJson.getObject("attributes").getObject("requestHeaders").getObject("requestHeaders");
            if (headers.has("referer")) {
                this.referer = headers.getArray("referer").getString(0);
            }
        }
        catch (ObjectMissingException ex) {
            LOGGER.info("Cannot get the referer", (Throwable)ex);
        }
        try {
            this.outputFormat = specJson.getString("outputFormat");
        }
        catch (ObjectMissingException ex) {
            LOGGER.info("Cannot get the output format", (Throwable)ex);
        }
        try {
            this.layout = specJson.getString("layout");
            this.mapExport = configuration.getTemplate(this.layout).isMapExport();
        }
        catch (ObjectMissingException ex) {
            LOGGER.info("Cannot get the layout", (Throwable)ex);
        }
        this.status = status;
        this.totalTimeMS = System.currentTimeMillis() - entry.getStartTime();
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getReferer() {
        return this.referer;
    }

    public PrintJobStatus.Status getStatus() {
        return this.status;
    }

    public Long getProcessingTimeMS() {
        return this.processingTimeMS;
    }

    public void setProcessingTimeMS(Long processingTimeMS) {
        this.processingTimeMS = processingTimeMS;
    }

    public long getTotalTimeMS() {
        return this.totalTimeMS;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getLayout() {
        return this.layout;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public ObjectNode getStats() {
        return this.stats;
    }

    public void setStats(ExecutionStats stats) {
        this.stats = stats.toJson();
    }

    public boolean getMapExport() {
        return this.mapExport;
    }
}

