/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import org.json.JSONArray;
import org.mapfish.print.attribute.map.BBoxMapBounds;
import org.mapfish.print.attribute.map.CenterScaleMapBounds;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.config.Template;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.Requires;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.json.PJsonArray;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class OverviewMapAttribute
extends GenericMapAttribute {
    private static final double DEFAULT_ZOOM_FACTOR = 5.0;
    private double zoomFactor = 5.0;
    private String style = null;

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public Class<OverviewMapAttributeValues> getValueType() {
        return OverviewMapAttributeValues.class;
    }

    @Override
    public OverviewMapAttributeValues createValue(Template template) {
        return new OverviewMapAttributeValues(template, this.getWidth(), this.getHeight());
    }

    public final class OverviewMapAttributeValues
    extends GenericMapAttribute.GenericMapAttributeValues {
        @HasDefaultValue
        public PArray layers;
        @HasDefaultValue
        public Double dpi;
        @HasDefaultValue
        public double[] bbox;
        @Requires(value={"scale"})
        @HasDefaultValue
        public double[] center;
        @HasDefaultValue
        public Double scale;
        private MapBounds mapBounds;

        public OverviewMapAttributeValues(Template template) {
            super(OverviewMapAttribute.this, template);
            this.layers = new PJsonArray(null, new JSONArray(), null);
            this.dpi = null;
        }

        public OverviewMapAttributeValues(Template template, Integer width, Integer height) {
            super(OverviewMapAttribute.this, template, width, height);
            this.layers = new PJsonArray(null, new JSONArray(), null);
            this.dpi = null;
        }

        @Override
        public void postConstruct() throws FactoryException {
            super.postConstruct();
            this.mapBounds = this.parseBounds();
        }

        private MapBounds parseBounds() {
            CoordinateReferenceSystem crs = this.parseProjection();
            if (this.center != null && this.bbox != null) {
                throw new IllegalArgumentException("Cannot have both center and bbox defined");
            }
            MapBounds bounds = null;
            if (this.center != null) {
                double centerX = this.center[0];
                double centerY = this.center[1];
                bounds = new CenterScaleMapBounds(crs, centerX, centerY, this.scale);
            } else if (this.bbox != null) {
                int maxYIndex = 3;
                double minX = this.bbox[0];
                double minY = this.bbox[1];
                double maxX = this.bbox[2];
                double maxY = this.bbox[3];
                bounds = new BBoxMapBounds(crs, minX, minY, maxX, maxY);
            }
            return bounds;
        }

        public MapBounds getMapBounds() {
            return this.mapBounds;
        }

        @Override
        public Double getDpi() {
            return this.dpi;
        }

        @Override
        public PArray getRawLayers() {
            return this.layers;
        }

        @Override
        public void setRawLayers(PArray newLayers) {
            this.layers = newLayers;
        }

        public double getZoomFactor() {
            return OverviewMapAttribute.this.zoomFactor;
        }

        public String getStyle() {
            return OverviewMapAttribute.this.style;
        }

        @Override
        public String getProjection() {
            return this.getValueOr(super.getProjection(), "EPSG:3857");
        }
    }
}

