/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.xml.styling.SLDTransformer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.StyleParserPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;

public final class StyleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleParser.class);
    @Autowired
    private List<StyleParserPlugin> plugins = new ArrayList<StyleParserPlugin>();

    public Optional<? extends Style> loadStyle(Configuration configuration, @Nonnull ClientHttpRequestFactory clientHttpRequestFactory, String styleString) {
        if (styleString != null) {
            for (StyleParserPlugin plugin : this.plugins) {
                Optional<Style> style = plugin.parseStyle(configuration, clientHttpRequestFactory, styleString);
                if (!style.isPresent()) continue;
                if (LOGGER.isDebugEnabled()) {
                    try {
                        SLDTransformer transformer = new SLDTransformer();
                        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
                        UserLayer userLayer = styleFactory.createUserLayer();
                        userLayer.addUserStyle(style.get());
                        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
                        sld.addStyledLayer((StyledLayer)userLayer);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Loaded style from: \n\n '{}': \n\n{}", (Object)styleString, (Object)transformer.transform((Object)sld));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.debug("Loaded style from: \n\n '{}' \n\n<Unable to transform it to xml>", (Object)styleString, (Object)e);
                    }
                }
                return style;
            }
        }
        return Optional.empty();
    }
}

