/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.IntMath;
import java.awt.Dimension;
import java.math.RoundingMode;
import java.net.URI;
import java.util.List;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.map.image.wms.WmsLayer;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.map.tiled.wms.TiledWmsLayer;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InputOutputValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.http.matcher.URIMatcher;
import org.mapfish.print.processor.http.matcher.UriMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class SetTiledWmsProcessor
extends AbstractProcessor<Input, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetTiledWmsProcessor.class);
    protected final UriMatchers matchers = new UriMatchers();
    private int maxWidth;
    private int maxHeight;

    protected SetTiledWmsProcessor() {
        super(Void.class);
    }

    @VisibleForTesting
    static int adaptTileDimension(int pixels, int maxTile) {
        int nb = IntMath.divide((int)pixels, (int)maxTile, (RoundingMode)RoundingMode.CEILING);
        return IntMath.divide((int)pixels, (int)nb, (RoundingMode)RoundingMode.CEILING);
    }

    private static Dimension adaptTileDimensions(Dimension pixels, int maxWidth, int maxHeight) {
        return new Dimension(SetTiledWmsProcessor.adaptTileDimension(pixels.width, maxWidth), SetTiledWmsProcessor.adaptTileDimension(pixels.height, maxHeight));
    }

    @Override
    public final Input createInputParameter() {
        return new Input();
    }

    @Override
    public final Void execute(Input values, Processor.ExecutionContext context) throws Exception {
        Dimension size = values.map.getMapSize();
        double dpiRatio = values.map.getDpi() / 72.0;
        Dimension pixels = new Dimension((int)Math.ceil((double)size.width * dpiRatio), (int)Math.ceil((double)size.height * dpiRatio));
        if (pixels.height <= this.maxHeight && pixels.width <= this.maxWidth) {
            return null;
        }
        Dimension tileSize = SetTiledWmsProcessor.adaptTileDimensions(pixels, this.maxWidth, this.maxHeight);
        List<MapLayer> layers = values.map.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            MapLayer layer = layers.get(i);
            context.stopIfCanceled();
            if (!(layer instanceof WmsLayer)) continue;
            WmsLayer wmsLayer = (WmsLayer)layer;
            WmsLayerParam params = wmsLayer.getParams();
            if (!this.matchers.matches(new URI(params.baseURL), HttpMethod.GET)) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Converting layer {}[{}] into a tiled WMS layer with tileSize={}x{}", new Object[]{wmsLayer.getParams().baseURL, String.join((CharSequence)", ", wmsLayer.getParams().layers), tileSize.width, tileSize.height});
            }
            values.map.replaceLayer(i, new TiledWmsLayer(wmsLayer, tileSize));
        }
        return null;
    }

    @Override
    protected final void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.maxHeight < 256) {
            validationErrors.add(new ConfigurationException("The maxHeight must be >=256 in " + this.getClass().getName()));
        }
        if (this.maxWidth < 256) {
            validationErrors.add(new ConfigurationException("The maxWidth must be >=256 in " + this.getClass().getName()));
        }
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public final void setMatchers(List<? extends URIMatcher> matchers) {
        this.matchers.setMatchers(matchers);
    }

    public static final class Input {
        @InputOutputValue
        public GenericMapAttribute.GenericMapAttributeValues map;
    }
}

