/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.util.Map;
import java.util.Set;

public final class MissingPropertyException
extends RuntimeException {
    private final Map<String, Class<?>> missingProperties;
    private final Set<String> attributeNames;

    public MissingPropertyException(String message, Map<String, Class<?>> missingProperties, Set<String> attributeNames) {
        super(MissingPropertyException.createMessage(message, missingProperties, attributeNames));
        this.missingProperties = missingProperties;
        this.attributeNames = attributeNames;
    }

    private static String createMessage(String message, Map<String, Class<?>> missingProperties, Set<String> attributeNames) {
        StringBuilder missingPropertyMessage = new StringBuilder(message).append("\n").append("Missing Properties: \n");
        for (Map.Entry<String, Class<?>> entry : missingProperties.entrySet()) {
            String type = entry.getValue().getName();
            if (entry.getValue().isArray()) {
                type = entry.getValue().getComponentType().getName() + "[]";
            }
            missingPropertyMessage.append("\n\t* ").append(type).append(" ").append(entry.getKey());
        }
        missingPropertyMessage.append("\n\nAll allowed properties are: \n");
        for (String attributeName : attributeNames) {
            missingPropertyMessage.append("\n\t* ").append(attributeName);
        }
        return missingPropertyMessage.toString();
    }

    public Map<String, Class<?>> getMissingProperties() {
        return this.missingProperties;
    }

    public Set<String> getAttributeNames() {
        return this.attributeNames;
    }
}

