/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class VersionInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionInfo.class);
    private static final String MAPFISH_PRINT_VERSION = "Mapfish-Print-Version";
    private static final String GIT_VERSION = "Git-Revision";
    @Nullable
    private Attributes attrs;
    @Autowired
    private ServletContext servletContext;

    @PostConstruct
    public final void init() {
        this.attrs = this.getAttributes();
        LOGGER.warn("Starting print version {} ({})", (Object)this.getVersion(), (Object)this.getGitHash());
    }

    public final String getVersion() {
        return this.getValue(MAPFISH_PRINT_VERSION);
    }

    public final String getGitHash() {
        return this.getValue(GIT_VERSION);
    }

    private String getValue(String name) {
        if (this.attrs != null) {
            String value = this.attrs.getValue(name);
            return value != null ? value : "?";
        }
        return "?";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attributes getAttributes() {
        if (this.servletContext == null) {
            return null;
        }
        try {
            String path = this.servletContext.getRealPath("/META-INF/MANIFEST.MF");
            if (path == null) return null;
            try (FileInputStream stream = new FileInputStream(path);){
                Attributes attributes = new Manifest(stream).getMainAttributes();
                return attributes;
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Cannot find servlet manifest");
            return null;
        }
        catch (IOException e) {
            LOGGER.warn("Cannot read servlet manifest");
        }
        return null;
    }
}

