/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.mapfish.print.Constants;
import org.mapfish.print.FileUtils;
import org.mapfish.print.PrintException;
import org.mapfish.print.URIUtils;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class FeaturesParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesParser.class);
    private final MfClientHttpRequestFactory httpRequestFactory;
    private final boolean forceLongitudeFirst;

    public FeaturesParser(MfClientHttpRequestFactory httpRequestFactory, boolean forceLongitudeFirst) {
        this.httpRequestFactory = httpRequestFactory;
        this.forceLongitudeFirst = forceLongitudeFirst;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static final CoordinateReferenceSystem parseCoordinateReferenceSystem(MfClientHttpRequestFactory requestFactory, JSONObject geojson, boolean forceLongitudeFirst) {
        StringBuilder code;
        DefaultEngineeringCRS crs;
        block29: {
            crs = DefaultEngineeringCRS.GENERIC_2D;
            code = new StringBuilder();
            try {
                if (!geojson.has("crs")) break block29;
                JSONObject crsJson = geojson.getJSONObject("crs");
                String type = crsJson.optString("type", "");
                if (type.equalsIgnoreCase("EPSG") || type.equalsIgnoreCase("CRS")) {
                    code.append(type);
                    String propCode = FeaturesParser.getProperty(crsJson, "code");
                    if (propCode != null) {
                        code.append(":").append(propCode);
                    }
                    break block29;
                }
                if (type.equalsIgnoreCase("name")) {
                    String propCode = FeaturesParser.getProperty(crsJson, "name");
                    if (propCode != null) {
                        code.append(propCode);
                    }
                    break block29;
                }
                if (type.equals("link")) {
                    String linkType = FeaturesParser.getProperty(crsJson, "type");
                    if (linkType != null && (linkType.equalsIgnoreCase("esriwkt") || linkType.equalsIgnoreCase("ogcwkt"))) {
                        String uri = FeaturesParser.getProperty(crsJson, "href");
                        if (uri == null) break block29;
                        ClientHttpRequest request = requestFactory.createRequest(new URI(uri), HttpMethod.GET);
                        Throwable throwable = null;
                        try (ClientHttpResponse response = request.execute();){
                            if (response.getStatusCode() != HttpStatus.OK) break block29;
                            String wkt = IOUtils.toString((InputStream)response.getBody(), (String)Constants.DEFAULT_ENCODING);
                            try {
                                CoordinateReferenceSystem coordinateReferenceSystem = CRS.parseWKT((String)wkt);
                                return coordinateReferenceSystem;
                            }
                            catch (FactoryException e) {
                                try {
                                    LOGGER.warn("Unable to load linked CRS from geojson: \n{}\n\nWKT loaded from:\n{}", (Object)crsJson, (Object)wkt);
                                    break block29;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    LOGGER.warn("Unable to load linked CRS from geojson: \n{}", (Object)crsJson);
                    break block29;
                }
                code.append(FeaturesParser.getProperty(crsJson, "code"));
            }
            catch (IOException | URISyntaxException | JSONException e) {
                LOGGER.warn("Error reading the required elements to parse crs of the geojson: \n{}", (Object)geojson, (Object)e);
            }
        }
        try {
            if (code.length() > 0) {
                crs = CRS.decode((String)code.toString(), (boolean)forceLongitudeFirst);
            }
        }
        catch (NoSuchAuthorityCodeException e) {
            LOGGER.warn("No CRS with code: {}.\nRead from geojson: \n{}", (Object)code, (Object)geojson);
        }
        catch (FactoryException e) {
            LOGGER.warn("Error loading CRS with code: {}.\nRead from geojson: \n{}", (Object)code, (Object)geojson);
        }
        return crs;
    }

    private static String getProperty(JSONObject crsJson, String nameCode) throws JSONException {
        JSONObject propertiesJson;
        if (crsJson.has("properties") && (propertiesJson = crsJson.getJSONObject("properties")).has(nameCode)) {
            return propertiesJson.getString(nameCode);
        }
        return null;
    }

    public final SimpleFeatureCollection autoTreat(Template template, String features) throws IOException {
        SimpleFeatureCollection featuresCollection = this.treatStringAsURL(template, features);
        if (featuresCollection == null) {
            featuresCollection = this.treatStringAsGeoJson(features);
        }
        return featuresCollection;
    }

    public final SimpleFeatureCollection treatStringAsURL(Template template, String geoJsonUrl) throws IOException {
        URL url;
        try {
            url = FileUtils.testForLegalFileUrl(template.getConfiguration(), new URL(geoJsonUrl));
        }
        catch (MalformedURLException e) {
            return null;
        }
        String geojsonString = url.getProtocol().equalsIgnoreCase("file") ? IOUtils.toString((URL)url, (String)Constants.DEFAULT_CHARSET.name()) : URIUtils.toString(this.httpRequestFactory, url);
        return this.treatStringAsGeoJson(geojsonString);
    }

    public final SimpleFeatureCollection treatStringAsGeoJson(String geoJsonString) throws IOException {
        return this.readFeatureCollection(geoJsonString);
    }

    private SimpleFeatureCollection readFeatureCollection(String geojsonData) throws IOException {
        String convertedGeojsonObject = this.convertToGeoJsonCollection(geojsonData);
        FeatureJSON geoJsonReader = new FeatureJSON();
        SimpleFeatureType featureType = this.createFeatureType(convertedGeojsonObject);
        if (featureType != null) {
            geoJsonReader.setFeatureType(featureType);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(convertedGeojsonObject.getBytes(Constants.DEFAULT_CHARSET));
        return (SimpleFeatureCollection)geoJsonReader.readFeatureCollection((InputStream)input);
    }

    private String convertToGeoJsonCollection(String geojsonData) {
        String convertedGeojsonObject = geojsonData.trim();
        if (convertedGeojsonObject.startsWith("[")) {
            convertedGeojsonObject = "{\"type\": \"FeatureCollection\", \"features\": " + convertedGeojsonObject + "}";
        }
        return convertedGeojsonObject;
    }

    private SimpleFeatureType createFeatureType(@Nonnull String geojsonData) {
        try {
            JSONObject geojson = new JSONObject(geojsonData);
            if (geojson.has("type") && geojson.getString("type").equalsIgnoreCase("FeatureCollection")) {
                CoordinateReferenceSystem crs = FeaturesParser.parseCoordinateReferenceSystem(this.httpRequestFactory, geojson, this.forceLongitudeFirst);
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName("GeosjonFeatureType");
                JSONArray features = geojson.getJSONArray("features");
                if (features.length() == 0) {
                    return null;
                }
                HashSet<String> allAttributes = new HashSet<String>();
                Class<Geometry> geomType = null;
                for (int i = 0; i < features.length(); ++i) {
                    Class<Geometry> thisGeomType;
                    JSONObject feature = features.getJSONObject(i);
                    JSONObject properties = feature.getJSONObject("properties");
                    Iterator keys = properties.keys();
                    while (keys.hasNext()) {
                        String nextKey = (String)keys.next();
                        if (allAttributes.contains(nextKey)) continue;
                        allAttributes.add(nextKey);
                        builder.add(nextKey, Object.class);
                    }
                    if (geomType == Geometry.class || (thisGeomType = this.parseGeometryType(feature)) == null) continue;
                    if (geomType == null) {
                        geomType = thisGeomType;
                        continue;
                    }
                    if (geomType.equals(thisGeomType)) continue;
                    geomType = Geometry.class;
                }
                builder.add("geometry", geomType, crs);
                builder.setDefaultGeometry("geometry");
                return builder.buildFeatureType();
            }
            return null;
        }
        catch (JSONException e) {
            throw new PrintException("Invalid geoJSON: \n" + geojsonData + ": " + e.getMessage(), e);
        }
    }

    private Class<Geometry> parseGeometryType(@Nonnull JSONObject featureJson) throws JSONException {
        JSONObject geomJson = featureJson.optJSONObject("geometry");
        if (geomJson == null) {
            return null;
        }
        String geomTypeString = geomJson.optString("type", "Geometry");
        if (geomTypeString.equalsIgnoreCase("Positions")) {
            return Geometry.class;
        }
        try {
            return Class.forName("org.locationtech.jts.geom." + geomTypeString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unrecognized geometry type in geojson: " + geomTypeString);
        }
    }
}

