/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Stroke;
import org.mapfish.print.map.geotools.function.MultiplicationFunction;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public final class OpacitySettingStyleVisitor
extends AbstractStyleVisitor {
    private final Expression opacityFactor;
    private final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();

    public OpacitySettingStyleVisitor(double opacityFactor) {
        this.opacityFactor = this.filterFactory.literal(opacityFactor);
    }

    public void visit(Fill fill) {
        Expression opacity = fill.getOpacity();
        Function newExpr = this.getOpacityAdjustingExpression(opacity);
        fill.setOpacity((Expression)newExpr);
    }

    public void visit(Stroke stroke) {
        Expression opacity = stroke.getOpacity();
        Function newExpr = this.getOpacityAdjustingExpression(opacity);
        stroke.setOpacity((Expression)newExpr);
    }

    public void visit(Graphic gr) {
        Expression opacity = gr.getOpacity();
        Function newExpr = this.getOpacityAdjustingExpression(opacity);
        gr.setOpacity((Expression)newExpr);
    }

    public void visit(RasterSymbolizer raster) {
        Expression opacity = raster.getOpacity();
        Function newExpr = this.getOpacityAdjustingExpression(opacity);
        raster.setOpacity((Expression)newExpr);
    }

    private Function getOpacityAdjustingExpression(Expression opacity) {
        return this.filterFactory.function(MultiplicationFunction.NAME.getName(), new Expression[]{opacity, this.opacityFactor});
    }
}

