/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.DefaultResourceLocator;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.Style;
import org.geotools.xml.styling.SLDParser;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.Constants;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.ParserPluginUtils;
import org.mapfish.print.map.style.StyleParserPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SLDParserPlugin
implements StyleParserPlugin {
    public static final String STYLE_INDEX_REF_SEPARATOR = "##";

    @Override
    public final Optional<Style> parseStyle(@Nullable Configuration configuration, @Nonnull ClientHttpRequestFactory clientHttpRequestFactory, @Nonnull String styleString) {
        Optional<Style> styleOptional = this.tryLoadSLD(styleString.getBytes(Constants.DEFAULT_CHARSET), null, clientHttpRequestFactory);
        if (styleOptional.isPresent()) {
            return styleOptional;
        }
        Integer styleIndex = this.lookupStyleIndex(styleString).orElse(null);
        String styleStringWithoutIndexReference = this.removeIndexReference(styleString);
        Function<byte[], Optional<Style>> loadFunction = input -> this.tryLoadSLD((byte[])input, styleIndex, clientHttpRequestFactory);
        return ParserPluginUtils.loadStyleAsURI(clientHttpRequestFactory, styleStringWithoutIndexReference, loadFunction);
    }

    private String removeIndexReference(String styleString) {
        int styleIdentifier = styleString.lastIndexOf(STYLE_INDEX_REF_SEPARATOR);
        if (styleIdentifier > 0) {
            return styleString.substring(0, styleIdentifier);
        }
        return styleString;
    }

    private Optional<Integer> lookupStyleIndex(String ref) {
        int styleIdentifier = ref.lastIndexOf(STYLE_INDEX_REF_SEPARATOR);
        if (styleIdentifier > 0) {
            return Optional.of(Integer.parseInt(ref.substring(styleIdentifier + 2)) - 1);
        }
        return Optional.empty();
    }

    private Optional<Style> tryLoadSLD(byte[] bytes, Integer styleIndex, final ClientHttpRequestFactory clientHttpRequestFactory) {
        Style[] styles;
        Assert.isTrue((styleIndex == null || styleIndex > -1 ? 1 : 0) != 0, (String)("styleIndex must be > -1 but was: " + styleIndex));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ErrorHandler());
            db.parse(new ByteArrayInputStream(bytes));
            SLDParser sldParser = new SLDParser(CommonFactoryFinder.getStyleFactory());
            sldParser.setOnLineResourceLocator((ResourceLocator)new DefaultResourceLocator(){

                public URL locateResource(String uri) {
                    try {
                        URL theUrl = super.locateResource(uri);
                        URI theUri = theUrl != null ? theUrl.toURI() : URI.create(uri);
                        if (theUri.getScheme().startsWith("http")) {
                            ClientHttpRequest request = clientHttpRequestFactory.createRequest(theUri, HttpMethod.GET);
                            return request.getURI().toURL();
                        }
                        return null;
                    }
                    catch (IOException | URISyntaxException e) {
                        return null;
                    }
                }
            });
            sldParser.setInput((InputStream)new ByteArrayInputStream(bytes));
            styles = sldParser.readXML();
        }
        catch (Throwable e) {
            return Optional.empty();
        }
        if (styleIndex != null) {
            Assert.isTrue((styleIndex < styles.length ? 1 : 0) != 0, (String)String.format("There where %s styles in file but requested index was: %s", styles.length, styleIndex + 1));
        } else {
            Assert.isTrue((styles.length < 2 ? 1 : 0) != 0, (String)String.format("There are %s therefore the styleRef must contain an index identifying the style.  The index starts at 1 for the first style.\n\tExample: thinline.sld##1", styles.length));
        }
        if (styleIndex == null) {
            return Optional.of(styles[0]);
        }
        return Optional.of(styles[styleIndex]);
    }

    public static class ErrorHandler
    extends DefaultHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);

        @Override
        public final void error(SAXParseException e) throws SAXException {
            LOGGER.debug("XML error: {}", (Object)e.getLocalizedMessage());
            super.error(e);
        }

        @Override
        public final void fatalError(SAXParseException e) throws SAXException {
            LOGGER.debug("XML fatal error: {}", (Object)e.getLocalizedMessage());
            super.fatalError(e);
        }

        @Override
        public final void warning(SAXParseException e) {
        }
    }
}

