/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style.json;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.json.JsonStyleParserHelper;
import org.mapfish.print.wrapper.json.PJsonArray;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.IncludeFilter;
import org.springframework.http.client.ClientHttpRequestFactory;

public final class MapfishJsonStyleVersion2 {
    static final String JSON_SYMB = "symbolizers";
    private static final String JSON_TYPE = "type";
    private static final Pattern VALUE_EXPR_PATTERN = Pattern.compile("\\$\\{([\\w\\d_-]+)\\}");
    private static final String JSON_MIN_SCALE = "minScale";
    private static final String JSON_MAX_SCALE = "maxScale";
    private static final String JSON_FILTER_INCLUDE = "*";
    private final PJsonObject json;
    private final StyleBuilder styleBuilder;
    private final JsonStyleParserHelper parserHelper;

    MapfishJsonStyleVersion2(@Nonnull PJsonObject json, @Nonnull StyleBuilder styleBuilder, @Nullable Configuration configuration, @Nonnull ClientHttpRequestFactory requestFactory) {
        this.json = json;
        this.styleBuilder = styleBuilder;
        this.parserHelper = new JsonStyleParserHelper(configuration, requestFactory, styleBuilder, false);
    }

    @VisibleForTesting
    static Map<String, String> resolveAllValues(Map<String, String> values) {
        HashMap<String, String> toResolve = new HashMap<String, String>(values);
        HashMap<String, String> resolved = new HashMap<String, String>(values.size());
        while (!toResolve.isEmpty()) {
            Iterator entries = toResolve.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry next = entries.next();
                String value = (String)next.getValue();
                String resolve = MapfishJsonStyleVersion2.resolve(values, value);
                if (resolve == null) {
                    resolved.put((String)next.getKey(), value);
                    entries.remove();
                    continue;
                }
                next.setValue(resolve);
            }
        }
        return resolved;
    }

    private static String resolve(Map<String, String> values, String value) {
        int lastEnd = 0;
        Matcher matcher = VALUE_EXPR_PATTERN.matcher(value);
        boolean changed = false;
        StringBuilder updatedValue = new StringBuilder();
        while (matcher.find()) {
            String replacement;
            String valName = matcher.group(1);
            if (values.containsKey(valName)) {
                changed = true;
                replacement = values.get(valName);
            } else {
                replacement = matcher.group(0);
            }
            updatedValue.append(value, lastEnd, matcher.start());
            updatedValue.append(replacement);
            lastEnd = matcher.end();
        }
        if (changed) {
            updatedValue.append(value.substring(lastEnd));
            return updatedValue.toString();
        }
        return null;
    }

    Style parseStyle() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Iterator<String> keys = this.json.keys();
        while (keys.hasNext()) {
            String next = keys.next().trim();
            if (!this.isRule(next)) continue;
            rules.add(this.createRule(next));
        }
        if (rules.isEmpty()) {
            throw new IllegalArgumentException(String.format("No rules found in style.  Rules are json objects that have the key %s or have the form: [ecql]", JSON_FILTER_INCLUDE));
        }
        return this.parserHelper.createStyle(rules);
    }

    private Rule createRule(String jsonKey) {
        PJsonObject ruleJson = this.json.getJSONObject(jsonKey);
        IncludeFilter filter = Filter.INCLUDE;
        if (!jsonKey.equals(JSON_FILTER_INCLUDE)) {
            try {
                filter = ECQL.toFilter((String)jsonKey, (FilterFactory)this.styleBuilder.getFilterFactory());
            }
            catch (CQLException e) {
                throw new RuntimeException("Error compiling rule filter: " + jsonKey, e);
            }
        }
        PJsonArray symbolizerJsonArray = ruleJson.getJSONArray(JSON_SYMB);
        Symbolizer[] symbolizers = new Symbolizer[symbolizerJsonArray.size()];
        for (int i = 0; i < symbolizerJsonArray.size(); ++i) {
            PJsonObject symbolizerJson = symbolizerJsonArray.getJSONObject(i);
            this.updateSymbolizerProperties(ruleJson, symbolizerJson);
            SymbolizerType type = SymbolizerType.valueOf(symbolizerJson.getString(JSON_TYPE).toUpperCase());
            symbolizers[i] = type.parseJson(this.parserHelper, symbolizerJson);
            if (symbolizers[i] != null) continue;
            throw new RuntimeException("Error creating symbolizer " + symbolizerJson.getString(JSON_TYPE) + " in rule " + jsonKey);
        }
        Map<String, String> ruleValues = this.buildValuesMap(ruleJson, new PJsonObject(new JSONObject(), "empty"));
        double minScale = this.getScaleDenominator(ruleValues, JSON_MIN_SCALE, Double.MIN_VALUE);
        double maxScale = this.getScaleDenominator(ruleValues, JSON_MAX_SCALE, Double.MAX_VALUE);
        Rule rule = this.styleBuilder.createRule(symbolizers, minScale, maxScale);
        rule.setFilter((Filter)filter);
        return rule;
    }

    private void updateSymbolizerProperties(PJsonObject ruleJson, PJsonObject symbolizerJson) {
        Map<String, String> values = this.buildValuesMap(ruleJson, symbolizerJson);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            try {
                symbolizerJson.getInternalObj().put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
        }
    }

    private double getScaleDenominator(Map<String, String> ruleValues, String keyName, double defaultValue) {
        String scaleString = ruleValues.get(keyName);
        if (scaleString != null) {
            return Double.parseDouble(scaleString);
        }
        return defaultValue;
    }

    private Map<String, String> buildValuesMap(PJsonObject ruleJson, PJsonObject symbolizerJson) {
        String key;
        HashMap<String, String> values = new HashMap<String, String>();
        Iterator<String> keys = this.json.keys();
        while (keys.hasNext()) {
            key = keys.next().trim();
            if (this.isRule(key)) continue;
            values.put(key, this.json.getString(key));
        }
        keys = ruleJson.keys();
        while (keys.hasNext()) {
            key = keys.next().trim();
            if (key.equals(JSON_SYMB)) continue;
            values.put(key, ruleJson.getString(key));
        }
        keys = symbolizerJson.keys();
        while (keys.hasNext()) {
            key = keys.next().trim();
            if (key.equals(JSON_SYMB)) continue;
            values.put(key, symbolizerJson.getString(key));
        }
        return MapfishJsonStyleVersion2.resolveAllValues(values);
    }

    private boolean isRule(String jsonKey) {
        return this.json.optJSONObject(jsonKey) != null;
    }

    static enum SymbolizerType {
        POINT{

            @Override
            protected Symbolizer parseJson(JsonStyleParserHelper parser, PJsonObject symbolizerJson) {
                return parser.createPointSymbolizer(symbolizerJson);
            }
        }
        ,
        LINE{

            @Override
            protected Symbolizer parseJson(JsonStyleParserHelper parser, PJsonObject symbolizerJson) {
                return parser.createLineSymbolizer(symbolizerJson);
            }
        }
        ,
        POLYGON{

            @Override
            protected Symbolizer parseJson(JsonStyleParserHelper parser, PJsonObject symbolizerJson) {
                return parser.createPolygonSymbolizer(symbolizerJson);
            }
        }
        ,
        TEXT{

            @Override
            protected Symbolizer parseJson(JsonStyleParserHelper parser, PJsonObject symbolizerJson) {
                return parser.createTextSymbolizer(symbolizerJson);
            }
        };


        protected abstract Symbolizer parseJson(JsonStyleParserHelper var1, PJsonObject var2);
    }
}

