/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.mapfish.print.PrintException;
import org.mapfish.print.config.Template;
import org.mapfish.print.output.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValuesLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValuesLogger.class);
    private static final int STANDARD_INDENT_SIZE = 4;
    private final StringBuilder builder = new StringBuilder();
    private int indent = 4;

    private ValuesLogger() {
    }

    public static void log(String templateName, Template template, Values values) {
        new ValuesLogger().doLog(templateName, template, values);
    }

    private void doLog(String templateName, Template template, Values values) {
        if (!LOGGER.isInfoEnabled()) {
            return;
        }
        if (this.builder.length() > 0) {
            this.builder.append("\n");
        }
        this.builder.append("This log message details the parameters available for use in the Jasper templates ");
        this.builder.append("for\n  Mapfish Template: ").append(templateName).append("\n");
        this.builder.append("  Jasper Template name: ").append(template.getReportTemplate()).append('\n');
        this.builder.append("  The following parameters are available for use in the templates: \n");
        for (Map.Entry<String, Object> parameter : values.asMap().entrySet()) {
            boolean isTableDataKey = parameter.getKey().equals(template.getTableDataKey());
            this.logValue(templateName, parameter, isTableDataKey);
        }
        LOGGER.info(this.builder.toString());
    }

    private void logValue(String templateName, Map.Entry<String, ?> parameter, boolean isTableDataKey) {
        this.addIndent().append("* ").append(parameter.getKey());
        if (isTableDataKey) {
            if (parameter.getValue() instanceof JRDataSource) {
                this.builder.append(" <tableDataKey>");
            } else {
                String message = "The output value: '" + parameter.getKey() + "' is defined in the template: '" + templateName + "' as the tableDataKey but is not a '" + JRDataSource.class.getName() + "' object as was expected.  Instead it is " + parameter.getValue().getClass().getName();
                throw new PrintException(message);
            }
        }
        if (parameter.getValue() == null) {
            this.builder.append(" (null)\n");
        } else {
            this.builder.append(" (").append(parameter.getValue().getClass().getName()).append(")\n");
        }
        if (parameter.getValue() instanceof JRDataSource) {
            String section;
            String string = section = isTableDataKey ? "'Top-level' template" : "sub-template";
            if (!isTableDataKey) {
                this.addIndent().append("  - This value is a Jasper Reports DataSource and thus can be passed to a ").append("subtemplate as a DataSource and used in the subtemplate's detail band.\n");
            }
            if (parameter.getValue() instanceof JRMapCollectionDataSource) {
                JRMapCollectionDataSource source = (JRMapCollectionDataSource)parameter.getValue();
                this.addIndent().append("  - This DataSource contains the following columns (All rows are analyzed for their columns, thus each row may only have a subset of the columns)\n");
                this.indent += 4;
                HashMap columns = new HashMap();
                for (Map map : source.getData()) {
                    for (Map.Entry column : map.entrySet()) {
                        if (!columns.containsKey(column.getKey())) {
                            columns.put(column.getKey(), column.getValue());
                            continue;
                        }
                        if (columns.get(column.getKey()) != null) continue;
                        columns.put(column.getKey(), column.getValue());
                    }
                }
                for (Map.Entry entry : columns.entrySet()) {
                    this.logValue(templateName, entry, false);
                }
                this.indent -= 4;
            } else {
                this.addIndent().append("  - This datasource is not a type that can be introspected but it can be used in a detail section of ").append(section).append(" if the structure is known.\n");
            }
        }
    }

    private StringBuilder addIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.builder.append(" ");
        }
        return this.builder;
    }
}

