/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.parser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mapfish.print.parser.HasDefaultValue;

public final class ParserUtils {
    public static final Predicate<Field> FILTER_ONLY_REQUIRED_ATTRIBUTES = input -> input != null && input.getAnnotation(HasDefaultValue.class) == null && !Modifier.isFinal(input.getModifiers());
    public static final Predicate<Field> FILTER_HAS_DEFAULT_ATTRIBUTES = input -> input != null && input.getAnnotation(HasDefaultValue.class) != null;
    public static final Predicate<Field> FILTER_NON_FINAL_FIELDS = input -> input != null && !Modifier.isFinal(input.getModifiers());
    public static final Predicate<Field> FILTER_FINAL_FIELDS = input -> input != null && Modifier.isFinal(input.getModifiers());
    private static final Function<Field, String> FIELD_TO_NAME = Field::getName;

    private ParserUtils() {
    }

    public static Collection<Field> getAllAttributes(Class<?> classToInspect) {
        HashSet<Field> allFields = new HashSet<Field>();
        ParserUtils.getAllAttributes(classToInspect, allFields, Function.identity(), field -> true);
        return allFields;
    }

    public static Collection<Field> getAttributes(Class<?> classToInspect, Predicate<Field> filter) {
        HashSet<Field> allFields = new HashSet<Field>();
        ParserUtils.getAllAttributes(classToInspect, allFields, Function.identity(), filter);
        return allFields;
    }

    private static <V> void getAllAttributes(Class<?> classToInspect, Set<V> results, Function<Field, V> map, Predicate<Field> filter) {
        if (classToInspect != null && classToInspect != Void.class) {
            Collection resultsForClass = Arrays.stream(classToInspect.getFields()).filter(filter).map(map).collect(Collectors.toList());
            results.addAll(resultsForClass);
            if (classToInspect.getSuperclass() != null) {
                ParserUtils.getAllAttributes(classToInspect.getSuperclass(), results, map, filter);
            }
        }
    }

    public static Set<String> getAllAttributeNames(Class<?> classToInspect) {
        HashSet<String> allFields = new HashSet<String>();
        ParserUtils.getAllAttributes(classToInspect, allFields, FIELD_TO_NAME, field -> true);
        return allFields;
    }

    public static Set<String> getAttributeNames(Class<?> classToInspect, Predicate<Field> filter) {
        HashSet<String> allFields = new HashSet<String>();
        ParserUtils.getAllAttributes(classToInspect, allFields, FIELD_TO_NAME, filter);
        return allFields;
    }
}

