/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.processor.http.matcher.HostMatcher;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostnameMatcher
extends HostMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostnameMatcher.class);
    private String host;
    private boolean allowSubDomains = false;

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.host == null) {
            validationErrors.add(new ConfigurationException("No host defined: " + this.getClass().getName()));
        }
    }

    @Override
    protected Optional<Boolean> tryOverrideValidation(MatchInfo matchInfo) {
        String host = matchInfo.getHost();
        if (host == MatchInfo.ANY_HOST) {
            return Optional.empty();
        }
        if (this.isHostnameMatch(host)) {
            return Optional.empty();
        }
        return Optional.of(false);
    }

    private boolean isHostnameMatch(String host) {
        boolean match = this.host.equalsIgnoreCase(host);
        if (this.allowSubDomains && !match) {
            match = host.toLowerCase().endsWith("." + this.host);
        }
        return match;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HostnameMatcher");
        sb.append("{host='").append(this.host).append('\'');
        sb.append(", allowSubDomains=").append(this.allowSubDomains);
        if (this.port >= 0) {
            sb.append(", port=").append(this.port);
        }
        if (this.pathRegex != null) {
            sb.append(", pathRegexp=").append(this.pathRegex);
        }
        sb.append(", reject=").append(this.isReject());
        sb.append('}');
        return sb.toString();
    }

    public void setHost(String host) {
        this.host = host != null ? host.toLowerCase() : null;
    }

    public void setAllowSubDomains(boolean allowSubDomains) {
        this.allowSubDomains = allowSubDomains;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostnameMatcher that = (HostnameMatcher)o;
        return this.allowSubDomains == that.allowSubDomains && Objects.equals(this.host, that.host);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.host, this.allowSubDomains);
    }
}

