/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.mapfish.print.ImageUtils;
import org.mapfish.print.StatsUtils;
import org.mapfish.print.attribute.LegendAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.http.Utils;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.http.MfClientHttpRequestFactoryProvider;
import org.mapfish.print.processor.jasper.ImagesSubReport;
import org.mapfish.print.processor.jasper.JasperReportBuilder;
import org.mapfish.print.processor.jasper.TableDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class LegendProcessor
extends AbstractProcessor<Input, Output> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegendProcessor.class);
    private static final String NAME_COLUMN = "name";
    private static final String ICON_COLUMN = "icon";
    private static final String REPORT_COLUMN = "report";
    private static final String LEVEL_COLUMN = "level";
    @Autowired
    private JasperReportBuilder jasperReportBuilder;
    @Autowired
    private MetricRegistry metricRegistry;
    @Resource(name="requestForkJoinPool")
    private ForkJoinPool requestForkJoinPool;
    private Dimension missingImageSize = new Dimension(24, 24);
    private BufferedImage missingImage;
    private Color missingImageColor = Color.PINK;
    private String template;
    private Integer maxWidth = null;
    private Double dpi = 72.0;
    private boolean scaled = false;

    protected LegendProcessor() {
        super(Output.class);
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setDpi(Double dpi) {
        this.dpi = dpi;
    }

    public void setScaled(boolean scaled) {
        this.scaled = scaled;
    }

    @Override
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    public Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        ArrayList<Object[]> legendList = new ArrayList<Object[]>();
        String[] legendColumns = new String[]{NAME_COLUMN, ICON_COLUMN, REPORT_COLUMN, LEVEL_COLUMN};
        LegendAttribute.LegendAttributeValue legendAttributes = values.legend;
        this.fillLegend(values.clientHttpRequestFactoryProvider.get(), legendAttributes, legendList, context, values.tempTaskDirectory);
        Object[][] legend = new Object[legendList.size()][];
        JRTableModelDataSource dataSource = new JRTableModelDataSource((TableModel)new TableDataSource(legendColumns, (Object[][])legendList.toArray((T[])legend)));
        String compiledTemplatePath = this.compileTemplate(values.template.getConfiguration());
        return new Output(dataSource, legendList.size(), compiledTemplatePath);
    }

    private String compileTemplate(Configuration configuration) throws JRException {
        if (this.template != null) {
            File file = new File(configuration.getDirectory(), this.template);
            return this.jasperReportBuilder.compileJasperReport(configuration, file).getAbsolutePath();
        }
        return null;
    }

    private void createTasks(MfClientHttpRequestFactory clientHttpRequestFactory, LegendAttribute.LegendAttributeValue legendAttributes, Processor.ExecutionContext context, File tempTaskDirectory, int level, List<Callable<Object[]>> tasks) {
        int insertNameIndex = tasks.size();
        URL[] icons = legendAttributes.icons;
        double dpi = legendAttributes.dpi != null ? legendAttributes.dpi : this.dpi;
        if (icons != null && icons.length > 0) {
            for (URL icon : icons) {
                tasks.add(new IconTask(icon, dpi, context, level, tempTaskDirectory, clientHttpRequestFactory));
            }
        }
        if (legendAttributes.classes != null) {
            for (LegendAttribute.LegendAttributeValue value : legendAttributes.classes) {
                this.createTasks(clientHttpRequestFactory, value, context, tempTaskDirectory, level + 1, tasks);
            }
        }
        if (!tasks.isEmpty()) {
            tasks.add(insertNameIndex, new NameTask(legendAttributes.name, level));
        }
    }

    private void fillLegend(MfClientHttpRequestFactory clientHttpRequestFactory, LegendAttribute.LegendAttributeValue legendAttributes, List<Object[]> legendList, Processor.ExecutionContext context, File tempTaskDirectory) throws ExecutionException, InterruptedException {
        ArrayList<Callable<Object[]>> tasks = new ArrayList<Callable<Object[]>>();
        this.createTasks(clientHttpRequestFactory, legendAttributes, context, tempTaskDirectory, 0, tasks);
        List<Future<Object[]>> futures = this.requestForkJoinPool.invokeAll(tasks);
        for (Future<Object[]> future : futures) {
            legendList.add(future.get());
        }
    }

    private URI createSubReport(BufferedImage originalImage, double originalImageDPI, File tempTaskDirectory) throws IOException, JRException {
        BufferedImage image = originalImage;
        double scaleFactor = 1.0;
        if (this.maxWidth != null) {
            scaleFactor = 72.0 / originalImageDPI;
            if ((double)image.getWidth() * scaleFactor > (double)this.maxWidth.intValue()) {
                image = this.scaled ? this.scaleToMaxWidth(image, scaleFactor) : this.cropToMaxWidth(image, scaleFactor);
            }
        }
        URI imageFile = this.writeToFile(image, tempTaskDirectory);
        ImagesSubReport subReport = new ImagesSubReport(Collections.singletonList(imageFile), new Dimension((int)Math.round((double)image.getWidth() * scaleFactor), (int)Math.round((double)image.getHeight() * scaleFactor)), this.dpi);
        File compiledReport = File.createTempFile("legend-report-", ".jasper", tempTaskDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }

    private BufferedImage cropToMaxWidth(BufferedImage image, double scaleFactor) {
        int width = (int)Math.round((double)this.maxWidth.intValue() / scaleFactor);
        return image.getSubimage(0, 0, width, image.getHeight());
    }

    private BufferedImage scaleToMaxWidth(BufferedImage image, double scaleFactor) {
        double factor = (double)this.maxWidth.intValue() / scaleFactor / (double)image.getWidth();
        BufferedImage result = new BufferedImage((int)Math.round((double)image.getWidth() * factor), (int)Math.round((double)image.getHeight() * factor), image.getType() == 13 || image.getType() == 12 ? 6 : image.getType());
        AffineTransform at = new AffineTransform();
        at.scale(factor, factor);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        return scaleOp.filter(image, result);
    }

    private URI writeToFile(BufferedImage image, File tempTaskDirectory) throws IOException {
        File path = File.createTempFile("legend-", ".png", tempTaskDirectory);
        ImageUtils.writeImage(image, "png", path);
        return path.toURI();
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    private synchronized BufferedImage getMissingImage() {
        if (this.missingImage == null) {
            this.missingImage = new BufferedImage(this.missingImageSize.width, this.missingImageSize.height, 1);
            Graphics2D graphics = this.missingImage.createGraphics();
            try {
                graphics.setBackground(this.missingImageColor);
                graphics.clearRect(0, 0, this.missingImageSize.width, this.missingImageSize.height);
            }
            finally {
                graphics.dispose();
            }
        }
        return this.missingImage;
    }

    private final class IconTask
    implements Callable<Object[]> {
        private URL icon;
        private double iconDPI;
        private Processor.ExecutionContext context;
        private MfClientHttpRequestFactory clientHttpRequestFactory;
        private int level;
        private File tempTaskDirectory;

        private IconTask(URL icon, double iconDPI, Processor.ExecutionContext context, int level, File tempTaskDirectory, MfClientHttpRequestFactory clientHttpRequestFactory) {
            this.icon = icon;
            this.iconDPI = iconDPI;
            this.context = context;
            this.level = level;
            this.clientHttpRequestFactory = clientHttpRequestFactory;
            this.tempTaskDirectory = tempTaskDirectory;
        }

        @Override
        public Object[] call() throws Exception {
            return this.context.mdcContextEx(() -> {
                BufferedImage image = null;
                URI uri = this.icon.toURI();
                String metricName = LegendProcessor.class.getName() + ".read." + StatsUtils.quotePart(uri.getHost());
                try {
                    this.context.stopIfCanceled();
                    ClientHttpRequest request = this.clientHttpRequestFactory.createRequest(uri, HttpMethod.GET);
                    Timer.Context timer = LegendProcessor.this.metricRegistry.timer(metricName).time();
                    try (ClientHttpResponse httpResponse = request.execute();){
                        if (httpResponse.getStatusCode() == HttpStatus.OK) {
                            image = ImageIO.read(httpResponse.getBody());
                            if (image == null) {
                                LOGGER.warn("The URL: {} is NOT an image format that can be decoded", (Object)this.icon);
                            } else {
                                timer.stop();
                            }
                        } else {
                            LOGGER.warn("Failed to load image from: {} due to server side error.\n\tResponse Code: {}\n\tResponse Text: {}\n\tWith Headers:\n\t{}", new Object[]{this.icon, httpResponse.getStatusCode(), httpResponse.getStatusText(), String.join((CharSequence)"\n\t", Utils.getPrintableHeadersList((Map<String, List<String>>)httpResponse.getHeaders()))});
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load image from: {}", (Object)this.icon, (Object)e);
                }
                if (image == null) {
                    image = LegendProcessor.this.getMissingImage();
                    LegendProcessor.this.metricRegistry.counter(metricName + ".error").inc();
                }
                String report = LegendProcessor.this.createSubReport(image, this.iconDPI, this.tempTaskDirectory).toString();
                return new Object[]{null, image, report, this.level};
            });
        }
    }

    private static final class NameTask
    implements Callable<Object[]> {
        private String name;
        private int level;

        private NameTask(String name, int level) {
            this.name = name;
            this.level = level;
        }

        @Override
        public Object[] call() {
            return new Object[]{this.name, null, null, this.level};
        }
    }

    public static final class Output {
        public final JRTableModelDataSource legendDataSource;
        public final String legendSubReport;
        public final int numberOfLegendRows;

        Output(JRTableModelDataSource legendDataSource, int numberOfLegendRows, String legendSubReport) {
            this.legendDataSource = legendDataSource;
            this.numberOfLegendRows = numberOfLegendRows;
            this.legendSubReport = legendSubReport;
        }
    }

    public static final class Input {
        public Template template;
        public MfClientHttpRequestFactoryProvider clientHttpRequestFactoryProvider;
        public File tempTaskDirectory;
        public LegendAttribute.LegendAttributeValue legend;
    }
}

