/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfree.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.Constants;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.processor.http.matcher.UriMatchers;
import org.mapfish.print.servlet.BaseMapServlet;
import org.mapfish.print.servlet.HandleReportLoadResult;
import org.mapfish.print.servlet.NoSuchAppException;
import org.mapfish.print.servlet.ServletInfo;
import org.mapfish.print.servlet.job.JobManager;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.PrintJobEntryImpl;
import org.mapfish.print.servlet.job.loader.ReportLoader;
import org.mapfish.print.url.data.Handler;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MapPrinterServlet
extends BaseMapServlet {
    public static final String CAPABILITIES_URL = "/capabilities.json";
    public static final String LIST_APPS_URL = "/apps.json";
    public static final String EXAMPLE_REQUEST_URL = "/exampleRequest.json";
    public static final String CREATE_AND_GET_URL = "/buildreport";
    public static final String STATUS_URL = "/status";
    public static final String CANCEL_URL = "/cancel";
    public static final String REPORT_URL = "/report";
    public static final String FONTS_URL = "/fonts";
    public static final String JSON_ERROR = "error";
    public static final String JSON_APP = "app";
    public static final String JSON_DONE = "done";
    public static final String JSON_STATUS = "status";
    public static final String JSON_ELAPSED_TIME = "elapsedTime";
    public static final String JSON_WAITING_TIME = "waitingTime";
    public static final String JSON_PRINT_JOB_REF = "ref";
    public static final String JSON_STATUS_LINK = "statusURL";
    public static final String JSON_DOWNLOAD_LINK = "downloadURL";
    public static final String JSON_OUTPUT_FORMAT = "outputFormat";
    public static final String JSON_ATTRIBUTES = "attributes";
    public static final String JSON_REQUEST_HEADERS = "requestHeaders";
    private static final Logger LOGGER = LoggerFactory.getLogger(MapPrinterServlet.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{(\\S+)}");
    private static final int JSON_INDENT_FACTOR = 4;
    private static final List<String> REQUEST_ID_HEADERS = Arrays.asList("X-Request-ID", "X-Correlation-ID", "Request-ID", "X-Varnish", "X-Amzn-Trace-Id");
    private final JobManager jobManager;
    private final List<ReportLoader> reportLoaders;
    private final MapPrinterFactory printerFactory;
    private final ApplicationContext context;
    private final ServletInfo servletInfo;
    private final MapPrinterFactory mapPrinterFactory;
    private long maxCreateAndGetWaitTimeInSeconds;

    @Autowired
    public MapPrinterServlet(JobManager jobManager, List<ReportLoader> reportLoaders, MapPrinterFactory printerFactory, ApplicationContext context, ServletInfo servletInfo, MapPrinterFactory mapPrinterFactory) {
        this.jobManager = jobManager;
        this.reportLoaders = reportLoaders;
        this.printerFactory = printerFactory;
        this.context = context;
        this.servletInfo = servletInfo;
        this.mapPrinterFactory = mapPrinterFactory;
    }

    private static PJsonObject parseJson(String requestDataRaw, HttpServletResponse httpServletResponse) {
        try {
            if (requestDataRaw == null) {
                MapPrinterServlet.error(httpServletResponse, "Missing post data.  The post payload must either be a form post with a spec parameter or must be a raw json post with the request.", HttpStatus.INTERNAL_SERVER_ERROR);
                return null;
            }
            String requestData = requestDataRaw;
            if (!requestData.startsWith("spec=") && !requestData.startsWith("{")) {
                try {
                    requestData = URLDecoder.decode(requestData, Constants.DEFAULT_ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    throw ExceptionUtils.getRuntimeException(e);
                }
            }
            if (requestData.startsWith("spec=")) {
                requestData = requestData.substring("spec=".length());
            }
            try {
                return MapPrinter.parseSpec(requestData);
            }
            catch (RuntimeException e) {
                try {
                    return MapPrinter.parseSpec(URLDecoder.decode(requestData, Constants.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException uee) {
                    throw ExceptionUtils.getRuntimeException(e);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error parsing request data: {}", (Object)requestDataRaw);
            throw e;
        }
    }

    private static String maybeAddRequestId(String ref, HttpServletRequest request) {
        Optional<String> headerName = REQUEST_ID_HEADERS.stream().filter(h -> request.getHeader(h) != null).findFirst();
        return headerName.map(s -> ref + "@" + request.getHeader(s).replaceAll("[^a-zA-Z0-9._:-]", "_")).orElse(ref);
    }

    @RequestMapping(value={"/{appId}/status/{referenceId:\\S+}.json"}, method={RequestMethod.GET})
    public final void getStatusSpecificAppId(@PathVariable String appId, @PathVariable String referenceId, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletRequest statusRequest, HttpServletResponse statusResponse) {
        this.getStatus(referenceId, jsonpCallback, statusRequest, statusResponse);
    }

    @RequestMapping(value={"/status/{referenceId:\\S+}.json"}, method={RequestMethod.GET})
    public final void getStatus(@PathVariable String referenceId, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletRequest statusRequest, HttpServletResponse statusResponse) {
        MDC.put((String)"job_id", (String)referenceId);
        MapPrinterServlet.setNoCache(statusResponse);
        try {
            PrintJobStatus status = this.jobManager.getStatus(referenceId);
            this.setContentType(statusResponse, jsonpCallback);
            try (PrintWriter writer = statusResponse.getWriter();){
                this.appendJsonpCallback(jsonpCallback, writer);
                JSONWriter json = new JSONWriter((Appendable)writer);
                json.object();
                json.key(JSON_DONE).value(status.isDone());
                json.key(JSON_STATUS).value((Object)status.getStatus().toString().toLowerCase());
                json.key(JSON_ELAPSED_TIME).value(status.getElapsedTime());
                json.key(JSON_WAITING_TIME).value(status.getWaitingTime());
                if (!StringUtils.isEmpty((CharSequence)status.getError())) {
                    json.key(JSON_ERROR).value((Object)status.getError());
                }
                this.addDownloadLinkToJson(statusRequest, referenceId, json);
                json.endObject();
                this.appendJsonpCallbackEnd(jsonpCallback, writer);
            }
        }
        catch (IOException | JSONException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
        catch (NoSuchReferenceException e) {
            MapPrinterServlet.error(statusResponse, e.getMessage(), HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/{appId}/cancel/{referenceId:\\S+}"}, method={RequestMethod.DELETE})
    public final void cancelSpecificAppId(@PathVariable String appId, @PathVariable String referenceId, HttpServletResponse statusResponse) {
        this.cancel(referenceId, statusResponse);
    }

    @RequestMapping(value={"/cancel/{referenceId:\\S+}"}, method={RequestMethod.DELETE})
    public final void cancel(@PathVariable String referenceId, HttpServletResponse statusResponse) {
        MDC.put((String)"job_id", (String)referenceId);
        MapPrinterServlet.setNoCache(statusResponse);
        try {
            this.jobManager.cancel(referenceId);
        }
        catch (NoSuchReferenceException e) {
            MapPrinterServlet.error(statusResponse, e.getMessage(), HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/{appId}/report.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReport(@PathVariable String appId, @PathVariable String format, @RequestBody String requestData, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws NoSuchAppException {
        MapPrinterServlet.setNoCache(createReportResponse);
        String ref = this.createAndSubmitPrintJob(appId, format, requestData, createReportRequest, createReportResponse);
        if (ref == null) {
            MapPrinterServlet.error(createReportResponse, "Failed to create a print job", HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        createReportResponse.setContentType("application/json; charset=utf-8");
        try (PrintWriter writer = createReportResponse.getWriter();){
            JSONWriter json = new JSONWriter((Appendable)writer);
            json.object();
            json.key(JSON_PRINT_JOB_REF).value((Object)ref);
            String statusURL = this.getBaseUrl(createReportRequest) + STATUS_URL + "/" + ref + ".json";
            json.key(JSON_STATUS_LINK).value((Object)statusURL);
            this.addDownloadLinkToJson(createReportRequest, ref, json);
            json.endObject();
        }
        catch (IOException | JSONException e) {
            LOGGER.warn("Error generating the JSON response", e);
        }
    }

    @RequestMapping(value={"/{appId}/report/{referenceId:\\S+}"}, method={RequestMethod.GET})
    public final void getReportSpecificAppId(@PathVariable String appId, @PathVariable String referenceId, @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletResponse getReportResponse) throws IOException, ServletException {
        this.getReport(referenceId, inline, getReportResponse);
    }

    @RequestMapping(value={"/report/{referenceId:\\S+}"}, method={RequestMethod.GET})
    public final void getReport(@PathVariable String referenceId, final @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletResponse getReportResponse) throws IOException, ServletException {
        MDC.put((String)"job_id", (String)referenceId);
        MapPrinterServlet.setNoCache(getReportResponse);
        this.loadReport(referenceId, getReportResponse, new HandleReportLoadResult<Void>(){

            @Override
            public Void unknownReference(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Error getting print with ref=" + referenceId + ": unknown reference", HttpStatus.NOT_FOUND);
                return null;
            }

            @Override
            public Void unsupportedLoader(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Error getting print with ref=" + referenceId + " can not be loaded", HttpStatus.NOT_FOUND);
                return null;
            }

            @Override
            public Void successfulPrint(PrintJobStatus successfulPrintResult, HttpServletResponse httpServletResponse, URI reportURI, ReportLoader loader) throws IOException {
                MapPrinterServlet.this.sendReportFile(successfulPrintResult, httpServletResponse, loader, reportURI, inline);
                return null;
            }

            @Override
            public Void failedPrint(PrintJobStatus failedPrintJob, HttpServletResponse httpServletResponse) {
                BaseMapServlet.error(httpServletResponse, failedPrintJob.getError(), HttpStatus.INTERNAL_SERVER_ERROR);
                return null;
            }

            @Override
            public Void printJobPending(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Report has not yet completed processing", HttpStatus.ACCEPTED);
                return null;
            }
        });
    }

    @RequestMapping(value={"/report.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReport(@PathVariable String format, @RequestBody String requestData, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws NoSuchAppException {
        MapPrinterServlet.setNoCache(createReportResponse);
        PJsonObject spec = MapPrinterServlet.parseJson(requestData, createReportResponse);
        if (spec == null) {
            return;
        }
        String appId = spec.optString(JSON_APP, "default");
        this.createReport(appId, format, requestData, createReportRequest, createReportResponse);
    }

    @RequestMapping(value={"/{appId}/buildreport.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReportAndGet(@PathVariable String appId, @PathVariable String format, @RequestBody String requestData, final @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws IOException, ServletException, InterruptedException, NoSuchAppException {
        MapPrinterServlet.setNoCache(createReportResponse);
        String ref = this.createAndSubmitPrintJob(appId, format, requestData, createReportRequest, createReportResponse);
        if (ref == null) {
            MapPrinterServlet.error(createReportResponse, "Failed to create a print job", HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        HandleReportLoadResult<Boolean> handler = new HandleReportLoadResult<Boolean>(){

            @Override
            public Boolean unknownReference(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Print with ref=" + referenceId + " unknown", HttpStatus.NOT_FOUND);
                return true;
            }

            @Override
            public Boolean unsupportedLoader(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Print with ref=" + referenceId + " can not be loaded", HttpStatus.NOT_FOUND);
                return true;
            }

            @Override
            public Boolean successfulPrint(PrintJobStatus successfulPrintResult, HttpServletResponse httpServletResponse, URI reportURI, ReportLoader loader) throws IOException {
                MapPrinterServlet.this.sendReportFile(successfulPrintResult, httpServletResponse, loader, reportURI, inline);
                return true;
            }

            @Override
            public Boolean failedPrint(PrintJobStatus failedPrintJob, HttpServletResponse httpServletResponse) {
                BaseMapServlet.error(httpServletResponse, failedPrintJob.getError(), HttpStatus.INTERNAL_SERVER_ERROR);
                return true;
            }

            @Override
            public Boolean printJobPending(HttpServletResponse httpServletResponse, String referenceId) {
                return false;
            }
        };
        boolean isDone = false;
        long startWaitTime = System.currentTimeMillis();
        long maxWaitTimeInMillis = TimeUnit.SECONDS.toMillis(this.maxCreateAndGetWaitTimeInSeconds);
        while (!isDone && System.currentTimeMillis() - startWaitTime < maxWaitTimeInMillis) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            isDone = this.loadReport(ref, createReportResponse, handler);
        }
    }

    @RequestMapping(value={"/buildreport.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReportAndGetNoAppId(@PathVariable String format, @RequestBody String requestData, @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws IOException, ServletException, InterruptedException, NoSuchAppException {
        MapPrinterServlet.setNoCache(createReportResponse);
        PJsonObject spec = MapPrinterServlet.parseJson(requestData, createReportResponse);
        if (spec == null) {
            return;
        }
        String appId = spec.optString(JSON_APP, "default");
        this.createReportAndGet(appId, format, requestData, inline, createReportRequest, createReportResponse);
    }

    @RequestMapping(value={"/apps.json"}, method={RequestMethod.GET})
    public final void listAppIds(@RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletResponse listAppsResponse) throws ServletException, IOException {
        MDC.remove((String)"job_id");
        this.setCache(listAppsResponse);
        Set<String> appIds = this.printerFactory.getAppIds();
        this.setContentType(listAppsResponse, jsonpCallback);
        try (PrintWriter writer = listAppsResponse.getWriter();){
            this.appendJsonpCallback(jsonpCallback, writer);
            JSONWriter json = new JSONWriter((Appendable)writer);
            try {
                json.array();
                for (String appId : appIds) {
                    json.value((Object)appId);
                }
                json.endArray();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
            this.appendJsonpCallbackEnd(jsonpCallback, writer);
        }
    }

    @RequestMapping(value={"/capabilities.json"}, method={RequestMethod.GET})
    public final void getCapabilities(@RequestParam(value="pretty", defaultValue="false") boolean pretty, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletRequest request, HttpServletResponse capabilitiesResponse) throws ServletException, IOException {
        this.getCapabilities("default", pretty, jsonpCallback, request, capabilitiesResponse);
    }

    @RequestMapping(value={"/{appId}/capabilities.json"}, method={RequestMethod.GET})
    public final void getCapabilities(@PathVariable String appId, @RequestParam(value="pretty", defaultValue="false") boolean pretty, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletRequest request, HttpServletResponse capabilitiesResponse) throws ServletException, IOException {
        MapPrinter printer;
        MDC.remove((String)"job_id");
        this.setCache(capabilitiesResponse);
        try {
            printer = this.printerFactory.create(appId);
            if (!this.checkReferer(request, printer)) {
                MapPrinterServlet.error(capabilitiesResponse, "Invalid referer", HttpStatus.FORBIDDEN);
                return;
            }
        }
        catch (NoSuchAppException e) {
            MapPrinterServlet.error(capabilitiesResponse, e.getMessage(), HttpStatus.NOT_FOUND);
            return;
        }
        this.setContentType(capabilitiesResponse, jsonpCallback);
        ByteArrayOutputStream prettyPrintBuffer = new ByteArrayOutputStream();
        try (Writer writer = pretty ? new OutputStreamWriter((OutputStream)prettyPrintBuffer, Constants.DEFAULT_CHARSET) : capabilitiesResponse.getWriter();){
            if (!pretty && !StringUtils.isEmpty((CharSequence)jsonpCallback)) {
                writer.append(jsonpCallback).append("(");
            }
            JSONWriter json = new JSONWriter((Appendable)writer);
            try {
                json.object();
                json.key(JSON_APP).value((Object)appId);
                printer.printClientConfig(json);
                json.key("formats");
                Set<String> formats = printer.getOutputFormatsNames();
                json.array();
                for (String format : formats) {
                    json.value((Object)format);
                }
                json.endArray();
                json.endObject();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
            if (!pretty && !StringUtils.isEmpty((CharSequence)jsonpCallback)) {
                writer.append(");");
            }
        }
        if (pretty) {
            JSONObject jsonObject = new JSONObject(new String(prettyPrintBuffer.toByteArray(), Constants.DEFAULT_CHARSET));
            if (!StringUtils.isEmpty((CharSequence)jsonpCallback)) {
                capabilitiesResponse.getOutputStream().print(jsonpCallback + "(");
            }
            capabilitiesResponse.getOutputStream().print(jsonObject.toString(4));
            if (!StringUtils.isEmpty((CharSequence)jsonpCallback)) {
                capabilitiesResponse.getOutputStream().print(");");
            }
        }
    }

    @RequestMapping(value={"/exampleRequest.json"}, method={RequestMethod.GET})
    public final void getExampleRequest(@RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletRequest request, HttpServletResponse getExampleResponse) throws IOException {
        this.getExampleRequest("default", jsonpCallback, request, getExampleResponse);
    }

    @RequestMapping(value={"{appId}/exampleRequest.json"}, method={RequestMethod.GET})
    public final void getExampleRequest(@PathVariable String appId, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletRequest request, HttpServletResponse getExampleResponse) throws IOException {
        MDC.remove((String)"job_id");
        this.setCache(getExampleResponse);
        try {
            String result;
            MapPrinter mapPrinter = this.printerFactory.create(appId);
            if (!this.checkReferer(request, mapPrinter)) {
                MapPrinterServlet.error(getExampleResponse, "Invalid referer", HttpStatus.FORBIDDEN);
                return;
            }
            String requestDataPrefix = "requestData";
            File[] children = mapPrinter.getConfiguration().getDirectory().listFiles((dir, name) -> name.startsWith("requestData") && name.endsWith(".json"));
            if (children == null) {
                MapPrinterServlet.error(getExampleResponse, "Cannot find the config directory", HttpStatus.NOT_FOUND);
                return;
            }
            JSONObject allExamples = new JSONObject();
            for (File child : children) {
                if (!child.isFile()) continue;
                String requestData = new String(Files.readAllBytes(child.toPath()), Constants.DEFAULT_CHARSET);
                try {
                    JSONObject jsonObject = new JSONObject(requestData);
                    jsonObject.remove(JSON_OUTPUT_FORMAT);
                    jsonObject.remove(JSON_APP);
                    requestData = jsonObject.toString(4);
                    this.setContentType(getExampleResponse, jsonpCallback);
                }
                catch (JSONException jsonObject) {
                    // empty catch block
                }
                String name2 = child.getName();
                name2 = name2.substring("requestData".length());
                if (name2.startsWith("-")) {
                    name2 = name2.substring(1);
                }
                name2 = FilenameUtils.removeExtension((String)name2);
                if ((name2 = name2.trim()).isEmpty()) {
                    name2 = FilenameUtils.removeExtension((String)child.getName());
                }
                try {
                    allExamples.put(name2, (Object)requestData);
                }
                catch (JSONException e) {
                    Log.error((Object)"Error translating object to json", (Exception)((Object)e));
                    MapPrinterServlet.error(getExampleResponse, "Error translating object to json: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                    return;
                }
            }
            try {
                result = allExamples.toString(4);
            }
            catch (JSONException e) {
                Log.error((Object)"Error translating object to json", (Exception)((Object)e));
                MapPrinterServlet.error(getExampleResponse, "Error translating object to json: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            try (PrintWriter writer = getExampleResponse.getWriter();){
                this.appendJsonpCallback(jsonpCallback, writer);
                writer.append(result);
                this.appendJsonpCallbackEnd(jsonpCallback, writer);
            }
        }
        catch (NoSuchAppException e) {
            MapPrinterServlet.error(getExampleResponse, "No print app identified by: " + appId, HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/fonts"})
    @ResponseBody
    public final String listAvailableFonts() {
        MDC.remove((String)"job_id");
        JSONArray availableFonts = new JSONArray();
        List families = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontFamily.class);
        for (FontFamily family : families) {
            availableFonts.put((Object)family.getName());
        }
        return availableFonts.toString();
    }

    public final void setMaxCreateAndGetWaitTimeInSeconds(long maxCreateAndGetWaitTimeInSeconds) {
        this.maxCreateAndGetWaitTimeInSeconds = maxCreateAndGetWaitTimeInSeconds;
    }

    private void sendReportFile(PrintJobStatus metadata, HttpServletResponse httpServletResponse, ReportLoader reportLoader, URI reportURI, boolean inline) throws IOException {
        try (ServletOutputStream response = httpServletResponse.getOutputStream();){
            httpServletResponse.setContentType(metadata.getResult().getMimeType());
            if (!inline) {
                String fileName = metadata.getResult().getFileName();
                Matcher matcher = VARIABLE_PATTERN.matcher(fileName);
                while (matcher.find()) {
                    String variable = matcher.group(1);
                    String replacement = MapPrinterServlet.findReplacement(variable, metadata.getCompletionDate());
                    fileName = fileName.replace("${" + variable + "}", replacement);
                    matcher = VARIABLE_PATTERN.matcher(fileName);
                }
                fileName = fileName + "." + metadata.getResult().getFileExtension();
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + MapPrinterServlet.cleanUpName(fileName));
            }
            reportLoader.loadReport(reportURI, (OutputStream)response);
        }
    }

    private void addDownloadLinkToJson(HttpServletRequest httpServletRequest, String ref, JSONWriter json) {
        String downloadURL = this.getBaseUrl(httpServletRequest) + REPORT_URL + "/" + ref;
        json.key(JSON_DOWNLOAD_LINK).value((Object)downloadURL);
    }

    protected final JSONObject getHeaders(HttpServletRequest httpServletRequest) {
        Enumeration headersName = httpServletRequest.getHeaderNames();
        JSONObject headers = new JSONObject();
        while (headersName.hasMoreElements()) {
            String name = headersName.nextElement().toString();
            Enumeration e = httpServletRequest.getHeaders(name);
            while (e.hasMoreElements()) {
                headers.append(name, e.nextElement());
            }
        }
        JSONObject requestHeadersAttribute = new JSONObject();
        requestHeadersAttribute.put(JSON_REQUEST_HEADERS, (Object)headers);
        return requestHeadersAttribute;
    }

    private String createAndSubmitPrintJob(String appId, String format, String requestDataRaw, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NoSuchAppException {
        PJsonObject specJson = MapPrinterServlet.parseJson(requestDataRaw, httpServletResponse);
        if (specJson == null) {
            return null;
        }
        String ref = MapPrinterServlet.maybeAddRequestId(UUID.randomUUID().toString() + "@" + this.servletInfo.getServletId(), httpServletRequest);
        MDC.put((String)"job_id", (String)ref);
        LOGGER.debug("{}", (Object)specJson);
        specJson.getInternalObj().remove(JSON_OUTPUT_FORMAT);
        specJson.getInternalObj().put(JSON_OUTPUT_FORMAT, (Object)format);
        specJson.getInternalObj().remove(JSON_APP);
        specJson.getInternalObj().put(JSON_APP, (Object)appId);
        JSONObject requestHeaders = this.getHeaders(httpServletRequest);
        if (requestHeaders.length() > 0) {
            specJson.getInternalObj().getJSONObject(JSON_ATTRIBUTES).put(JSON_REQUEST_HEADERS, (Object)requestHeaders);
        }
        String templateName = specJson.getString("layout");
        MapPrinter mapPrinter = this.mapPrinterFactory.create(appId);
        this.checkReferer(httpServletRequest, mapPrinter);
        Template template = mapPrinter.getConfiguration().getTemplate(templateName);
        PrintJobEntryImpl jobEntry = new PrintJobEntryImpl(ref, specJson, System.currentTimeMillis());
        jobEntry.configureAccess(template, this.context);
        try {
            this.jobManager.submit(jobEntry);
        }
        catch (RuntimeException exc) {
            LOGGER.error("Error when creating job on {}: {}", new Object[]{appId, specJson, exc});
            ref = null;
        }
        return ref;
    }

    private boolean checkReferer(HttpServletRequest request, MapPrinter mapPrinter) {
        Configuration config = mapPrinter.getConfiguration();
        UriMatchers allowedReferers = config.getAllowedReferersImpl();
        if (allowedReferers == null) {
            return true;
        }
        String referer = request.getHeader("referer");
        if (referer == null) {
            referer = "http://localhost/";
        }
        try {
            return allowedReferers.matches(new URI(referer), HttpMethod.resolve((String)request.getMethod()));
        }
        catch (MalformedURLException | SocketException | URISyntaxException | UnknownHostException e) {
            LOGGER.error("Referer {} invalid", (Object)referer, (Object)e);
            return false;
        }
    }

    private <R> R loadReport(String referenceId, HttpServletResponse httpServletResponse, HandleReportLoadResult<R> handler) throws IOException, ServletException {
        PrintJobStatus metadata;
        try {
            metadata = this.jobManager.getStatus(referenceId);
        }
        catch (NoSuchReferenceException e) {
            return handler.unknownReference(httpServletResponse, referenceId);
        }
        if (!metadata.isDone()) {
            return handler.printJobPending(httpServletResponse, referenceId);
        }
        if (metadata.getResult() != null) {
            URI pdfURI = metadata.getResult().getReportURI();
            ReportLoader loader = null;
            for (ReportLoader reportLoader : this.reportLoaders) {
                if (!reportLoader.accepts(pdfURI)) continue;
                loader = reportLoader;
                break;
            }
            if (loader == null) {
                return handler.unsupportedLoader(httpServletResponse, referenceId);
            }
            return handler.successfulPrint(metadata, httpServletResponse, pdfURI, loader);
        }
        return handler.failedPrint(metadata, httpServletResponse);
    }

    private void setContentType(HttpServletResponse statusResponse, String jsonpCallback) {
        if (StringUtils.isEmpty((CharSequence)jsonpCallback)) {
            statusResponse.setContentType("application/json; charset=utf-8");
        } else {
            statusResponse.setContentType("application/javascript; charset=utf-8");
        }
    }

    private void appendJsonpCallback(String jsonpCallback, PrintWriter writer) {
        if (!StringUtils.isEmpty((CharSequence)jsonpCallback)) {
            writer.append(jsonpCallback);
            writer.append("(");
        }
    }

    private void appendJsonpCallbackEnd(String jsonpCallback, PrintWriter writer) {
        if (!StringUtils.isEmpty((CharSequence)jsonpCallback)) {
            writer.append(");");
        }
    }

    static {
        Handler.configureProtocolHandler();
    }
}

