/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.TextSymbolizer;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FileUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.map.style.json.MapfishJsonStyleParserPlugin;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.Fill;
import org.opengis.style.Font;

public final class JsonStyleParserHelper {
    static final String JSON_FONT_FAMILY = "fontFamily";
    static final String JSON_FONT_SIZE = "fontSize";
    static final String JSON_FONT_WEIGHT = "fontWeight";
    static final String JSON_FONT_STYLE = "fontStyle";
    static final String JSON_LABEL = "label";
    static final String JSON_LABEL_ANCHOR_POINT_X = "labelAnchorPointX";
    static final String JSON_LABEL_ANCHOR_POINT_Y = "labelAnchorPointY";
    static final String JSON_LABEL_ALIGN = "labelAlign";
    static final String JSON_LABEL_X_OFFSET = "labelXOffset";
    static final String JSON_LABEL_Y_OFFSET = "labelYOffset";
    static final String JSON_LABEL_ROTATION = "labelRotation";
    static final String JSON_LABEL_PERPENDICULAR_OFFSET = "labelPerpendicularOffset";
    static final String JSON_FILL_COLOR = "fillColor";
    static final String JSON_STROKE_COLOR = "strokeColor";
    static final String JSON_STROKE_OPACITY = "strokeOpacity";
    static final String JSON_STROKE_WIDTH = "strokeWidth";
    static final String JSON_STROKE_DASHSTYLE = "strokeDashstyle";
    static final String JSON_STROKE_LINECAP = "strokeLinecap";
    static final String JSON_FILL_OPACITY = "fillOpacity";
    static final String JSON_EXTERNAL_GRAPHIC = "externalGraphic";
    static final String JSON_GRAPHIC_NAME = "graphicName";
    static final String JSON_GRAPHIC_OPACITY = "graphicOpacity";
    static final String JSON_POINT_RADIUS = "pointRadius";
    static final String JSON_GRAPHIC_WIDTH = "graphicWidth";
    static final String JSON_ROTATION = "rotation";
    static final String JSON_HALO_RADIUS = "haloRadius";
    static final String JSON_HALO_COLOR = "haloColor";
    static final String JSON_HALO_OPACITY = "haloOpacity";
    static final String JSON_LABEL_OUTLINE_COLOR = "labelOutlineColor";
    static final String JSON_LABEL_OUTLINE_WIDTH = "labelOutlineWidth";
    static final String JSON_FONT_COLOR = "fontColor";
    static final String JSON_FONT_OPACITY = "fontOpacity";
    static final String JSON_GRAPHIC_FORMAT = "graphicFormat";
    static final String STROKE_DASHSTYLE_SOLID = "solid";
    static final String STROKE_DASHSTYLE_DOT = "dot";
    static final String STROKE_DASHSTYLE_DASH = "dash";
    static final String STROKE_DASHSTYLE_DASHDOT = "dashdot";
    static final String STROKE_DASHSTYLE_LONGDASH = "longdash";
    static final String STROKE_DASHSTYLE_LONGDASHDOT = "longdashdot";
    static final Set<Set<String>> COMPATIBLE_MIMETYPES = Sets.newIdentityHashSet();
    private static final String[] SUPPORTED_MIME_TYPES;
    private static final String DEFAULT_POINT_MARK = "circle";
    private final Configuration configuration;
    private boolean allowNullSymbolizer;
    private StyleBuilder styleBuilder;
    private MapfishJsonStyleParserPlugin.Versions version;

    public JsonStyleParserHelper(@Nonnull Configuration configuration, @Nonnull StyleBuilder styleBuilder, boolean allowNullSymbolizer, MapfishJsonStyleParserPlugin.Versions version) {
        this.configuration = configuration;
        this.styleBuilder = styleBuilder;
        this.allowNullSymbolizer = allowNullSymbolizer;
        this.version = version;
    }

    void setAllowNullSymbolizer(boolean allowNullSymbolizer) {
        this.allowNullSymbolizer = allowNullSymbolizer;
    }

    public Style createStyle(List<Rule> styleRules) {
        Rule[] rulesArray = styleRules.toArray(new Rule[styleRules.size()]);
        FeatureTypeStyle featureTypeStyle = this.styleBuilder.createFeatureTypeStyle(null, rulesArray);
        Style style = this.styleBuilder.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    @Nullable
    public PointSymbolizer createPointSymbolizer(PJsonObject styleJson) {
        Expression size;
        if (this.allowNullSymbolizer && !styleJson.has(JSON_EXTERNAL_GRAPHIC) && !styleJson.has(JSON_GRAPHIC_NAME) && !styleJson.has(JSON_POINT_RADIUS)) {
            return null;
        }
        Graphic graphic = this.styleBuilder.createGraphic();
        graphic.graphicalSymbols().clear();
        if (styleJson.has(JSON_EXTERNAL_GRAPHIC)) {
            String externalGraphicUrl = this.validateURL(styleJson.getString(JSON_EXTERNAL_GRAPHIC));
            String graphicFormat = this.getGraphicFormat(externalGraphicUrl, styleJson);
            ExternalGraphic externalGraphic = this.styleBuilder.createExternalGraphic(externalGraphicUrl, graphicFormat);
            graphic.graphicalSymbols().add(externalGraphic);
        }
        if (styleJson.has(JSON_GRAPHIC_NAME)) {
            Expression graphicName = this.parseProperty(styleJson.getString(JSON_GRAPHIC_NAME), new Function<String, Object>(){

                public Object apply(String input) {
                    return input;
                }
            });
            org.geotools.styling.Fill fill = this.createFill(styleJson);
            Stroke stroke = this.createStroke(styleJson, false);
            Mark mark = this.styleBuilder.createMark(graphicName, fill, stroke);
            graphic.graphicalSymbols().add(mark);
        }
        if (graphic.graphicalSymbols().isEmpty()) {
            org.geotools.styling.Fill fill = this.createFill(styleJson);
            Stroke stroke = this.createStroke(styleJson, false);
            Mark mark = this.styleBuilder.createMark(DEFAULT_POINT_MARK, fill, stroke);
            graphic.graphicalSymbols().add(mark);
        }
        graphic.setOpacity(this.parseExpression(null, styleJson, JSON_GRAPHIC_OPACITY, new Function<String, Object>(){

            @Nullable
            public Object apply(String opacityString) {
                return Double.parseDouble(opacityString);
            }
        }));
        if (!Strings.isNullOrEmpty((String)styleJson.optString(JSON_POINT_RADIUS))) {
            size = this.parseExpression(null, styleJson, JSON_POINT_RADIUS, new Function<String, Object>(){

                @Nullable
                public Object apply(String input) {
                    return Double.parseDouble(input) * 2.0;
                }
            });
            graphic.setSize(size);
        } else if (!Strings.isNullOrEmpty((String)styleJson.optString(JSON_GRAPHIC_WIDTH))) {
            size = this.parseExpression(null, styleJson, JSON_GRAPHIC_WIDTH, new Function<String, Object>(){

                @Nullable
                public Object apply(String input) {
                    return Double.parseDouble(input);
                }
            });
            graphic.setSize(size);
        }
        if (!Strings.isNullOrEmpty((String)styleJson.optString(JSON_ROTATION))) {
            Expression rotation = this.parseExpression(null, styleJson, JSON_ROTATION, new Function<String, Object>(){

                @Nullable
                public Object apply(String rotation) {
                    return Double.parseDouble(rotation);
                }
            });
            graphic.setRotation(rotation);
        }
        return this.styleBuilder.createPointSymbolizer(graphic);
    }

    private String validateURL(String externalGraphicUrl) {
        try {
            new URL(externalGraphicUrl);
        }
        catch (MalformedURLException e) {
            try {
                URL fileURL = new URL("file://" + externalGraphicUrl);
                return FileUtils.testForLegalFileUrl(this.configuration, fileURL).toExternalForm();
            }
            catch (MalformedURLException e1) {
                throw ExceptionUtils.getRuntimeException(e);
            }
        }
        return externalGraphicUrl;
    }

    @Nullable
    @VisibleForTesting
    protected LineSymbolizer createLineSymbolizer(PJsonObject styleJson) {
        Stroke stroke = this.createStroke(styleJson, true);
        if (stroke == null) {
            return null;
        }
        return this.styleBuilder.createLineSymbolizer(stroke);
    }

    @Nullable
    @VisibleForTesting
    protected PolygonSymbolizer createPolygonSymbolizer(PJsonObject styleJson) {
        if (this.allowNullSymbolizer && !styleJson.has(JSON_FILL_COLOR)) {
            return null;
        }
        PolygonSymbolizer symbolizer = this.styleBuilder.createPolygonSymbolizer();
        symbolizer.setFill((Fill)this.createFill(styleJson));
        symbolizer.setStroke((org.opengis.style.Stroke)this.createStroke(styleJson, false));
        return symbolizer;
    }

    @VisibleForTesting
    protected TextSymbolizer createTextSymbolizer(PJsonObject styleJson) {
        TextSymbolizer textSymbolizer = this.styleBuilder.createTextSymbolizer();
        if (!styleJson.has(JSON_LABEL)) {
            return null;
        }
        Expression label = this.parseExpression(null, styleJson, JSON_LABEL, new Function<String, Object>(){

            @Nullable
            public Object apply(String labelValue) {
                return labelValue.replace("${", "").replace("}", "");
            }
        });
        textSymbolizer.setLabel(label);
        textSymbolizer.setFont((Font)this.createFont(textSymbolizer.getFont(), styleJson));
        if (styleJson.has(JSON_LABEL_ANCHOR_POINT_X) || styleJson.has(JSON_LABEL_ANCHOR_POINT_Y) || styleJson.has(JSON_LABEL_ALIGN) || styleJson.has(JSON_LABEL_X_OFFSET) || styleJson.has(JSON_LABEL_Y_OFFSET) || styleJson.has(JSON_LABEL_ROTATION) || styleJson.has(JSON_LABEL_PERPENDICULAR_OFFSET)) {
            textSymbolizer.setLabelPlacement((org.opengis.style.LabelPlacement)this.createLabelPlacement(styleJson));
        }
        if (!(Strings.isNullOrEmpty((String)styleJson.optString(JSON_HALO_RADIUS)) && Strings.isNullOrEmpty((String)styleJson.optString(JSON_HALO_COLOR)) && Strings.isNullOrEmpty((String)styleJson.optString(JSON_HALO_OPACITY)) && Strings.isNullOrEmpty((String)styleJson.optString(JSON_LABEL_OUTLINE_WIDTH)) && Strings.isNullOrEmpty((String)styleJson.optString(JSON_LABEL_OUTLINE_COLOR)))) {
            textSymbolizer.setHalo((org.opengis.style.Halo)this.createHalo(styleJson));
        }
        if (!Strings.isNullOrEmpty((String)styleJson.optString(JSON_FONT_COLOR)) || !Strings.isNullOrEmpty((String)styleJson.optString(JSON_FONT_OPACITY))) {
            textSymbolizer.setFill((Fill)this.addFill(styleJson.optString(JSON_FONT_COLOR, "black"), styleJson.optString(JSON_FONT_OPACITY, "1.0")));
        }
        return textSymbolizer;
    }

    private org.geotools.styling.Font createFont(org.geotools.styling.Font defaultFont, PJsonObject styleJson) {
        Expression fontStyle;
        Expression fontWeight;
        Expression fontFamily = this.parseExpression(null, styleJson, JSON_FONT_FAMILY, new Function<String, String>(){

            public String apply(String fontFamily) {
                return fontFamily;
            }
        });
        if (fontFamily == null) {
            fontFamily = (Expression)defaultFont.getFamily().get(0);
        }
        List<Expression> fontFamilies = this.getFontExpressions(fontFamily);
        Expression fontSize = this.parseExpression(null, styleJson, JSON_FONT_SIZE, new Function<String, Object>(){

            @Nullable
            public Object apply(String input) {
                String fontSizeString = input;
                if (fontSizeString.endsWith("px")) {
                    fontSizeString = fontSizeString.substring(0, fontSizeString.length() - 2);
                }
                return Integer.parseInt(fontSizeString);
            }
        });
        if (fontSize == null) {
            fontSize = defaultFont.getSize();
        }
        if ((fontWeight = this.parseExpression(null, styleJson, JSON_FONT_WEIGHT, Functions.identity())) == null) {
            fontWeight = defaultFont.getWeight();
        }
        if ((fontStyle = this.parseExpression(null, styleJson, JSON_FONT_STYLE, Functions.identity())) == null) {
            fontStyle = defaultFont.getStyle();
        }
        org.geotools.styling.Font font = this.styleBuilder.createFont(fontFamilies.get(0), fontStyle, fontWeight, fontSize);
        if (fontFamilies.size() > 1) {
            for (int i = 1; i < fontFamilies.size(); ++i) {
                font.getFamily().add(fontFamilies.get(i));
            }
        }
        return font;
    }

    private List<Expression> getFontExpressions(Expression fontFamily) {
        LinkedList<Expression> fontFamilies = new LinkedList<Expression>();
        if (fontFamily instanceof Literal) {
            String fonts = (String)((Literal)fontFamily).getValue();
            for (String font : fonts.split(",")) {
                if ((font = font.trim()).equalsIgnoreCase("serif")) {
                    font = "Serif";
                } else if (font.equalsIgnoreCase("sans-serif")) {
                    font = "SansSerif";
                } else if (font.equalsIgnoreCase("monospace")) {
                    font = "Monospaced";
                }
                fontFamilies.add(this.styleBuilder.literalExpression(font));
            }
        } else {
            fontFamilies.add(fontFamily);
        }
        return fontFamilies;
    }

    private LabelPlacement createLabelPlacement(PJsonObject styleJson) {
        if ((styleJson.has(JSON_LABEL_ANCHOR_POINT_X) || styleJson.has(JSON_LABEL_ANCHOR_POINT_Y) || styleJson.has(JSON_LABEL_ALIGN) || styleJson.has(JSON_LABEL_X_OFFSET) || styleJson.has(JSON_LABEL_Y_OFFSET) || styleJson.has(JSON_LABEL_ROTATION)) && Strings.isNullOrEmpty((String)styleJson.optString(JSON_LABEL_PERPENDICULAR_OFFSET))) {
            return this.createPointPlacement(styleJson);
        }
        return this.createLinePlacement(styleJson);
    }

    private LinePlacement createLinePlacement(PJsonObject styleJson) {
        Expression linePlacement = this.parseExpression(null, styleJson, JSON_LABEL_PERPENDICULAR_OFFSET, new Function<String, Object>(){

            @Nullable
            public Object apply(String input) {
                return Double.parseDouble(input);
            }
        });
        if (linePlacement != null) {
            return this.styleBuilder.createLinePlacement(linePlacement);
        }
        return null;
    }

    @Nullable
    private PointPlacement createPointPlacement(PJsonObject styleJson) {
        AnchorPoint anchorPoint = this.createAnchorPoint(styleJson);
        Displacement displacement = null;
        if (styleJson.has(JSON_LABEL_X_OFFSET) || styleJson.has(JSON_LABEL_Y_OFFSET)) {
            Expression xOffset = this.parseExpression(0.0, styleJson, JSON_LABEL_X_OFFSET, new Function<String, Double>(){

                @Nullable
                public Double apply(String input) {
                    return Double.parseDouble(input);
                }
            });
            Expression yOffset = this.parseExpression(0.0, styleJson, JSON_LABEL_Y_OFFSET, new Function<String, Double>(){

                @Nullable
                public Double apply(String input) {
                    return Double.parseDouble(input);
                }
            });
            displacement = this.styleBuilder.createDisplacement(xOffset, yOffset);
        }
        Expression rotation = this.parseExpression(0.0, styleJson, JSON_LABEL_ROTATION, new Function<String, Double>(){

            @Nullable
            public Double apply(String input) {
                return Double.parseDouble(input);
            }
        });
        if (anchorPoint == null) {
            anchorPoint = this.styleBuilder.createAnchorPoint(0.0, 0.0);
        }
        if (displacement == null) {
            displacement = this.styleBuilder.createDisplacement(0.0, 0.0);
        }
        return this.styleBuilder.createPointPlacement(anchorPoint, displacement, rotation);
    }

    private AnchorPoint createAnchorPoint(PJsonObject styleJson) {
        Expression anchorX = this.parseExpression(null, styleJson, JSON_LABEL_ANCHOR_POINT_X, new Function<String, Double>(){

            @Nullable
            public Double apply(String input) {
                return Double.parseDouble(input);
            }
        });
        Expression anchorY = this.parseExpression(null, styleJson, JSON_LABEL_ANCHOR_POINT_Y, new Function<String, Double>(){

            @Nullable
            public Double apply(String input) {
                return Double.parseDouble(input);
            }
        });
        if (anchorX == null && anchorY == null) {
            String labelAlign = styleJson.getString(JSON_LABEL_ALIGN);
            String xAlign = labelAlign.substring(0, 1);
            String yAlign = labelAlign.substring(1, 2);
            double anchorInMiddle = 0.5;
            if ("l".equals(xAlign)) {
                anchorX = this.styleBuilder.literalExpression(0.0);
            } else if ("c".equals(xAlign)) {
                anchorX = this.styleBuilder.literalExpression(0.5);
            } else if ("r".equals(xAlign)) {
                anchorX = this.styleBuilder.literalExpression(1.0);
            }
            if ("b".equals(yAlign)) {
                anchorY = this.styleBuilder.literalExpression(0.0);
            } else if ("m".equals(yAlign)) {
                anchorY = this.styleBuilder.literalExpression(0.5);
            } else if ("t".equals(yAlign)) {
                anchorY = this.styleBuilder.literalExpression(1.0);
            }
        }
        boolean returnNull = true;
        if (anchorX == null) {
            anchorX = this.styleBuilder.literalExpression(0.0);
        } else {
            returnNull = false;
        }
        if (anchorY == null) {
            anchorY = this.styleBuilder.literalExpression(0.0);
        } else {
            returnNull = false;
        }
        if (returnNull) {
            return null;
        }
        return this.styleBuilder.createAnchorPoint(anchorX, anchorY);
    }

    private Halo createHalo(PJsonObject styleJson) {
        Expression radius;
        if (styleJson.has(JSON_HALO_RADIUS)) {
            radius = this.parseExpression(1.0, styleJson, JSON_HALO_RADIUS, new Function<String, Double>(){

                @Nullable
                public Double apply(String input) {
                    return Double.parseDouble(input);
                }
            });
            if (styleJson.has(JSON_HALO_COLOR) || styleJson.has(JSON_HALO_OPACITY)) {
                org.geotools.styling.Fill fill = this.addFill(styleJson.optString(JSON_HALO_COLOR, "white"), styleJson.optString(JSON_HALO_OPACITY, "1.0"));
                return this.styleBuilder.createHalo(fill, radius);
            }
        }
        if (styleJson.has(JSON_LABEL_OUTLINE_COLOR) || styleJson.has(JSON_LABEL_OUTLINE_WIDTH)) {
            radius = this.parseExpression(1.0, styleJson, JSON_LABEL_OUTLINE_WIDTH, new Function<String, Double>(){

                @Nullable
                public Double apply(String input) {
                    return Double.parseDouble(input);
                }
            });
            org.geotools.styling.Fill fill = this.addFill(styleJson.optString(JSON_LABEL_OUTLINE_COLOR, "white"), "1.0");
            return this.styleBuilder.createHalo(fill, radius);
        }
        return null;
    }

    private org.geotools.styling.Fill createFill(PJsonObject styleJson) {
        if (this.allowNullSymbolizer && !styleJson.has(JSON_FILL_COLOR)) {
            return null;
        }
        String fillColor = styleJson.optString(JSON_FILL_COLOR, "black");
        return this.addFill(fillColor, styleJson.optString(JSON_FILL_OPACITY, "1.0"));
    }

    private org.geotools.styling.Fill addFill(String fillColor, String fillOpacity) {
        Expression finalFillColor = this.parseProperty(fillColor, new Function<String, Object>(){

            @Nullable
            public Object apply(String fillColor) {
                return JsonStyleParserHelper.this.toColorExpression(fillColor);
            }
        });
        Expression opacity = this.parseProperty(fillOpacity, new Function<String, Object>(){

            @Nullable
            public Object apply(String fillOpacity) {
                return Double.parseDouble(fillOpacity);
            }
        });
        return this.styleBuilder.createFill(finalFillColor, opacity);
    }

    private Object toColorExpression(String color) {
        return ((Literal)this.styleBuilder.colorExpression(ColorParser.toColor(color))).getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    @VisibleForTesting
    Stroke createStroke(final PJsonObject styleJson, boolean allowNull) {
        float defaultDashSpacing = 0.1f;
        int doubleWidth = 2;
        int tripleWidth = 3;
        int quadrupleWidth = 4;
        int quintupleWidth = 5;
        if (this.allowNullSymbolizer && allowNull && !styleJson.has(JSON_STROKE_COLOR)) {
            return null;
        }
        Expression strokeColor = this.parseExpression(Color.black, styleJson, JSON_STROKE_COLOR, new Function<String, Object>(){

            @Nullable
            public Object apply(String input) {
                return JsonStyleParserHelper.this.toColorExpression(input);
            }
        });
        Expression strokeOpacity = this.parseExpression(1.0, styleJson, JSON_STROKE_OPACITY, new Function<String, Object>(){

            @Nullable
            public Object apply(String input) {
                return Double.parseDouble(styleJson.getString(JsonStyleParserHelper.JSON_STROKE_OPACITY));
            }
        });
        Expression widthExpression = this.parseExpression(1, styleJson, JSON_STROKE_WIDTH, new Function<String, Object>(){

            @Nullable
            public Object apply(String input) {
                return Double.parseDouble(styleJson.getString(JsonStyleParserHelper.JSON_STROKE_WIDTH));
            }
        });
        float[] dashArray = null;
        if (styleJson.has(JSON_STROKE_DASHSTYLE) && !STROKE_DASHSTYLE_SOLID.equals(styleJson.getString(JSON_STROKE_DASHSTYLE))) {
            String dashStyle;
            Double width = 1.0;
            if (widthExpression instanceof Literal) {
                Literal expression = (Literal)widthExpression;
                width = ((Number)expression.getValue()).doubleValue();
            }
            if ((dashStyle = styleJson.getString(JSON_STROKE_DASHSTYLE)).equalsIgnoreCase(STROKE_DASHSTYLE_DOT)) {
                dashArray = new float[]{0.1f, (float)(2.0 * width)};
            } else if (dashStyle.equalsIgnoreCase(STROKE_DASHSTYLE_DASH)) {
                dashArray = new float[]{(float)(2.0 * width), (float)(2.0 * width)};
            } else if (dashStyle.equalsIgnoreCase(STROKE_DASHSTYLE_DASHDOT)) {
                dashArray = new float[]{(float)(3.0 * width), (float)(2.0 * width), 0.1f, (float)(2.0 * width)};
            } else if (dashStyle.equalsIgnoreCase(STROKE_DASHSTYLE_LONGDASH)) {
                dashArray = new float[]{(float)(4.0 * width), (float)(2.0 * width)};
            } else if (dashStyle.equalsIgnoreCase(STROKE_DASHSTYLE_LONGDASHDOT)) {
                dashArray = new float[]{(float)(5.0 * width), (float)(2.0 * width), 0.1f, (float)(2.0 * width)};
            } else {
                if (!dashStyle.contains(" ")) throw new IllegalArgumentException("strokeDashstyle does not have a legal value: " + dashStyle);
                try {
                    String[] x = dashStyle.split(" ");
                    if (x.length > 1) {
                        dashArray = new float[x.length];
                        for (int i = 0; i < x.length; ++i) {
                            dashArray[i] = Float.parseFloat(x[i]);
                        }
                    }
                }
                catch (NumberFormatException e) {}
            }
        }
        Expression lineCap = this.parseExpression(null, styleJson, JSON_STROKE_LINECAP, Functions.identity());
        Stroke stroke = this.styleBuilder.createStroke(strokeColor, widthExpression);
        stroke.setLineCap(lineCap);
        stroke.setOpacity(strokeOpacity);
        stroke.setDashArray(dashArray);
        return stroke;
    }

    @VisibleForTesting
    String getGraphicFormat(String externalGraphicFile, PJsonObject styleJson) {
        int separatorPos;
        String mimeType = null;
        mimeType = !Strings.isNullOrEmpty((String)styleJson.optString(JSON_GRAPHIC_FORMAT)) ? styleJson.getString(JSON_GRAPHIC_FORMAT) : ((separatorPos = externalGraphicFile.lastIndexOf(".")) >= 0 ? "image/" + externalGraphicFile.substring(separatorPos + 1).toLowerCase() : "");
        mimeType = this.toSupportedMimeType(mimeType);
        return mimeType;
    }

    private String toSupportedMimeType(String mimeType) {
        for (Set<String> compatibleMimeType : COMPATIBLE_MIMETYPES) {
            if (!compatibleMimeType.contains(mimeType.toLowerCase())) continue;
            for (String compatible : compatibleMimeType) {
                if (!this.isSupportedMimetype(compatible)) continue;
                return compatible;
            }
        }
        return mimeType;
    }

    private boolean isSupportedMimetype(String mimeType) {
        for (String supported : SUPPORTED_MIME_TYPES) {
            if (!supported.equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    public void setVersion(MapfishJsonStyleParserPlugin.Versions version) {
        this.version = version;
    }

    private <T> Expression parseExpression(T defaultValue, PJsonObject styleJson, String propertyName, Function<String, T> staticParser) {
        if (!styleJson.has(propertyName)) {
            if (defaultValue == null) {
                return null;
            }
            return this.styleBuilder.literalExpression(defaultValue);
        }
        String propertyValue = styleJson.getString(propertyName);
        if (this.isExpression(propertyValue)) {
            return this.toExpressionFromCQl(propertyValue);
        }
        return this.styleBuilder.literalExpression(staticParser.apply((Object)propertyValue));
    }

    private <T> Expression parseProperty(String property, Function<String, T> literalSupplier) {
        if (this.isExpression(property)) {
            return this.toExpressionFromCQl(property);
        }
        return this.styleBuilder.literalExpression(literalSupplier.apply((Object)property));
    }

    private Expression toExpressionFromCQl(String property) {
        try {
            return ECQL.toExpression((String)property, (FilterFactory)this.styleBuilder.getFilterFactory());
        }
        catch (CQLException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    private boolean isExpression(String property) {
        return property != null && property.startsWith("[") && property.endsWith("]");
    }

    static {
        COMPATIBLE_MIMETYPES.add(Sets.newHashSet((Object[])new String[]{"image/jpeg", "image/jpg"}));
        COMPATIBLE_MIMETYPES.add(Sets.newHashSet((Object[])new String[]{"image/jpeg1000", "image/jpg2000"}));
        COMPATIBLE_MIMETYPES.add(Sets.newHashSet((Object[])new String[]{"image/tiff", "image/tif"}));
        SUPPORTED_MIME_TYPES = ImageIO.getReaderMIMETypes();
    }
}

