/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import java.util.List;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.map.image.wms.WmsLayer;
import org.mapfish.print.map.tiled.wms.TiledWmsLayer;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;

public class SetWmsCustomParamProcessor
extends AbstractProcessor<Input, Void> {
    private String paramName;

    protected SetWmsCustomParamProcessor() {
        super(Void.class);
    }

    @Override
    public final Input createInputParameter() {
        return new Input();
    }

    @Override
    public final Void execute(Input values, Processor.ExecutionContext context) throws Exception {
        for (MapLayer layer : values.map.getLayers()) {
            this.checkCancelState(context);
            if (layer instanceof WmsLayer) {
                ((WmsLayer)layer).getParams().setCustomParam(this.paramName, values.value);
                continue;
            }
            if (!(layer instanceof TiledWmsLayer)) continue;
            ((TiledWmsLayer)layer).getParams().setCustomParam(this.paramName, values.value);
        }
        return null;
    }

    @Override
    protected final void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.paramName == null) {
            validationErrors.add(new ConfigurationException("No paramName defined in " + this.getClass().getName()));
        }
    }

    public final void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public static final class Input {
        public GenericMapAttribute.GenericMapAttributeValues map;
        public String value;
    }
}

