/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.servlet.job.PrintJobStatus;

public final class SuccessfulPrintJob
extends PrintJobStatus {
    private static final String JSON_REPORT_URI = "reportURI";
    private static final String JSON_MIME_TYPE = "mimeType";
    private static final String JSON_FILE_EXT = "fileExtension";
    private final URI reportURI;
    private final String mimeType;
    private final String fileExtension;

    public SuccessfulPrintJob(String referenceId, URI reportURI, String appId, Date startDate, Date completionDate, long requestCount, String fileName, String mimeType, String fileExtension, AccessAssertion access) {
        super(referenceId, appId, startDate, completionDate, requestCount, fileName, access);
        this.reportURI = reportURI;
        this.mimeType = mimeType;
        this.fileExtension = fileExtension;
    }

    public URI getURI() {
        return this.reportURI;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public static SuccessfulPrintJob load(JSONObject metadata, String referenceId, String appId, Date startDate, Date completionDate, long requestCount, String fileName, AccessAssertion reportAccess) throws JSONException {
        try {
            URI reportURI = new URI(metadata.getString(JSON_REPORT_URI));
            String fileExt = metadata.getString(JSON_FILE_EXT);
            String mimeType = metadata.getString(JSON_MIME_TYPE);
            return new SuccessfulPrintJob(referenceId, reportURI, appId, startDate, completionDate, requestCount, fileName, mimeType, fileExt, reportAccess);
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    @Override
    protected void addExtraParameters(JSONObject metadata) throws JSONException {
        metadata.put(JSON_REPORT_URI, (Object)this.reportURI);
        metadata.put(JSON_FILE_EXT, (Object)this.fileExtension);
        metadata.put(JSON_MIME_TYPE, (Object)this.mimeType);
    }
}

