/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geotools.referencing.CRS;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.ReflectiveAttribute;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.Template;
import org.mapfish.print.map.MapLayerFactoryPlugin;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.MapfishParser;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class GenericMapAttribute<GenericMapAttributeValues>
extends ReflectiveAttribute<GenericMapAttributeValues> {
    private static final double[] DEFAULT_DPI_VALUES = new double[]{72.0, 120.0, 200.0, 254.0, 300.0, 600.0, 1200.0, 2400.0};
    public static final String JSON_DPI_SUGGESTIONS = "dpiSuggestions";
    public static final String JSON_MAX_DPI = "maxDPI";
    public static final String JSON_MAP_WIDTH = "width";
    public static final String JSON_MAP_HEIGHT = "height";
    static final String JSON_ZOOM_LEVEL_SUGGESTIONS = "scales";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MapfishParser mapfishJsonParser;
    private Double maxDpi = null;
    private double[] dpiSuggestions = null;
    private ZoomLevels zoomLevels = null;
    private Double zoomSnapTolerance = null;
    private ZoomLevelSnapStrategy zoomLevelSnapStrategy = null;
    private Boolean zoomSnapGeodetic = null;
    private Integer width = null;
    private Integer height = null;

    public final Double getMaxDpi() {
        return this.maxDpi;
    }

    public final void setMaxDpi(Double maxDpi) {
        this.maxDpi = maxDpi;
    }

    public final double[] getDpiSuggestions() {
        if (this.dpiSuggestions == null) {
            ArrayList list = Lists.newArrayList();
            for (double suggestion : DEFAULT_DPI_VALUES) {
                if (!(suggestion <= this.maxDpi)) continue;
                list.add(suggestion);
            }
            double[] suggestions = new double[list.size()];
            for (int i = 0; i < suggestions.length; ++i) {
                suggestions[i] = (Double)list.get(i);
            }
            return suggestions;
        }
        return this.dpiSuggestions;
    }

    public final void setDpiSuggestions(double[] dpiSuggestions) {
        this.dpiSuggestions = dpiSuggestions;
    }

    public final Integer getWidth() {
        return this.width;
    }

    public final void setWidth(Integer width) {
        this.width = width;
    }

    public final Integer getHeight() {
        return this.height;
    }

    public final void setHeight(Integer height) {
        this.height = height;
    }

    public final void setZoomLevels(ZoomLevels zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    public final void setZoomSnapTolerance(Double zoomSnapTolerance) {
        this.zoomSnapTolerance = zoomSnapTolerance;
    }

    public final void setZoomLevelSnapStrategy(ZoomLevelSnapStrategy zoomLevelSnapStrategy) {
        this.zoomLevelSnapStrategy = zoomLevelSnapStrategy;
    }

    public final void setZoomSnapGeodetic(Boolean zoomSnapGeodetic) {
        this.zoomSnapGeodetic = zoomSnapGeodetic;
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.width == null || this.width < 1) {
            validationErrors.add(new ConfigurationException("width field is not legal: " + this.width + " in " + this.getClass().getName()));
        }
        if (this.height == null || this.height < 1) {
            validationErrors.add(new ConfigurationException("height field is not legal: " + this.height + " in " + this.getClass().getName()));
        }
        if (this.getMaxDpi() == null || this.getMaxDpi() < 1.0) {
            validationErrors.add(new ConfigurationException("maxDpi field is not legal: " + this.getMaxDpi() + " in " + this.getClass().getName()));
        }
        if (this.getMaxDpi() != null && this.getDpiSuggestions() != null) {
            for (double dpi : this.getDpiSuggestions()) {
                if (!(dpi < 1.0) && !(dpi > this.getMaxDpi())) continue;
                validationErrors.add(new ConfigurationException("dpiSuggestions contains an invalid value: " + dpi + " in " + this.getClass().getName()));
            }
        }
    }

    @Override
    protected final Optional<JSONObject> getClientInfo() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_DPI_SUGGESTIONS, (Object)this.getDpiSuggestions());
        if (this.zoomLevels != null) {
            jsonObject.put(JSON_ZOOM_LEVEL_SUGGESTIONS, (Object)this.zoomLevels.getScales());
        }
        jsonObject.put(JSON_MAX_DPI, (Object)this.maxDpi);
        jsonObject.put(JSON_MAP_WIDTH, (Object)this.width);
        jsonObject.put(JSON_MAP_HEIGHT, (Object)this.height);
        return Optional.of((Object)jsonObject);
    }

    public static CoordinateReferenceSystem parseProjection(String projection, Boolean longitudeFirst) {
        String epsgCode = projection;
        if (epsgCode.equalsIgnoreCase("EPSG:900913")) {
            epsgCode = "EPSG:3857";
        }
        try {
            if (longitudeFirst == null) {
                return CRS.decode((String)epsgCode);
            }
            return CRS.decode((String)epsgCode, (boolean)longitudeFirst);
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new RuntimeException(epsgCode + " was not recognized as a crs code", e);
        }
        catch (FactoryException e) {
            throw new RuntimeException("Error occurred while parsing: " + epsgCode, e);
        }
    }

    public abstract class GenericMapAttributeValues {
        private static final String TYPE = "type";
        protected static final String DEFAULT_PROJECTION = "EPSG:3857";
        private final Dimension mapSize;
        private final Template template;
        private List<MapLayer> mapLayers;
        @HasDefaultValue
        public String projection = null;
        @HasDefaultValue
        public Double rotation = null;
        @HasDefaultValue
        public Boolean useNearestScale = null;
        @HasDefaultValue
        public Boolean useAdjustBounds = null;
        @HasDefaultValue
        public Boolean longitudeFirst = null;
        @HasDefaultValue
        public Boolean dpiSensitiveStyle = true;

        public GenericMapAttributeValues(Template template, Dimension mapSize) {
            this.template = template;
            this.mapSize = mapSize;
        }

        public void postConstruct() throws FactoryException {
            this.mapLayers = this.parseLayers();
        }

        private List<MapLayer> parseLayers() {
            ArrayList layerList = Lists.newArrayList();
            for (int i = 0; i < this.getRawLayers().size(); ++i) {
                try {
                    PObject layer = this.getRawLayers().getObject(i);
                    if (!(Math.abs(layer.optDouble("opacity", 1.0)) > 0.001)) continue;
                    this.parseSingleLayer(layerList, layer);
                    continue;
                }
                catch (Throwable throwable) {
                    throw ExceptionUtils.getRuntimeException(throwable);
                }
            }
            return layerList;
        }

        private void parseSingleLayer(List<MapLayer> layerList, PObject layer) throws Throwable {
            Map layerParsers = GenericMapAttribute.this.applicationContext.getBeansOfType(MapLayerFactoryPlugin.class);
            for (MapLayerFactoryPlugin layerParser : layerParsers.values()) {
                boolean layerApplies = layerParser.getTypeNames().contains(layer.getString(TYPE).toLowerCase());
                if (!layerApplies) continue;
                Object param = layerParser.createParameter();
                GenericMapAttribute.this.mapfishJsonParser.parse(this.template.getConfiguration().isThrowErrorOnExtraParameters(), layer, param, TYPE);
                MapLayer newLayer = layerParser.parse(this.template, param);
                if (layerList.isEmpty()) {
                    layerList.add(newLayer);
                } else {
                    int lastLayerIndex = layerList.size() - 1;
                    MapLayer lastLayer = layerList.get(lastLayerIndex);
                    Optional<MapLayer> combinedLayer = lastLayer.tryAddLayer(newLayer);
                    if (combinedLayer.isPresent()) {
                        layerList.remove(lastLayerIndex);
                        layerList.add(lastLayerIndex, (MapLayer)combinedLayer.get());
                    } else {
                        layerList.add(newLayer);
                    }
                }
                return;
            }
            StringBuilder message = new StringBuilder("\nLayer with type: '" + layer.getString(TYPE) + "' is not currently " + "supported.  Options include: ");
            for (MapLayerFactoryPlugin mapLayerFactoryPlugin : layerParsers.values()) {
                for (String name : mapLayerFactoryPlugin.getTypeNames()) {
                    message.append("\n");
                    message.append("\t* ").append((Object)name);
                }
            }
            throw new IllegalArgumentException(message.toString());
        }

        protected final CoordinateReferenceSystem parseProjection() {
            return GenericMapAttribute.parseProjection(this.getProjection(), this.longitudeFirst);
        }

        public abstract Double getDpi();

        protected abstract PArray getRawLayers();

        public List<MapLayer> getLayers() {
            return Lists.newArrayList(this.mapLayers);
        }

        public final Template getTemplate() {
            return this.template;
        }

        public final Dimension getMapSize() {
            return this.mapSize;
        }

        public Double getRotation() {
            return this.rotation;
        }

        public String getProjection() {
            return this.projection;
        }

        public Boolean isUseNearestScale() {
            return this.useNearestScale != false && GenericMapAttribute.this.zoomLevels != null;
        }

        public Boolean isUseAdjustBounds() {
            return this.useAdjustBounds;
        }

        public final Boolean isDpiSensitiveStyle() {
            return this.dpiSensitiveStyle;
        }

        public ZoomLevels getZoomLevels() {
            return GenericMapAttribute.this.zoomLevels;
        }

        public Double getZoomSnapTolerance() {
            return GenericMapAttribute.this.zoomSnapTolerance;
        }

        public ZoomLevelSnapStrategy getZoomLevelSnapStrategy() {
            return GenericMapAttribute.this.zoomLevelSnapStrategy;
        }

        public Boolean getZoomSnapGeodetic() {
            return GenericMapAttribute.this.zoomSnapGeodetic;
        }

        public double[] getDpiSuggestions() {
            return GenericMapAttribute.this.getDpiSuggestions();
        }

        public double getRequestorDPI() {
            return 72.0;
        }

        protected final <T> T getValueOr(T value, T defaultValue) {
            if (value != null) {
                return value;
            }
            return defaultValue;
        }
    }
}

