/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.util.Map;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.config.HasConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeId;

public final class MapfishPrintConstructor
extends Constructor {
    private static final String CONFIGURATION_TAG = "configuration";
    private static final ThreadLocal<Configuration> CONFIGURATION_UNDER_CONSTRUCTION = new InheritableThreadLocal<Configuration>();
    private static final Logger LOGGER = LoggerFactory.getLogger(MapfishPrintConstructor.class);

    public MapfishPrintConstructor(ConfigurableApplicationContext context) {
        super(new TypeDescription(Configuration.class, CONFIGURATION_TAG));
        Map yamlObjects = context.getBeansOfType(ConfigurationObject.class);
        for (Map.Entry entry : yamlObjects.entrySet()) {
            BeanDefinition beanDefinition = context.getBeanFactory().getBeanDefinition((String)entry.getKey());
            String message = "Error: Spring bean: " + (String)entry.getKey() + " is not defined as scope = prototype";
            if (!beanDefinition.isPrototype()) {
                LOGGER.error(message);
                throw new AssertionError((Object)message);
            }
            this.addTypeDescription(new TypeDescription(((ConfigurationObject)entry.getValue()).getClass(), "!" + (String)entry.getKey()));
        }
        MapfishPrintConstruct construct = new MapfishPrintConstruct((ApplicationContext)context);
        this.yamlClassConstructors.put(NodeId.mapping, construct);
    }

    static void setConfigurationUnderConstruction(Configuration config) {
        CONFIGURATION_UNDER_CONSTRUCTION.set(config);
    }

    private final class MapfishPrintConstruct
    extends Constructor.ConstructMapping {
        private final ApplicationContext applicationContext;

        private MapfishPrintConstruct(ApplicationContext context) {
            super((Constructor)MapfishPrintConstructor.this);
            this.applicationContext = context;
        }

        protected Object constructJavaBean2ndStep(MappingNode node, Object object) {
            return super.constructJavaBean2ndStep(node, object);
        }

        protected Object createEmptyJavaBean(MappingNode node) {
            Object bean;
            if (node.getType() == Configuration.class) {
                return this.getConfiguration();
            }
            try {
                bean = this.applicationContext.getBean(node.getTag().getValue().substring(1));
            }
            catch (NoSuchBeanDefinitionException e) {
                bean = this.applicationContext.getBean(node.getType());
            }
            if (bean instanceof HasConfiguration) {
                ((HasConfiguration)bean).setConfiguration(this.getConfiguration());
            }
            return bean;
        }

        private Configuration getConfiguration() {
            MapfishPrintConstruct mapfishPrintConstruct = this;
            return (Configuration)CONFIGURATION_UNDER_CONSTRUCTION.get();
        }
    }
}

