/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.annotation.Nonnull;
import javax.measure.unit.NonSI;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.lite.RendererUtilities;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.map.geotools.grid.GridLabel;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.LabelPositionCollector;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class GridUtils {
    private GridUtils() {
    }

    public static Polygon calculateBounds(MapfishMapContext context) {
        double rotation = context.getRootContext().getRotation();
        ReferencedEnvelope env = context.getRootContext().toReferencedEnvelope();
        Coordinate centre = env.centre();
        AffineTransform rotateInstance = AffineTransform.getRotateInstance(rotation, centre.x, centre.y);
        double[] dstPts = new double[8];
        double[] srcPts = new double[]{env.getMinX(), env.getMinY(), env.getMinX(), env.getMaxY(), env.getMaxX(), env.getMaxY(), env.getMaxX(), env.getMinY()};
        rotateInstance.transform(srcPts, 0, dstPts, 0, 4);
        return new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate(dstPts[0], dstPts[1]), new Coordinate(dstPts[2], dstPts[3]), new Coordinate(dstPts[4], dstPts[5]), new Coordinate(dstPts[6], dstPts[7]), new Coordinate(dstPts[0], dstPts[1])});
    }

    public static double calculateFirstLine(ReferencedEnvelope bounds, GridParam layerData, int ordinal) {
        double spaceFromOrigin = bounds.getMinimum(ordinal) - layerData.origin[ordinal];
        double linesBetweenOriginAndMap = Math.ceil(spaceFromOrigin / layerData.spacing[ordinal]);
        return linesBetweenOriginAndMap * layerData.spacing[ordinal] + layerData.origin[ordinal];
    }

    public static SimpleFeatureType createGridFeatureType(@Nonnull MapfishMapContext mapContext, @Nonnull Class<? extends Geometry> geomClass) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        CoordinateReferenceSystem projection = mapContext.getBounds().getProjection();
        typeBuilder.add("geom", geomClass, projection);
        typeBuilder.setName("grid");
        return typeBuilder.buildFeatureType();
    }

    public static String createLabel(double value, String unit, String format) {
        double zero = 1.0E-9;
        if (Math.abs(value - (double)Math.round(value)) < 1.0E-9) {
            return String.format("%d %s", Math.round(value), unit);
        }
        if (format != null) {
            return String.format(format, value, unit);
        }
        if ("m".equals(unit)) {
            return String.format("%1.0f %s", value, unit);
        }
        if (NonSI.DEGREE_ANGLE.toString().equals(unit)) {
            return String.format("%1.6f %s", value, unit);
        }
        return String.format("%f %s", value, unit);
    }

    public static AffineTransform getWorldToScreenTransform(MapfishMapContext mapContext) {
        return RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapContext.toReferencedEnvelope(), (Rectangle)mapContext.getPaintArea());
    }

    public static void topBorderLabel(LabelPositionCollector labels, GeometryFactory geometryFactory, Polygon rotatedBounds, String unit, double x, AffineTransform worldToScreenTransform, MathTransform toLabelProjection, String labelFormat) {
        Envelope envelopeInternal = rotatedBounds.getEnvelopeInternal();
        LineString lineString = geometryFactory.createLineString(new Coordinate[]{new Coordinate(x, envelopeInternal.centre().y), new Coordinate(x, envelopeInternal.getMaxY())});
        Geometry intersections = lineString.intersection((Geometry)rotatedBounds.getExteriorRing());
        if (intersections.getNumPoints() > 0) {
            Coordinate borderIntersection = intersections.getGeometryN(0).getCoordinates()[0];
            double[] screenPoints = new double[2];
            worldToScreenTransform.transform(new double[]{borderIntersection.x, borderIntersection.y}, 0, screenPoints, 0, 1);
            double[] labelProj = GridUtils.transformToLabelProjection(toLabelProjection, borderIntersection);
            labels.add(new GridLabel(GridUtils.createLabel(labelProj[0], unit, labelFormat), (int)screenPoints[0], (int)screenPoints[1], GridLabel.Side.TOP));
        }
    }

    public static void bottomBorderLabel(LabelPositionCollector labels, GeometryFactory geometryFactory, Polygon rotatedBounds, String unit, double x, AffineTransform worldToScreenTransform, MathTransform toLabelProjection, String labelFormat) {
        Envelope envelopeInternal = rotatedBounds.getEnvelopeInternal();
        LineString lineString = geometryFactory.createLineString(new Coordinate[]{new Coordinate(x, envelopeInternal.getMinY()), new Coordinate(x, envelopeInternal.centre().y)});
        Geometry intersections = lineString.intersection((Geometry)rotatedBounds.getExteriorRing());
        if (intersections.getNumPoints() > 0) {
            int idx = intersections instanceof LineString ? 1 : 0;
            Coordinate borderIntersection = intersections.getGeometryN(0).getCoordinates()[idx];
            double[] screenPoints = new double[2];
            worldToScreenTransform.transform(new double[]{borderIntersection.x, borderIntersection.y}, 0, screenPoints, 0, 1);
            double[] labelProj = GridUtils.transformToLabelProjection(toLabelProjection, borderIntersection);
            labels.add(new GridLabel(GridUtils.createLabel(labelProj[0], unit, labelFormat), (int)screenPoints[0], (int)screenPoints[1], GridLabel.Side.BOTTOM));
        }
    }

    public static void rightBorderLabel(LabelPositionCollector labels, GeometryFactory geometryFactory, Polygon rotatedBounds, String unit, double y, AffineTransform worldToScreenTransform, MathTransform toLabelProjection, String labelFormat) {
        Envelope envelopeInternal = rotatedBounds.getEnvelopeInternal();
        LineString lineString = geometryFactory.createLineString(new Coordinate[]{new Coordinate(envelopeInternal.centre().x, y), new Coordinate(envelopeInternal.getMaxX(), y)});
        Geometry intersections = lineString.intersection((Geometry)rotatedBounds.getExteriorRing());
        if (intersections.getNumPoints() > 0) {
            int idx = intersections instanceof LineString ? 1 : 0;
            Coordinate borderIntersection = intersections.getGeometryN(0).getCoordinates()[idx];
            double[] screenPoints = new double[2];
            worldToScreenTransform.transform(new double[]{borderIntersection.x, borderIntersection.y}, 0, screenPoints, 0, 1);
            double[] labelProj = GridUtils.transformToLabelProjection(toLabelProjection, borderIntersection);
            labels.add(new GridLabel(GridUtils.createLabel(labelProj[1], unit, labelFormat), (int)screenPoints[0], (int)screenPoints[1], GridLabel.Side.RIGHT));
        }
    }

    static void leftBorderLabel(LabelPositionCollector labels, GeometryFactory geometryFactory, Polygon rotatedBounds, String unit, double y, AffineTransform worldToScreenTransform, MathTransform toLabelProjection, String labelFormat) {
        Envelope envelopeInternal = rotatedBounds.getEnvelopeInternal();
        LineString lineString = geometryFactory.createLineString(new Coordinate[]{new Coordinate(envelopeInternal.getMinX(), y), new Coordinate(envelopeInternal.centre().x, y)});
        Geometry intersections = lineString.intersection((Geometry)rotatedBounds.getExteriorRing());
        if (intersections.getNumPoints() > 0) {
            double[] screenPoints = new double[2];
            Coordinate borderIntersection = intersections.getGeometryN(0).getCoordinates()[0];
            worldToScreenTransform.transform(new double[]{borderIntersection.x, borderIntersection.y}, 0, screenPoints, 0, 1);
            double[] labelProj = GridUtils.transformToLabelProjection(toLabelProjection, borderIntersection);
            labels.add(new GridLabel(GridUtils.createLabel(labelProj[1], unit, labelFormat), (int)screenPoints[0], (int)screenPoints[1], GridLabel.Side.LEFT));
        }
    }

    private static double[] transformToLabelProjection(MathTransform toLabelProjection, Coordinate borderIntersection) {
        try {
            double[] labelProj = new double[2];
            toLabelProjection.transform(new double[]{borderIntersection.x, borderIntersection.y}, 0, labelProj, 0, 1);
            return labelProj;
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
    }
}

