/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.attribute.map.StaticLayersAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PJoinedArray;

public final class AddStaticLayersProcessor
extends AbstractProcessor<Input, Void> {
    private StaticLayerPosition position;

    protected AddStaticLayersProcessor() {
        super(Void.class);
    }

    public void setPosition(StaticLayerPosition position) {
        this.position = position;
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.position == null) {
            validationErrors.add(new ConfigurationException("The addPosition field needs to be set to one of the allowed options: " + Arrays.toString((Object[])StaticLayerPosition.values())));
        }
    }

    @Override
    @Nullable
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    @Nullable
    public Void execute(Input values, Processor.ExecutionContext context) throws Exception {
        switch (this.position) {
            case BOTTOM: {
                values.map.layers = new PJoinedArray(new PArray[]{values.map.layers, values.staticLayers.layers});
                break;
            }
            case TOP: {
                values.map.layers = new PJoinedArray(new PArray[]{values.staticLayers.layers, values.map.layers});
                break;
            }
            default: {
                throw new Error("An enumeration value was added that does not have an implementation.  A Programmer must add this implementation to " + this.getClass().getName());
            }
        }
        values.map.postConstruct();
        return null;
    }

    public static enum StaticLayerPosition {
        TOP,
        BOTTOM;

    }

    public static class Input {
        public MapAttribute.MapAttributeValues map;
        public StaticLayersAttribute.StaticLayersAttributeValue staticLayers;
    }
}

