/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import org.apache.batik.svggen.DefaultStyleHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.StyleHandler;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.RendererUtilities;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.AreaOfInterest;
import org.mapfish.print.attribute.map.BBoxMapBounds;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomToFeatures;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.Scale;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayer;
import org.mapfish.print.map.geotools.FeatureLayer;
import org.mapfish.print.map.geotools.grid.GridLayer;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.ImagesSubReport;
import org.mapfish.print.processor.map.ConstantClipGraphics2D;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CreateMapProcessor
extends AbstractProcessor<Input, Output> {
    @Autowired
    FeatureLayer.Plugin featureLayerPlugin;
    private BufferedImageType imageType = BufferedImageType.TYPE_4BYTE_ABGR;

    protected CreateMapProcessor() {
        super(Output.class);
    }

    @Override
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    public Output execute(Input param, Processor.ExecutionContext context) throws Exception {
        this.checkCancelState(context);
        MapAttribute.MapAttributeValues mapValues = param.map;
        if (mapValues.zoomToFeatures != null) {
            this.zoomToFeatures(param.tempTaskDirectory, param.clientHttpRequestFactory, mapValues, context);
        }
        MapfishMapContext mapContext = this.createMapContext(mapValues);
        List<URI> graphics = this.createLayerGraphics(param.tempTaskDirectory, param.clientHttpRequestFactory, mapValues, context, mapContext);
        this.checkCancelState(context);
        URI mapSubReport = this.createMapSubReport(param.tempTaskDirectory, mapValues.getMapSize(), graphics, mapValues.getDpi());
        return new Output(graphics, mapSubReport.toString(), mapContext);
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.imageType == null) {
            validationErrors.add(new ConfigurationException("No imageType defined in " + this.getClass().getName()));
        }
    }

    private URI createMapSubReport(File printDirectory, Dimension mapSize, List<URI> graphics, double dpi) throws IOException, JRException {
        ImagesSubReport subReport = new ImagesSubReport(graphics, mapSize, dpi);
        File compiledReport = File.createTempFile("map-", ".jasper", printDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URI> createLayerGraphics(File printDirectory, MfClientHttpRequestFactory clientHttpRequestFactory, MapAttribute.MapAttributeValues mapValues, Processor.ExecutionContext context, MapfishMapContext mapContext) throws Exception {
        List layers = Lists.reverse((List)Lists.newArrayList(mapValues.getLayers()));
        AreaOfInterest areaOfInterest = this.addAreaOfInterestLayer(mapValues, layers);
        String mapKey = UUID.randomUUID().toString();
        ArrayList<URI> graphics = new ArrayList<URI>(layers.size());
        int i = 0;
        for (MapLayer layer : layers) {
            this.checkCancelState(context);
            boolean isFirstLayer = i == 0;
            File path = null;
            if (this.renderAsSvg(layer)) {
                SVGGraphics2D graphics2D = CreateMapProcessor.getSvgGraphics(mapContext.getMapSize());
                try {
                    Graphics2D clippedGraphics2D = this.createClippedGraphics(mapContext, areaOfInterest, (Graphics2D)graphics2D);
                    layer.render(clippedGraphics2D, clientHttpRequestFactory, mapContext, isFirstLayer);
                    path = new File(printDirectory, mapKey + "_layer_" + i + ".svg");
                    CreateMapProcessor.saveSvgFile(graphics2D, path);
                }
                finally {
                    graphics2D.dispose();
                }
            }
            BufferedImage bufferedImage = new BufferedImage(mapContext.getMapSize().width, mapContext.getMapSize().height, this.imageType.value);
            Graphics2D graphics2D = this.createClippedGraphics(mapContext, areaOfInterest, bufferedImage.createGraphics());
            try {
                layer.render(graphics2D, clientHttpRequestFactory, mapContext, isFirstLayer);
                path = new File(printDirectory, mapKey + "_layer_" + i + ".png");
                ImageIO.write((RenderedImage)bufferedImage, "png", path);
            }
            finally {
                graphics2D.dispose();
            }
            graphics.add(path.toURI());
            ++i;
        }
        return graphics;
    }

    private MapfishMapContext createMapContext(MapAttribute.MapAttributeValues mapValues) {
        Dimension mapSize = mapValues.getMapSize();
        Rectangle paintArea = new Rectangle(mapSize);
        double dpi = mapValues.getDpi();
        double dpiOfRequestor = mapValues.getRequestorDPI();
        double dpiRatio = dpi / dpiOfRequestor;
        paintArea.setBounds(0, 0, (int)(mapSize.getWidth() * dpiRatio), (int)(mapSize.getHeight() * dpiRatio));
        MapBounds bounds = mapValues.getMapBounds();
        bounds = CreateMapProcessor.adjustBoundsToScaleAndMapSize(mapValues, dpi, paintArea, bounds);
        return new MapfishMapContext(bounds, paintArea.getSize(), mapValues.getRotation(), dpi, mapValues.getRequestorDPI(), mapValues.longitudeFirst, mapValues.isDpiSensitiveStyle());
    }

    private AreaOfInterest addAreaOfInterestLayer(@Nonnull MapAttribute.MapAttributeValues mapValues, @Nonnull List<MapLayer> layers) throws IOException {
        AreaOfInterest areaOfInterest = mapValues.areaOfInterest;
        if (areaOfInterest != null && areaOfInterest.display == AreaOfInterest.AoiDisplay.RENDER) {
            FeatureLayer.FeatureLayerParam param = new FeatureLayer.FeatureLayerParam();
            param.defaultStyle = "overview-map:" + areaOfInterest.getArea().getClass().getSimpleName();
            param.style = areaOfInterest.style;
            param.renderAsSvg = areaOfInterest.renderAsSvg;
            param.features = areaOfInterest.areaToFeatureCollection(mapValues);
            FeatureLayer featureLayer = this.featureLayerPlugin.parse(mapValues.getTemplate(), param);
            layers.add(featureLayer);
        }
        return areaOfInterest;
    }

    private Graphics2D createClippedGraphics(@Nonnull MapfishMapContext transformer, @Nullable AreaOfInterest areaOfInterest, @Nonnull Graphics2D graphics2D) {
        if (areaOfInterest != null && areaOfInterest.display == AreaOfInterest.AoiDisplay.CLIP) {
            Polygon screenGeometry = this.areaOfInterestInScreenCRS(transformer, areaOfInterest);
            ShapeWriter shapeWriter = new ShapeWriter();
            Shape clipShape = shapeWriter.toShape((Geometry)screenGeometry);
            return new ConstantClipGraphics2D(graphics2D, clipShape);
        }
        return graphics2D;
    }

    private Polygon areaOfInterestInScreenCRS(@Nonnull MapfishMapContext transformer, @Nullable AreaOfInterest areaOfInterest) {
        if (areaOfInterest != null) {
            Polygon screenGeometry;
            AffineTransform worldToScreenTransform = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)transformer.toReferencedEnvelope(), (Rectangle)transformer.getPaintArea());
            AffineTransform2D mathTransform = new AffineTransform2D(worldToScreenTransform);
            try {
                screenGeometry = (Polygon)JTS.transform((Geometry)areaOfInterest.getArea(), (MathTransform)mathTransform);
            }
            catch (TransformException e) {
                throw new RuntimeException(e);
            }
            return screenGeometry;
        }
        return null;
    }

    public static MapBounds adjustBoundsToScaleAndMapSize(MapAttribute.MapAttributeValues mapValues, double dpiOfRequestor, Rectangle paintArea, MapBounds bounds) {
        MapBounds newBounds = bounds;
        if (mapValues.isUseNearestScale().booleanValue()) {
            newBounds = newBounds.adjustBoundsToNearestScale(mapValues.getZoomLevels(), mapValues.getZoomSnapTolerance(), mapValues.getZoomLevelSnapStrategy(), mapValues.getZoomSnapGeodetic(), paintArea, dpiOfRequestor);
        }
        newBounds = new BBoxMapBounds(newBounds.toReferencedEnvelope(paintArea, dpiOfRequestor));
        if (mapValues.isUseAdjustBounds().booleanValue()) {
            newBounds = newBounds.adjustedEnvelope(paintArea);
        }
        return newBounds;
    }

    private boolean renderAsSvg(MapLayer layer) {
        if (layer instanceof AbstractFeatureSourceLayer) {
            AbstractFeatureSourceLayer featureLayer = (AbstractFeatureSourceLayer)layer;
            return featureLayer.shouldRenderAsSvg();
        }
        return false;
    }

    public static SVGGraphics2D getSvgGraphics(Dimension size) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.getDOMImplementation().createDocument(null, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setStyleHandler((StyleHandler)new OpacityAdjustingStyleHandler());
        ctx.setComment("Generated by GeoTools2 with Batik SVG Generator");
        SVGGraphics2D g2d = new SVGGraphics2D(ctx, true);
        g2d.setSVGCanvasSize(size);
        return g2d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSvgFile(SVGGraphics2D graphics2d, File path) throws IOException {
        Closer closer = Closer.create();
        try {
            FileOutputStream fs = (FileOutputStream)closer.register((Closeable)new FileOutputStream(path));
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)closer.register((Closeable)new OutputStreamWriter((OutputStream)fs, "UTF-8"));
            Writer osw = (Writer)closer.register((Closeable)new BufferedWriter(outputStreamWriter));
            graphics2d.stream(osw, true);
        }
        finally {
            closer.close();
        }
    }

    private void zoomToFeatures(File tempTaskDirectory, MfClientHttpRequestFactory clientHttpRequestFactory, MapAttribute.MapAttributeValues mapValues, Processor.ExecutionContext context) {
        ReferencedEnvelope bounds = this.getFeatureBounds(clientHttpRequestFactory, mapValues, context);
        if (bounds != null) {
            if (mapValues.zoomToFeatures.zoomType == ZoomToFeatures.ZoomType.CENTER) {
                Coordinate center = bounds.centre();
                mapValues.center = new double[]{center.x, center.y};
                if (mapValues.zoomToFeatures.minScale != null) {
                    mapValues.scale = mapValues.zoomToFeatures.minScale;
                }
                mapValues.bbox = null;
                mapValues.recalculateBounds();
            } else if (mapValues.zoomToFeatures.zoomType == ZoomToFeatures.ZoomType.EXTENT) {
                if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                    Coordinate center = bounds.centre();
                    mapValues.center = new double[]{center.x, center.y};
                    mapValues.bbox = null;
                    mapValues.scale = mapValues.zoomToFeatures.minScale;
                    mapValues.recalculateBounds();
                } else {
                    Scale scale;
                    mapValues.bbox = new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()};
                    mapValues.center = null;
                    mapValues.recalculateBounds();
                    MapBounds mapBounds = mapValues.getMapBounds();
                    Rectangle paintArea = new Rectangle(mapValues.getMapSize());
                    mapBounds = mapBounds.adjustedEnvelope(paintArea);
                    if (mapValues.zoomToFeatures.minMargin != null) {
                        mapBounds = ((BBoxMapBounds)mapBounds).expand(mapValues.zoomToFeatures.minMargin, paintArea);
                    }
                    if ((scale = mapBounds.getScaleDenominator(paintArea, mapValues.getDpi())).getDenominator() < mapValues.zoomToFeatures.minScale) {
                        mapBounds = mapBounds.zoomToScale(mapValues.zoomToFeatures.minScale);
                    }
                    if (mapValues.isUseNearestScale().booleanValue()) {
                        mapBounds = mapBounds.adjustBoundsToNearestScale(mapValues.getZoomLevels(), 0.0, ZoomLevelSnapStrategy.HIGHER_SCALE, mapValues.getZoomSnapGeodetic(), paintArea, mapValues.getRequestorDPI());
                    }
                    mapValues.setMapBounds(mapBounds);
                }
            }
        }
    }

    private ReferencedEnvelope getFeatureBounds(MfClientHttpRequestFactory clientHttpRequestFactory, MapAttribute.MapAttributeValues mapValues, Processor.ExecutionContext context) {
        MapfishMapContext mapContext = this.createMapContext(mapValues);
        String layerName = mapValues.zoomToFeatures.layer;
        ReferencedEnvelope bounds = null;
        for (MapLayer layer : mapValues.getLayers()) {
            FeatureCollection features;
            this.checkCancelState(context);
            if ((Strings.isNullOrEmpty((String)layerName) || !layerName.equals(layer.getName())) && (!Strings.isNullOrEmpty((String)layerName) || !(layer instanceof AbstractFeatureSourceLayer) || layer instanceof GridLayer)) continue;
            AbstractFeatureSourceLayer featureLayer = (AbstractFeatureSourceLayer)layer;
            FeatureSource<?, ?> featureSource = featureLayer.getFeatureSource(clientHttpRequestFactory, mapContext);
            try {
                features = featureSource.getFeatures();
            }
            catch (IOException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
            if (features.isEmpty()) continue;
            if (bounds == null) {
                bounds = features.getBounds();
                continue;
            }
            bounds.expandToInclude((Envelope)features.getBounds());
        }
        return bounds;
    }

    public void setImageType(String imageType) {
        this.imageType = BufferedImageType.lookupValue(imageType);
    }

    private static final class OpacityAdjustingStyleHandler
    extends DefaultStyleHandler {
        private OpacityAdjustingStyleHandler() {
        }

        public void setStyle(Element element, Map styleMap, SVGGeneratorContext generatorContext) {
            String tagName = element.getTagName();
            for (String styleName : styleMap.keySet()) {
                if (element.getAttributeNS(null, styleName).length() != 0) continue;
                if (styleName.equals("opacity")) {
                    if (!this.appliesTo(styleName, tagName)) continue;
                    element.setAttributeNS(null, "fill-opacity", (String)styleMap.get(styleName));
                    element.setAttributeNS(null, "stroke-opacity", (String)styleMap.get(styleName));
                    continue;
                }
                if (!this.appliesTo(styleName, tagName)) continue;
                element.setAttributeNS(null, styleName, (String)styleMap.get(styleName));
            }
        }
    }

    public static final class Output {
        @InternalValue
        public final List<URI> layerGraphics;
        public final String mapSubReport;
        public final MapfishMapContext mapContext;

        private Output(List<URI> layerGraphics, String mapSubReport, MapfishMapContext mapContext) {
            this.layerGraphics = layerGraphics;
            this.mapSubReport = mapSubReport;
            this.mapContext = mapContext;
        }
    }

    public static class Input {
        public MfClientHttpRequestFactory clientHttpRequestFactory;
        public MapAttribute.MapAttributeValues map;
        public File tempTaskDirectory;
    }

    static enum BufferedImageType {
        TYPE_4BYTE_ABGR(6),
        TYPE_4BYTE_ABGR_PRE(7),
        TYPE_3BYTE_BGR(5),
        TYPE_BYTE_BINARY(12),
        TYPE_BYTE_GRAY(10),
        TYPE_BYTE_INDEXED(13),
        TYPE_INT_BGR(4),
        TYPE_INT_RGB(1),
        TYPE_INT_ARGB(2),
        TYPE_INT_ARGB_PRE(3),
        TYPE_USHORT_555_RGB(9),
        TYPE_USHORT_565_RGB(8),
        TYPE_USHORT_GRAY(11);

        private final int value;

        private BufferedImageType(int value) {
            this.value = value;
        }

        static BufferedImageType lookupValue(String name) {
            for (BufferedImageType bufferedImageType : BufferedImageType.values()) {
                if (!bufferedImageType.name().equalsIgnoreCase(name)) continue;
                return bufferedImageType;
            }
            throw new IllegalArgumentException("'" + name + "is not a recognized " + BufferedImageType.class.getName() + " enum value");
        }
    }
}

