/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.test.util;

import com.google.common.collect.FluentIterable;
import com.google.common.io.Files;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;

public final class ImageSimilarity {
    static final int DEFAULT_SAMPLESIZE = 15;
    private final Color[][] signature;
    private int sampleSize = 15;
    private final float[] prop = new float[]{0.1f, 0.3f, 0.5f, 0.7f, 0.9f};

    public ImageSimilarity(File referenceImage, int sampleSize) throws IOException {
        this(ImageIO.read(referenceImage), sampleSize);
    }

    public ImageSimilarity(BufferedImage referenceImage, int sampleSize) throws IOException {
        if ((float)referenceImage.getWidth() * this.prop[0] - (float)sampleSize < 0.0f || (float)referenceImage.getWidth() * this.prop[4] + (float)sampleSize > (float)referenceImage.getWidth()) {
            throw new IllegalArgumentException("sample size is too big for the image.");
        }
        if ((float)referenceImage.getHeight() * this.prop[0] - (float)sampleSize < 0.0f || (float)referenceImage.getHeight() * this.prop[4] + (float)sampleSize > (float)referenceImage.getHeight()) {
            throw new IllegalArgumentException("sample size is too big for the image.");
        }
        this.sampleSize = sampleSize;
        this.signature = this.calcSignature(referenceImage);
    }

    private Color[][] calcSignature(BufferedImage i) {
        Color[][] sig = new Color[5][5];
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                sig[x][y] = this.averageAround(i, this.prop[x], this.prop[y]);
            }
        }
        return sig;
    }

    private Color averageAround(BufferedImage i, double px, double py) {
        RandomIter iterator = RandomIterFactory.create((RenderedImage)i, null);
        double[] pixel = new double[i.getSampleModel().getNumBands()];
        double[] accum = new double[3];
        int numPixels = 0;
        for (double x = px * (double)i.getWidth() - (double)this.sampleSize; x < px * (double)i.getWidth() + (double)this.sampleSize; x += 1.0) {
            for (double y = py * (double)i.getHeight() - (double)this.sampleSize; y < py * (double)i.getHeight() + (double)this.sampleSize; y += 1.0) {
                iterator.getPixel((int)x, (int)y, pixel);
                accum[0] = accum[0] + pixel[0];
                accum[1] = accum[1] + pixel[1];
                accum[2] = accum[2] + pixel[2];
                ++numPixels;
            }
        }
        accum[0] = accum[0] / (double)numPixels;
        accum[1] = accum[1] / (double)numPixels;
        accum[2] = accum[2] / (double)numPixels;
        return new Color((int)accum[0], (int)accum[1], (int)accum[2]);
    }

    private double calcDistance(BufferedImage other) {
        Color[][] sigOther = this.calcSignature(other);
        double dist = 0.0;
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                int r1 = this.signature[x][y].getRed();
                int g1 = this.signature[x][y].getGreen();
                int b1 = this.signature[x][y].getBlue();
                int r2 = sigOther[x][y].getRed();
                int g2 = sigOther[x][y].getGreen();
                int b2 = sigOther[x][y].getBlue();
                double tempDist = Math.sqrt((r1 - r2) * (r1 - r2) + (g1 - g2) * (g1 - g2) + (b1 - b2) * (b1 - b2));
                dist += tempDist;
            }
        }
        return dist;
    }

    public void assertSimilarity(File other, double maxDistance) throws IOException {
        double distance = this.calcDistance(ImageIO.read(other));
        if (distance > maxDistance) {
            throw new AssertionError((Object)("similarity difference between images is: " + distance + " which is greater than the max distance of " + maxDistance));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeUncompressedImage(BufferedImage image, String file) throws IOException {
        FileImageOutputStream out = null;
        try {
            File parentFile = new File(file).getParentFile();
            Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("tiff");
            ImageWriter next = writers.next();
            ImageWriteParam param = next.getDefaultWriteParam();
            param.setCompressionMode(0);
            File outputFile = new File(parentFile, Files.getNameWithoutExtension((String)file) + ".tiff");
            out = new FileImageOutputStream(outputFile);
            next.setOutput(out);
            next.write(image);
        }
        catch (Throwable e) {
            System.err.println("Error writing the image generated by the test:" + file + "\n\t");
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static BufferedImage mergeImages(List<URI> graphicFiles, int width, int height) throws IOException, TranscoderException {
        if (graphicFiles.isEmpty()) {
            throw new IllegalArgumentException("no graphics given");
        }
        BufferedImage mergedImage = ImageSimilarity.loadGraphic(graphicFiles.get(0), width, height);
        Graphics g = mergedImage.getGraphics();
        for (int i = 1; i < graphicFiles.size(); ++i) {
            BufferedImage image = ImageSimilarity.loadGraphic(graphicFiles.get(i), width, height);
            g.drawImage(image, 0, 0, null);
        }
        g.dispose();
        return mergedImage;
    }

    private static BufferedImage loadGraphic(URI path, int width, int height) throws IOException, TranscoderException {
        File file = new File(path);
        if (file.getName().endsWith(".svg")) {
            return ImageSimilarity.convertFromSvg(path, width, height);
        }
        return ImageIO.read(file);
    }

    public static BufferedImage convertFromSvg(URI svgFile, int width, int height) throws TranscoderException {
        BufferedImageTranscoder imageTranscoder = new BufferedImageTranscoder();
        imageTranscoder.addTranscodingHint(TIFFTranscoder.KEY_WIDTH, Float.valueOf(width));
        imageTranscoder.addTranscodingHint(TIFFTranscoder.KEY_HEIGHT, Float.valueOf(height));
        TranscoderInput input = new TranscoderInput(svgFile.toString());
        imageTranscoder.transcode(input, null);
        return imageTranscoder.getBufferedImage();
    }

    public static BufferedImage exportReportToImage(JasperPrint jasperPrint, Integer page) throws Exception {
        BufferedImage pageImage = new BufferedImage(jasperPrint.getPageWidth(), jasperPrint.getPageHeight(), 1);
        JRGraphics2DExporter exporter = new JRGraphics2DExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
        output.setGraphics2D((Graphics2D)pageImage.getGraphics());
        exporter.setExporterOutput((ExporterOutput)output);
        SimpleGraphics2DReportConfiguration configuration = new SimpleGraphics2DReportConfiguration();
        configuration.setPageIndex(page);
        exporter.setConfiguration((ReportExportConfiguration)configuration);
        exporter.exportReport();
        return pageImage;
    }

    public static void exportReportToFile(JasperPrint jasperPrint, String fileName, Integer page) throws Exception {
        BufferedImage pageImage = ImageSimilarity.exportReportToImage(jasperPrint, page);
        ImageIO.write((RenderedImage)pageImage, Files.getFileExtension((String)fileName), new File(fileName));
    }

    public static void main(String[] args) throws IOException {
        String path = "C:\\GitHub\\mapfish-printV3\\core\\src\\test\\resources\\map-data";
        File root = new File("C:\\GitHub\\mapfish-printV3\\core\\src\\test\\resources\\map-data");
        FluentIterable files = Files.fileTreeTraverser().postOrderTraversal((Object)root);
        for (File file : files) {
            if (!Files.getFileExtension((String)file.getName()).equals("png")) continue;
            BufferedImage img = ImageIO.read(file);
            ImageSimilarity.writeUncompressedImage(img, file.getAbsolutePath());
        }
    }

    private static class BufferedImageTranscoder
    extends ImageTranscoder {
        private BufferedImage img = null;

        private BufferedImageTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            BufferedImage bi = new BufferedImage(w, h, 2);
            return bi;
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) {
            this.img = img;
        }

        public BufferedImage getBufferedImage() {
            return this.img;
        }
    }
}

