/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.GeodeticCalculator;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.attribute.map.CenterScaleMapBounds;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class BBoxMapBounds
extends MapBounds {
    private final Envelope bbox;

    public BBoxMapBounds(CoordinateReferenceSystem projection, Envelope envelope) {
        super(projection);
        this.bbox = envelope;
    }

    public BBoxMapBounds(CoordinateReferenceSystem projection, double minX, double minY, double maxX, double maxY) {
        this(projection, new Envelope(minX, maxX, minY, maxY));
    }

    public BBoxMapBounds(ReferencedEnvelope bbox) {
        this(bbox.getCoordinateReferenceSystem(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
    }

    @Override
    public ReferencedEnvelope toReferencedEnvelope(Rectangle paintArea, double dpi) {
        return new ReferencedEnvelope(this.bbox, this.getProjection());
    }

    @Override
    public MapBounds adjustedEnvelope(Rectangle paintArea) {
        double bboxAspectRatio;
        double paintAreaAspectRatio = paintArea.getWidth() / paintArea.getHeight();
        if (paintAreaAspectRatio > (bboxAspectRatio = this.bbox.getWidth() / this.bbox.getHeight())) {
            double centerX = (this.bbox.getMinX() + this.bbox.getMaxX()) / 2.0;
            double factor = paintAreaAspectRatio / bboxAspectRatio;
            double finalDiff = (this.bbox.getMaxX() - centerX) * factor;
            return new BBoxMapBounds(this.getProjection(), centerX - finalDiff, this.bbox.getMinY(), centerX + finalDiff, this.bbox.getMaxY());
        }
        double centerY = (this.bbox.getMinY() + this.bbox.getMaxY()) / 2.0;
        double factor = bboxAspectRatio / paintAreaAspectRatio;
        double finalDiff = (this.bbox.getMaxY() - centerY) * factor;
        return new BBoxMapBounds(this.getProjection(), this.bbox.getMinX(), centerY - finalDiff, this.bbox.getMaxX(), centerY + finalDiff);
    }

    @Override
    public MapBounds adjustBoundsToNearestScale(ZoomLevels zoomLevels, double tolerance, ZoomLevelSnapStrategy zoomLevelSnapStrategy, boolean geodetic, Rectangle paintArea, double dpi) {
        double initialScaleDenominator = this.getScaleDenominator(paintArea, dpi);
        double currentScaleDenominator = Scale.getDenominator(geodetic, initialScaleDenominator, this.getProjection(), dpi, this.bbox.centre());
        double scaleRatio = initialScaleDenominator / currentScaleDenominator;
        ZoomLevelSnapStrategy.SearchResult result = zoomLevelSnapStrategy.search(currentScaleDenominator, tolerance, zoomLevels);
        double newScaleDenominator = result.getScaleDenominator() * scaleRatio;
        Coordinate center = this.bbox.centre();
        return new CenterScaleMapBounds(this.getProjection(), center.x, center.y, newScaleDenominator);
    }

    @Override
    public double getScaleDenominator(Rectangle paintArea, double dpi) {
        double geoWidthInInches;
        ReferencedEnvelope bboxAdjustedToScreen = this.toReferencedEnvelope(paintArea, dpi);
        DistanceUnit projUnit = DistanceUnit.fromProjection(this.getProjection());
        if (projUnit == DistanceUnit.DEGREES) {
            GeodeticCalculator calculator = new GeodeticCalculator(this.getProjection());
            double centerY = bboxAdjustedToScreen.centre().y;
            calculator.setStartingGeographicPoint(bboxAdjustedToScreen.getMinX(), centerY);
            calculator.setDestinationGeographicPoint(bboxAdjustedToScreen.getMaxX(), centerY);
            double geoWidthInEllipsoidUnits = calculator.getOrthodromicDistance();
            DistanceUnit ellipsoidUnit = DistanceUnit.fromString(calculator.getEllipsoid().getAxisUnit().toString());
            geoWidthInInches = ellipsoidUnit.convertTo(geoWidthInEllipsoidUnits, DistanceUnit.IN);
        } else {
            geoWidthInInches = projUnit.convertTo(bboxAdjustedToScreen.getWidth(), DistanceUnit.IN);
        }
        return geoWidthInInches * (dpi / paintArea.getWidth());
    }

    @Override
    public MapBounds adjustBoundsToRotation(double rotation) {
        if (FloatingPointUtil.equals(rotation, 0.0)) {
            return this;
        }
        double rotatedWidth = this.getRotatedWidth(rotation);
        double rotatedHeight = this.getRotatedHeight(rotation);
        double widthDifference = (rotatedWidth - this.bbox.getWidth()) / 2.0;
        double rotatedMinX = this.bbox.getMinX() - widthDifference;
        double rotatedMaxX = this.bbox.getMaxX() + widthDifference;
        double heightDifference = (rotatedHeight - this.bbox.getHeight()) / 2.0;
        double rotatedMinY = this.bbox.getMinY() - heightDifference;
        double rotatedMaxY = this.bbox.getMaxY() + heightDifference;
        return new BBoxMapBounds(this.getProjection(), rotatedMinX, rotatedMinY, rotatedMaxX, rotatedMaxY);
    }

    private double getRotatedWidth(double rotation) {
        double width = this.bbox.getWidth();
        if (!FloatingPointUtil.equals(rotation, 0.0)) {
            double height = this.bbox.getHeight();
            width = (float)(Math.abs(width * Math.cos(rotation)) + Math.abs(height * Math.sin(rotation)));
        }
        return width;
    }

    private double getRotatedHeight(double rotation) {
        double height = this.bbox.getHeight();
        if (!FloatingPointUtil.equals(rotation, 0.0)) {
            double width = this.bbox.getWidth();
            height = (float)(Math.abs(height * Math.cos(rotation)) + Math.abs(width * Math.sin(rotation)));
        }
        return height;
    }

    @Override
    public MapBounds zoomOut(double factor) {
        if (FloatingPointUtil.equals(factor, 1.0)) {
            return this;
        }
        double destWidth = this.bbox.getWidth() * factor;
        double destHeight = this.bbox.getHeight() * factor;
        double centerX = this.bbox.centre().x;
        double centerY = this.bbox.centre().y;
        double minGeoX = centerX - destWidth / 2.0;
        double maxGeoX = centerX + destWidth / 2.0;
        double minGeoY = centerY - destHeight / 2.0;
        double maxGeoY = centerY + destHeight / 2.0;
        return new BBoxMapBounds(this.getProjection(), minGeoX, minGeoY, maxGeoX, maxGeoY);
    }

    @Override
    public MapBounds zoomToScale(double scale) {
        Coordinate center = this.bbox.centre();
        return new CenterScaleMapBounds(this.getProjection(), center.x, center.y, scale);
    }

    @Override
    public Coordinate getCenter() {
        return this.bbox.centre();
    }

    public MapBounds expand(int margin, Rectangle paintArea) {
        double factorX = 1.0 + (double)(2 * margin) / paintArea.getWidth();
        double factorY = 1.0 + (double)(2 * margin) / paintArea.getHeight();
        double destWidth = this.bbox.getWidth() * factorX;
        double destHeight = this.bbox.getHeight() * factorY;
        double centerX = this.bbox.centre().x;
        double centerY = this.bbox.centre().y;
        double minGeoX = centerX - destWidth / 2.0;
        double maxGeoX = centerX + destWidth / 2.0;
        double minGeoY = centerY - destHeight / 2.0;
        double maxGeoY = centerY + destHeight / 2.0;
        return new BBoxMapBounds(this.getProjection(), minGeoX, minGeoY, maxGeoX, maxGeoY);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BBoxMapBounds that = (BBoxMapBounds)o;
        return this.bbox.equals((Object)that.bbox);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.bbox.hashCode();
        return result;
    }

    public String toString() {
        return "BBoxMapBounds{bbox=" + this.bbox + '}';
    }
}

