/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Rectangle;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.GeodeticCalculator;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public final class CenterScaleMapBounds
extends MapBounds {
    private final Coordinate center;
    private final double scaleDenominator;

    public CenterScaleMapBounds(CoordinateReferenceSystem projection, double centerX, double centerY, double scaleDenominator) {
        super(projection);
        this.center = new Coordinate(centerX, centerY);
        this.scaleDenominator = scaleDenominator;
    }

    @Override
    public ReferencedEnvelope toReferencedEnvelope(Rectangle paintArea, double dpi) {
        ReferencedEnvelope bbox;
        double geoWidthInches = this.scaleDenominator * (double)paintArea.width / dpi;
        double geoHeightInches = this.scaleDenominator * (double)paintArea.height / dpi;
        DistanceUnit projectionUnit = DistanceUnit.fromProjection(this.getProjection());
        if (projectionUnit == DistanceUnit.DEGREES) {
            bbox = this.computeGeodeticBBox(geoWidthInches, geoHeightInches);
        } else {
            double centerX = this.center.getOrdinate(0);
            double centerY = this.center.getOrdinate(1);
            double geoWidth = DistanceUnit.IN.convertTo(geoWidthInches, projectionUnit);
            double geoHeight = DistanceUnit.IN.convertTo(geoHeightInches, projectionUnit);
            double minGeoX = centerX - geoWidth / 2.0;
            double minGeoY = centerY - geoHeight / 2.0;
            double maxGeoX = minGeoX + geoWidth;
            double maxGeoY = minGeoY + geoHeight;
            bbox = new ReferencedEnvelope(minGeoX, maxGeoX, minGeoY, maxGeoY, this.getProjection());
        }
        return bbox;
    }

    @Override
    public MapBounds adjustedEnvelope(Rectangle paintArea) {
        return this;
    }

    @Override
    public MapBounds adjustBoundsToNearestScale(ZoomLevels zoomLevels, double tolerance, ZoomLevelSnapStrategy zoomLevelSnapStrategy, boolean geodetic, Rectangle paintArea, double dpi) {
        double currentScaleDenominator = this.getScaleDenominator(paintArea, dpi);
        double geodeticScaleDenominator = new Scale(currentScaleDenominator, this.getProjection(), dpi).getDenominator(geodetic, this.getProjection(), dpi, this.center);
        ZoomLevelSnapStrategy.SearchResult result = zoomLevelSnapStrategy.search(geodeticScaleDenominator, tolerance, zoomLevels);
        double resultScaleDenominator = result.getScaleDenominator();
        return new CenterScaleMapBounds(this.getProjection(), this.center.x, this.center.y, resultScaleDenominator);
    }

    @Override
    public double getScaleDenominator(Rectangle paintArea, double dpi) {
        return this.scaleDenominator;
    }

    @Override
    public MapBounds adjustBoundsToRotation(double rotation) {
        return this;
    }

    @Override
    public CenterScaleMapBounds zoomOut(double factor) {
        if (FloatingPointUtil.equals(factor, 1.0)) {
            return this;
        }
        double newDenominator = this.scaleDenominator * factor;
        return new CenterScaleMapBounds(this.getProjection(), this.center.x, this.center.y, newDenominator);
    }

    @Override
    public MapBounds zoomToScale(double newScaleDenominator) {
        return new CenterScaleMapBounds(this.getProjection(), this.center.x, this.center.y, newScaleDenominator);
    }

    @Override
    public Coordinate getCenter() {
        return this.center;
    }

    private ReferencedEnvelope computeGeodeticBBox(double geoWidthInInches, double geoHeightInInches) {
        try {
            CoordinateReferenceSystem crs = this.getProjection();
            GeodeticCalculator calc = new GeodeticCalculator(crs);
            DistanceUnit ellipsoidUnit = DistanceUnit.fromString(calc.getEllipsoid().getAxisUnit().toString());
            double geoWidth = DistanceUnit.IN.convertTo(geoWidthInInches, ellipsoidUnit);
            double geoHeight = DistanceUnit.IN.convertTo(geoHeightInInches, ellipsoidUnit);
            DirectPosition2D directPosition2D = new DirectPosition2D(this.center.x, this.center.y);
            directPosition2D.setCoordinateReferenceSystem(crs);
            calc.setStartingPosition((Position)directPosition2D);
            int west = -90;
            calc.setDirection(-90.0, geoWidth / 2.0);
            double minGeoX = calc.getDestinationPosition().getOrdinate(0);
            int east = 90;
            calc.setDirection(90.0, geoWidth / 2.0);
            double maxGeoX = calc.getDestinationPosition().getOrdinate(0);
            int south = 180;
            calc.setDirection(180.0, geoHeight / 2.0);
            double minGeoY = calc.getDestinationPosition().getOrdinate(1);
            boolean north = false;
            calc.setDirection(0.0, geoHeight / 2.0);
            double maxGeoY = calc.getDestinationPosition().getOrdinate(1);
            return new ReferencedEnvelope(this.rollLongitude(minGeoX), this.rollLongitude(maxGeoX), this.rollLatitude(minGeoY), this.rollLatitude(maxGeoY), crs);
        }
        catch (TransformException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    private double rollLongitude(double x) {
        return x - (double)((int)(x + Math.signum(x) * 180.0) / 360) * 360.0;
    }

    private double rollLatitude(double y) {
        return y - (double)((int)(y + Math.signum(y) * 90.0) / 180) * 180.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CenterScaleMapBounds that = (CenterScaleMapBounds)o;
        if (!this.center.equals((Object)that.center)) {
            return false;
        }
        return this.scaleDenominator == that.scaleDenominator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.center.hashCode();
        result = 31 * result + new Double(this.scaleDenominator).hashCode();
        return result;
    }

    public String toString() {
        return "CenterScaleMapBounds{center=" + this.center + ", scaleDenominator=" + this.scaleDenominator + '}';
    }
}

