/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.attribute.map.BBoxMapBounds;
import org.mapfish.print.attribute.map.CenterScaleMapBounds;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.map.Scale;

public final class MapfishMapContext {
    private final MapBounds bounds;
    private final Dimension mapSize;
    private final double rotation;
    private final double dpi;
    private final double requestorDpi;
    private final boolean forceLongitudeFirst;
    private final boolean dpiSensitiveStyle;
    private final MapfishMapContext parent;

    public MapfishMapContext(MapBounds bounds, Dimension mapSize, double rotationInDegree, double dpi, double requestorDpi, Boolean forceLongitudeFirst, boolean dpiSensitiveStyle) {
        this(null, bounds, mapSize, rotationInDegree, dpi, requestorDpi, forceLongitudeFirst, dpiSensitiveStyle);
    }

    public MapfishMapContext(MapfishMapContext parent, MapBounds bounds, Dimension mapSize, double rotationInDegree, double dpi, double requestorDpi, Boolean forceLongitudeFirst, boolean dpiSensitiveStyle) {
        this(parent, bounds, mapSize, rotationInDegree, true, dpi, requestorDpi, forceLongitudeFirst, dpiSensitiveStyle);
    }

    public MapfishMapContext(MapfishMapContext parent, MapBounds bounds, Dimension mapSize, double rotation, boolean rotationInDegree, double dpi, double requestorDpi, Boolean forceLongitudeFirst, boolean dpiSensitiveStyle) {
        this.parent = parent;
        this.bounds = bounds;
        this.mapSize = mapSize;
        this.rotation = rotationInDegree ? Math.toRadians(rotation) : rotation;
        this.dpi = dpi;
        this.requestorDpi = requestorDpi;
        this.forceLongitudeFirst = forceLongitudeFirst == null ? false : forceLongitudeFirst;
        this.dpiSensitiveStyle = dpiSensitiveStyle;
    }

    public double getRotation() {
        return this.rotation;
    }

    public MapBounds getBounds() {
        return this.bounds;
    }

    public MapBounds getRotatedBounds() {
        return this.bounds.adjustBoundsToRotation(this.rotation);
    }

    public MapBounds getRotatedBounds(Rectangle2D.Double paintAreaPrecise, Rectangle paintArea) {
        MapBounds rotatedBounds = this.getRotatedBounds();
        if (rotatedBounds instanceof CenterScaleMapBounds) {
            return rotatedBounds;
        }
        ReferencedEnvelope envelope = ((BBoxMapBounds)rotatedBounds).toReferencedEnvelope(null, -1.0);
        double widthRatio = paintArea.getWidth() / paintAreaPrecise.getWidth();
        double heightRatio = paintArea.getHeight() / paintAreaPrecise.getHeight();
        double adaptedWidth = envelope.getWidth() * widthRatio;
        double adaptedHeight = envelope.getHeight() * heightRatio;
        double widthDiff = adaptedWidth - envelope.getWidth();
        double heigthDiff = adaptedHeight - envelope.getHeight();
        envelope.expandBy(widthDiff / 2.0, heigthDiff / 2.0);
        return new BBoxMapBounds(envelope);
    }

    public MapBounds getRotatedBoundsAdjustedForPreciseRotatedMapSize() {
        Rectangle2D.Double paintAreaPrecise = this.getRotatedMapSizePrecise();
        Rectangle paintArea = new Rectangle(MapfishMapContext.rectangleDoubleToDimension(paintAreaPrecise));
        return this.getRotatedBounds(paintAreaPrecise, paintArea);
    }

    public Dimension getMapSize() {
        return this.mapSize;
    }

    public Scale getScale() {
        return new Scale(this.bounds.getScaleDenominator(this.getPaintArea(), this.dpi), this.getBounds().getProjection(), this.getRequestorDPI());
    }

    public double getGeodeticScaleDenominator() {
        return this.getScale().getGeodeticDenominator(this.bounds.getProjection(), this.dpi, this.getBounds().getCenter());
    }

    public double getRoundedScaleDenominator() {
        return this.getRoundedScaleDenominator(false);
    }

    public double getRoundedScaleDenominator(boolean geodetic) {
        double scaleDenominator = new Scale(this.bounds.getScaleDenominator(this.getPaintArea(), this.dpi), this.getBounds().getProjection(), this.dpi).getDenominator(geodetic, this.getBounds().getProjection(), this.dpi, this.getBounds().getCenter());
        int numChars = String.format("%d", Math.round(scaleDenominator)).length();
        if (numChars > 2) {
            double factor = Math.pow(10.0, numChars - 2);
            return (double)Math.round(scaleDenominator / factor) * factor;
        }
        if (scaleDenominator > 1.0) {
            return Math.round(scaleDenominator);
        }
        return scaleDenominator;
    }

    public double getCenterX() {
        return this.getCenter(0);
    }

    public double getCenterY() {
        return this.getCenter(1);
    }

    private double getCenter(int dimension) {
        return this.getBounds().toReferencedEnvelope(new Rectangle(this.getMapSize()), this.getDPI()).getMedian(dimension);
    }

    public Dimension getRotatedMapSize() {
        return MapfishMapContext.rectangleDoubleToDimension(this.getRotatedMapSizePrecise());
    }

    public Rectangle2D.Double getRotatedMapSizePrecise() {
        if (FloatingPointUtil.equals(this.rotation, 0.0)) {
            return new Rectangle2D.Double(0.0, 0.0, this.mapSize.getWidth(), this.mapSize.getHeight());
        }
        double rotatedWidth = this.getRotatedMapWidth();
        double rotatedHeight = this.getRotatedMapHeight();
        return new Rectangle2D.Double(0.0, 0.0, rotatedWidth, rotatedHeight);
    }

    public static Dimension rectangleDoubleToDimension(Rectangle2D.Double rectangle) {
        return new Dimension((int)Math.round(rectangle.width), (int)Math.round(rectangle.height));
    }

    public AffineTransform getTransform() {
        if (FloatingPointUtil.equals(this.rotation, 0.0)) {
            return null;
        }
        Dimension rotatedMapSize = this.getRotatedMapSize();
        AffineTransform transform = AffineTransform.getTranslateInstance(0.0, 0.0);
        transform.translate(this.mapSize.width / 2, this.mapSize.height / 2);
        transform.rotate(this.rotation);
        transform.translate(-rotatedMapSize.width / 2, -rotatedMapSize.height / 2);
        return transform;
    }

    public double getDPI() {
        return this.dpi;
    }

    public double getRequestorDPI() {
        return this.requestorDpi;
    }

    private double getRotatedMapWidth() {
        double width = this.mapSize.getWidth();
        if (!FloatingPointUtil.equals(this.rotation, 0.0)) {
            double height = this.mapSize.getHeight();
            width = Math.abs(width * Math.cos(this.rotation)) + Math.abs(height * Math.sin(this.rotation));
        }
        return width;
    }

    private double getRotatedMapHeight() {
        double height = this.mapSize.getHeight();
        if (!FloatingPointUtil.equals(this.rotation, 0.0)) {
            double width = this.mapSize.getWidth();
            height = Math.abs(height * Math.cos(this.rotation)) + Math.abs(width * Math.sin(this.rotation));
        }
        return height;
    }

    public Rectangle getPaintArea() {
        return new Rectangle(this.mapSize);
    }

    @Nullable
    public Boolean isForceLongitudeFirst() {
        return this.forceLongitudeFirst;
    }

    public Boolean isDpiSensitiveStyle() {
        return this.dpiSensitiveStyle;
    }

    public ReferencedEnvelope toReferencedEnvelope() {
        return this.bounds.toReferencedEnvelope(this.getPaintArea(), this.dpi);
    }

    @Nullable
    public MapfishMapContext getParentContext() {
        return this.parent;
    }

    @Nonnull
    public MapfishMapContext getRootContext() {
        if (this.parent != null) {
            return this.parent.getRootContext();
        }
        return this;
    }
}

