/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import org.mapfish.print.attribute.map.ZoomLevels;

public enum ZoomLevelSnapStrategy {
    CLOSEST_LOWER_SCALE_ON_TIE{

        @Override
        protected SearchResult search(double scaleDenominator, double tolerance, ZoomLevels zoomLevels) {
            int pos = zoomLevels.size() - 1;
            double distance = Math.abs(zoomLevels.get(pos) - scaleDenominator);
            for (int i = zoomLevels.size() - 2; i >= 0; --i) {
                double cur = zoomLevels.get(i);
                double newDistance = Math.abs(scaleDenominator - cur);
                if (!(newDistance < distance)) continue;
                distance = newDistance;
                pos = i;
                if (distance < 1.0E-11) break;
            }
            return new SearchResult(pos, zoomLevels);
        }
    }
    ,
    CLOSEST_HIGHER_SCALE_ON_TIE{

        @Override
        protected SearchResult search(double scaleDenominator, double tolerance, ZoomLevels zoomLevels) {
            int pos = zoomLevels.size() - 1;
            double distance = Math.abs(zoomLevels.get(pos) - scaleDenominator);
            for (int i = 1; i < zoomLevels.size(); ++i) {
                double cur = zoomLevels.get(i);
                double newDistance = Math.abs(scaleDenominator - cur);
                if (!(newDistance < distance)) continue;
                distance = newDistance;
                pos = i;
                if (distance < 1.0E-11) break;
            }
            return new SearchResult(pos, zoomLevels);
        }
    }
    ,
    HIGHER_SCALE{

        @Override
        protected SearchResult search(double scaleDenominator, double tolerance, ZoomLevels zoomLevels) {
            double cutOff = scaleDenominator * (1.0 - tolerance);
            int pos = zoomLevels.size() - 1;
            for (int i = zoomLevels.size() - 1; i >= 0; --i) {
                double cur = zoomLevels.get(i);
                if (!(cur >= cutOff)) continue;
                pos = i;
                break;
            }
            return new SearchResult(pos, zoomLevels);
        }
    }
    ,
    LOWER_SCALE{

        @Override
        protected SearchResult search(double scaleDenominator, double tolerance, ZoomLevels zoomLevels) {
            double cutOff = scaleDenominator * (1.0 + tolerance);
            int pos = 0;
            for (int i = 1; i < zoomLevels.size(); ++i) {
                double cur = zoomLevels.get(i);
                if (!(cur <= cutOff)) continue;
                pos = i;
                break;
            }
            return new SearchResult(pos, zoomLevels);
        }
    };


    protected abstract SearchResult search(double var1, double var3, ZoomLevels var5);

    private static class Constants {
        private static final double DISTANCE_TREATED_AS_EQUAL = 1.0E-11;

        private Constants() {
        }
    }

    public static final class SearchResult {
        private final int zoomLevel;
        private final ZoomLevels zoomLevels;

        SearchResult(int zoomLevel, ZoomLevels zoomLevels) {
            this.zoomLevel = zoomLevel;
            this.zoomLevels = zoomLevels;
        }

        public int getZoomLevel() {
            return this.zoomLevel;
        }

        public ZoomLevels getZoomLevels() {
            return this.zoomLevels;
        }

        public double getScaleDenominator() {
            return this.zoomLevels.get(this.zoomLevel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchResult that = (SearchResult)o;
            if (this.zoomLevel != that.zoomLevel) {
                return false;
            }
            return this.zoomLevels.equals(that.zoomLevels);
        }

        public int hashCode() {
            int result = this.zoomLevel;
            result = 31 * result + this.zoomLevels.hashCode();
            return result;
        }

        public String toString() {
            return "SearchResult{zoomLevel=" + this.zoomLevel + ", scale=" + this.zoomLevels.get(this.zoomLevel) + ", zoomLevels=" + this.zoomLevels + '}';
        }
    }
}

