/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map;

import com.vividsolutions.jts.geom.Coordinate;
import javax.annotation.Nonnull;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.map.DistanceUnit;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scale {
    private final double resolution;
    private static final Logger LOGGER = LoggerFactory.getLogger(Scale.class);

    public Scale(double denominator, @Nonnull CoordinateReferenceSystem projection, double dpi) {
        this(denominator, DistanceUnit.fromProjection(projection), dpi);
    }

    public Scale(double denominator, @Nonnull DistanceUnit projectionUnit, double dpi) {
        this(1.0 / (projectionUnit.convertTo(1.0 / denominator, DistanceUnit.IN) * dpi));
    }

    private Scale(double resolution) {
        this.resolution = resolution;
    }

    public double getResolution() {
        return this.resolution;
    }

    public double getDenominator(boolean geodetic, @Nonnull CoordinateReferenceSystem projection, double dpi, Coordinate position) {
        return geodetic ? this.getGeodeticDenominator(projection, dpi, position) : this.getDenominator(projection, dpi);
    }

    public double getDenominator(@Nonnull CoordinateReferenceSystem projection, double dpi) {
        return this.getDenominator(DistanceUnit.fromProjection(projection), dpi);
    }

    public double getDenominator(@Nonnull DistanceUnit projectionUnit, double dpi) {
        double resolutionInInches = projectionUnit.convertTo(this.resolution, DistanceUnit.IN);
        return resolutionInInches * dpi;
    }

    public double getGeodeticDenominator(@Nonnull CoordinateReferenceSystem projection, double dpi, Coordinate position) {
        DistanceUnit projectionUnit = DistanceUnit.fromProjection(projection);
        double scaleDenominator = this.getDenominator(projectionUnit, dpi);
        if (projectionUnit == DistanceUnit.DEGREES) {
            return scaleDenominator;
        }
        try {
            double width = 1.0;
            double geoWidthInches = scaleDenominator * width / dpi;
            double geoWidth = DistanceUnit.IN.convertTo(geoWidthInches, projectionUnit);
            double minGeoX = position.y - geoWidth / 2.0;
            double maxGeoX = minGeoX + geoWidth;
            GeodeticCalculator calculator = new GeodeticCalculator(projection);
            double centerY = position.y;
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)projection, (CoordinateReferenceSystem)GenericMapAttribute.parseProjection("EPSG:4326", true));
            Coordinate start = JTS.transform((Coordinate)new Coordinate(minGeoX, centerY), null, (MathTransform)transform);
            Coordinate end = JTS.transform((Coordinate)new Coordinate(maxGeoX, centerY), null, (MathTransform)transform);
            calculator.setStartingGeographicPoint(start.x, start.y);
            calculator.setDestinationGeographicPoint(end.x, end.y);
            double geoWidthInEllipsoidUnits = calculator.getOrthodromicDistance();
            DistanceUnit ellipsoidUnit = DistanceUnit.fromString(calculator.getEllipsoid().getAxisUnit().toString());
            double geoWidthInInches = ellipsoidUnit.convertTo(geoWidthInEllipsoidUnits, DistanceUnit.IN);
            return geoWidthInInches * (dpi / width);
        }
        catch (FactoryException e) {
            LOGGER.error("Unable to do the geodetic calculation on the scale", (Throwable)e);
        }
        catch (TransformException e) {
            LOGGER.error("Unable to do the geodetic calculation on the scale", (Throwable)e);
        }
        return this.getDenominator(projectionUnit, dpi);
    }

    public static double getDenominator(boolean geodetic, double scaleDenominator, @Nonnull CoordinateReferenceSystem projection, double dpi, Coordinate position) {
        return geodetic ? Scale.getGeodeticDenominator(scaleDenominator, projection, dpi, position) : scaleDenominator;
    }

    public static double getGeodeticDenominator(double scaleDenominator, @Nonnull CoordinateReferenceSystem projection, double dpi, Coordinate position) {
        return new Scale(scaleDenominator, DistanceUnit.fromProjection(projection), dpi).getGeodeticDenominator(projection, dpi, position);
    }

    public static Scale fromResolution(double resolution) {
        return new Scale(resolution);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scale scale = (Scale)o;
        return Double.compare(scale.resolution, this.resolution) == 0;
    }

    public int hashCode() {
        return new Double(this.resolution).hashCode();
    }

    public String toString() {
        return "Scale{resolution=" + this.resolution + '}';
    }
}

