/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.mapfish.print.map.geotools.grid.GridLabel;

enum RotationQuadrant {
    QUADRANT_1{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.rotate(Constants.MINUS_NINETY_RADIANS);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                case BOTTOM: {
                    baseTransform.rotate(Constants.MINUS_NINETY_RADIANS);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                case RIGHT: {
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.translate(indent, halfCharHeight);
                }
            }
        }
    }
    ,
    QUADRANT_2{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.rotate(Constants.MINUS_NINETY_RADIANS);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                case BOTTOM: {
                    baseTransform.rotate(Constants.MINUS_NINETY_RADIANS);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                case RIGHT: {
                    baseTransform.rotate(Constants.ONE_EIGHTY_RADIANS);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.rotate(Constants.ONE_EIGHTY_RADIANS);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                }
            }
        }
    }
    ,
    QUADRANT_3{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.rotate(Constants.NINETY_RADIANS);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                case BOTTOM: {
                    baseTransform.rotate(Constants.NINETY_RADIANS);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                case RIGHT: {
                    baseTransform.rotate(Constants.ONE_EIGHTY_RADIANS);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.rotate(Constants.ONE_EIGHTY_RADIANS);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                }
            }
        }
    }
    ,
    QUADRANT_4{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.rotate(Constants.NINETY_RADIANS);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                case BOTTOM: {
                    baseTransform.rotate(Constants.NINETY_RADIANS);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                case RIGHT: {
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.translate(indent, halfCharHeight);
                }
            }
        }
    }
    ,
    NO_ROTATION{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.translate(-textBounds.getWidth() / 2.0, (double)indent + (double)halfCharHeight * 2.0);
                    break;
                }
                case BOTTOM: {
                    baseTransform.translate(-textBounds.getWidth() / 2.0, -halfCharHeight - indent);
                    break;
                }
                case RIGHT: {
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.translate(indent, halfCharHeight);
                }
            }
        }
    };

    public static final int THREE_SIXTY_DEGREES = 360;

    abstract void updateTransform(AffineTransform var1, int var2, GridLabel.Side var3, int var4, Rectangle2D var5);

    static RotationQuadrant getQuadrant(double rotationDegrees, boolean rotate) {
        double rotation;
        if (!rotate) {
            return NO_ROTATION;
        }
        for (rotation = rotationDegrees; rotation > 360.0; rotation -= 360.0) {
        }
        while (rotation < 0.0) {
            rotation += 360.0;
        }
        if (rotation > 0.0 && rotation <= 90.0) {
            return QUADRANT_1;
        }
        if (rotation > 90.0 && rotation <= 180.0) {
            return QUADRANT_2;
        }
        if (rotation > 180.0 && rotation <= 270.0) {
            return QUADRANT_3;
        }
        return QUADRANT_4;
    }

    private static class Constants {
        public static final double MINUS_NINETY_RADIANS = Math.toRadians(-90.0);
        public static final double ONE_EIGHTY_RADIANS = Math.toRadians(180.0);
        public static final double NINETY_RADIANS = Math.toRadians(90.0);

        private Constants() {
        }
    }
}

