/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.io.Closer;
import com.vividsolutions.jts.util.Assert;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.imageio.ImageIO;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.HttpRequestCache;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.AbstractSingleImageLayer;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.map.image.wms.WmsUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class WmsLayer
extends AbstractSingleImageLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmsLayer.class);
    private final WmsLayerParam params;
    private final MetricRegistry registry;
    private ClientHttpRequest imageRequest;

    protected WmsLayer(ExecutorService executorService, StyleSupplier<GridCoverage2D> styleSupplier, WmsLayerParam params, MetricRegistry registry) {
        super(executorService, styleSupplier, params);
        this.params = params;
        this.registry = registry;
    }

    @Override
    protected BufferedImage loadImage(MfClientHttpRequestFactory requestFactory, MapfishMapContext transformer) throws Throwable {
        Closer closer = Closer.create();
        String baseMetricName = WmsLayer.class.getName() + ".read." + this.imageRequest.getURI().getHost();
        try {
            Timer.Context timerDownload = this.registry.timer(baseMetricName).time();
            ClientHttpResponse response = (ClientHttpResponse)closer.register((Closeable)this.imageRequest.execute());
            Assert.isTrue((response != null ? 1 : 0) != 0, (String)"No response, see error above");
            Assert.equals((Object)HttpStatus.OK, (Object)response.getStatusCode(), (String)("Http status code for " + this.imageRequest.getURI() + " was not OK.  It was: " + response.getStatusCode() + ".  The response message was: '" + response.getStatusText() + "'"));
            BufferedImage image = ImageIO.read(response.getBody());
            if (image == null) {
                LOGGER.warn("The URI: " + this.imageRequest.getURI() + " is an image format that can be decoded");
                this.registry.counter(baseMetricName + ".error").inc();
                BufferedImage bufferedImage = this.createErrorImage(transformer.getPaintArea());
                return bufferedImage;
            }
            timerDownload.stop();
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Throwable e) {
            this.registry.counter(baseMetricName + ".error").inc();
            throw e;
        }
        finally {
            closer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createErrorImage(Rectangle area) {
        BufferedImage bufferedImage = new BufferedImage(area.width, area.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        try {
            graphics.setBackground(new Color(255, 255, 255, 125));
            graphics.clearRect(0, 0, area.width, area.height);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            graphics.dispose();
        }
    }

    public WmsLayerParam getParams() {
        return this.params;
    }

    @Override
    public boolean supportsNativeRotation() {
        return this.params.getCustomParams().containsKey((Object)"angle") || this.params.getMergeableParams().containsKey((Object)"angle");
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.fromMimeType(this.params.imageFormat);
    }

    @Override
    public void cacheResources(HttpRequestCache httpRequestCache, MfClientHttpRequestFactory requestFactory, MapfishMapContext transformer) {
        try {
            MapfishMapContext layerTransformer = this.getLayerTransformer(transformer);
            WmsLayerParam wmsLayerParam = this.params;
            URI commonUri = new URI(wmsLayerParam.getBaseUrl());
            Rectangle paintArea = layerTransformer.getPaintArea();
            ReferencedEnvelope envelope = layerTransformer.getBounds().toReferencedEnvelope(paintArea, layerTransformer.getDPI());
            URI uri = WmsUtilities.makeWmsGetLayerRequest(requestFactory, wmsLayerParam, commonUri, paintArea.getSize(), layerTransformer.getDPI(), envelope);
            this.imageRequest = httpRequestCache.register(requestFactory, uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

