/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import com.codahale.metrics.MetricRegistry;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import jsr166y.ForkJoinPool;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.HttpRequestCache;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractGeotoolsLayer;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.tiled.CoverageTask;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.TilePreparationInfo;
import org.mapfish.print.map.tiled.TilePreparationTask;

public abstract class AbstractTiledLayer
extends AbstractGeotoolsLayer {
    private final StyleSupplier<GridCoverage2D> styleSupplier;
    private final MetricRegistry registry;
    private TileCacheInformation tileCacheInformation;
    private TilePreparationInfo tilePreparationInfo;
    protected double imageBufferScaling = 1.0;

    protected AbstractTiledLayer(ForkJoinPool forkJoinPool, StyleSupplier<GridCoverage2D> styleSupplier, AbstractLayerParams params, MetricRegistry registry) {
        super((ExecutorService)forkJoinPool, params);
        this.styleSupplier = styleSupplier;
        this.registry = registry;
    }

    @Override
    public final void prepareRender(MapfishMapContext mapContext) {
        this.tileCacheInformation = this.createTileInformation(mapContext.getRotatedBoundsAdjustedForPreciseRotatedMapSize(), new Rectangle(mapContext.getRotatedMapSize()), mapContext.getDPI());
    }

    @Override
    protected final List<? extends Layer> getLayers(MfClientHttpRequestFactory httpRequestFactory, MapfishMapContext mapContext) throws Exception {
        CoverageTask task = new CoverageTask(this.tilePreparationInfo, this.getFailOnError(), this.registry, this.tileCacheInformation);
        GridCoverage2D gridCoverage2D = task.call();
        GridCoverageLayer layer = new GridCoverageLayer(gridCoverage2D, this.styleSupplier.load(httpRequestFactory, gridCoverage2D));
        return Collections.singletonList(layer);
    }

    protected abstract TileCacheInformation createTileInformation(MapBounds var1, Rectangle var2, double var3);

    @Override
    public final double getImageBufferScaling() {
        return this.imageBufferScaling;
    }

    @Override
    public final void cacheResources(HttpRequestCache httpRequestCache, MfClientHttpRequestFactory clientHttpRequestFactory, MapfishMapContext transformer) {
        MapfishMapContext layerTransformer = this.getLayerTransformer(transformer);
        double dpi = transformer.getDPI();
        TilePreparationTask task = new TilePreparationTask(clientHttpRequestFactory, dpi, layerTransformer, this.tileCacheInformation, httpRequestCache);
        this.tilePreparationInfo = task.call();
    }
}

