/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl;

import java.net.URI;
import java.net.URISyntaxException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.servlet.job.PrintJobResult;

@Entity
@Table
public class PrintJobResultImpl
implements PrintJobResult {
    @Column
    @Id
    private final String reportURI;
    @Column
    private final String mimeType;
    @Column
    private final String fileExtension;
    @Column
    private final String fileName;

    public PrintJobResultImpl() {
        this.reportURI = null;
        this.mimeType = null;
        this.fileExtension = null;
        this.fileName = null;
    }

    public PrintJobResultImpl(URI reportURI, String fileName, String fileExtension, String mimeType) {
        this.reportURI = reportURI.toString();
        this.mimeType = mimeType;
        this.fileName = fileName;
        this.fileExtension = fileExtension;
    }

    @Override
    public final URI getReportURI() {
        try {
            return this.reportURI == null ? null : new URI(this.reportURI);
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    @Override
    public final String getReportURIString() {
        return this.reportURI;
    }

    @Override
    public final String getMimeType() {
        return this.mimeType;
    }

    @Override
    public final String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public final String getFileName() {
        return this.fileName;
    }
}

