/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.geotools.referencing.CRS;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.attribute.ReflectiveAttribute;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.parser.MapfishParser;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class GenericMapAttribute
extends ReflectiveAttribute<GenericMapAttributeValues> {
    private static final double[] DEFAULT_DPI_VALUES = new double[]{72.0, 120.0, 200.0, 254.0, 300.0, 600.0, 1200.0, 2400.0};
    public static final String JSON_DPI_SUGGESTIONS = "dpiSuggestions";
    public static final String JSON_MAX_DPI = "maxDPI";
    public static final String JSON_MAP_WIDTH = "width";
    public static final String JSON_MAP_HEIGHT = "height";
    public static final String JSON_MAX_WIDTH = "maxWidth";
    public static final String JSON_MAX_HEIGHT = "maxHeight";
    static final String JSON_ZOOM_LEVEL_SUGGESTIONS = "scales";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MapfishParser mapfishJsonParser;
    private Double maxDpi = null;
    private double[] dpiSuggestions = null;
    private ZoomLevels zoomLevels = null;
    private Double zoomSnapTolerance = null;
    private ZoomLevelSnapStrategy zoomLevelSnapStrategy = null;
    private Boolean zoomSnapGeodetic = null;
    private Integer width = null;
    private Integer height = null;
    private Integer maxWidth = null;
    private Integer maxHeight = null;

    public final Double getMaxDpi() {
        return this.maxDpi;
    }

    public final void setMaxDpi(Double maxDpi) {
        this.maxDpi = maxDpi;
    }

    public final double[] getDpiSuggestions() {
        if (this.dpiSuggestions == null) {
            ArrayList list = Lists.newArrayList();
            for (double suggestion : DEFAULT_DPI_VALUES) {
                if (!(suggestion <= this.maxDpi)) continue;
                list.add(suggestion);
            }
            double[] suggestions = new double[list.size()];
            for (int i = 0; i < suggestions.length; ++i) {
                suggestions[i] = (Double)list.get(i);
            }
            return suggestions;
        }
        return this.dpiSuggestions;
    }

    public final void setDpiSuggestions(double[] dpiSuggestions) {
        this.dpiSuggestions = dpiSuggestions;
    }

    public final Integer getWidth() {
        return this.width;
    }

    public final void setWidth(Integer width) {
        this.width = width;
    }

    public final Integer getHeight() {
        return this.height;
    }

    public final void setHeight(Integer height) {
        this.height = height;
    }

    public final Integer getMaxWidth() {
        return this.maxWidth;
    }

    public final void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public final Integer getMaxHeight() {
        return this.maxHeight;
    }

    public final void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    public final void setZoomLevels(ZoomLevels zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    public final void setZoomSnapTolerance(Double zoomSnapTolerance) {
        this.zoomSnapTolerance = zoomSnapTolerance;
    }

    public final void setZoomLevelSnapStrategy(ZoomLevelSnapStrategy zoomLevelSnapStrategy) {
        this.zoomLevelSnapStrategy = zoomLevelSnapStrategy;
    }

    public final void setZoomSnapGeodetic(Boolean zoomSnapGeodetic) {
        this.zoomSnapGeodetic = zoomSnapGeodetic;
    }

    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.width != null && this.maxWidth != null) {
            validationErrors.add((Throwable)new ConfigurationException("cannot set both width and maxWidth in " + this.getClass().getName()));
        }
        if (this.height != null && this.maxHeight != null) {
            validationErrors.add((Throwable)new ConfigurationException("cannot set both height and maxHeight in " + this.getClass().getName()));
        }
        if (this.width != null && this.width < 1) {
            validationErrors.add((Throwable)new ConfigurationException("width field is not legal: " + this.width + " in " + this.getClass().getName()));
        }
        if (this.height != null && this.height < 1) {
            validationErrors.add((Throwable)new ConfigurationException("height field is not legal: " + this.height + " in " + this.getClass().getName()));
        }
        if (this.maxWidth != null && this.maxWidth < 1) {
            validationErrors.add((Throwable)new ConfigurationException("max width field is not legal: " + this.width + " in " + this.getClass().getName()));
        }
        if (this.maxHeight != null && this.maxHeight < 1) {
            validationErrors.add((Throwable)new ConfigurationException("max height field is not legal: " + this.height + " in " + this.getClass().getName()));
        }
        if (this.getMaxDpi() == null || this.getMaxDpi() < 1.0) {
            validationErrors.add((Throwable)new ConfigurationException("maxDpi field is not legal: " + this.getMaxDpi() + " in " + this.getClass().getName()));
        }
        if (this.getMaxDpi() != null && this.getDpiSuggestions() != null) {
            for (double dpi : this.getDpiSuggestions()) {
                if (!(dpi < 1.0) && !(dpi > this.getMaxDpi())) continue;
                validationErrors.add((Throwable)new ConfigurationException("dpiSuggestions contains an invalid value: " + dpi + " in " + this.getClass().getName()));
            }
        }
    }

    protected final Optional<JSONObject> getClientInfo() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_DPI_SUGGESTIONS, (Object)this.getDpiSuggestions());
        if (this.zoomLevels != null) {
            jsonObject.put(JSON_ZOOM_LEVEL_SUGGESTIONS, (Object)this.zoomLevels.getScaleDenominators());
        }
        jsonObject.put(JSON_MAX_DPI, (Object)this.maxDpi);
        jsonObject.put(JSON_MAP_WIDTH, (Object)this.width);
        jsonObject.put(JSON_MAP_HEIGHT, (Object)this.height);
        jsonObject.put(JSON_MAX_WIDTH, (Object)this.maxWidth);
        jsonObject.put(JSON_MAX_HEIGHT, (Object)this.maxHeight);
        return Optional.of((Object)jsonObject);
    }

    public static CoordinateReferenceSystem parseProjection(String projection, Boolean longitudeFirst) {
        String epsgCode = projection;
        try {
            if (longitudeFirst == null) {
                return CRS.decode((String)epsgCode);
            }
            return CRS.decode((String)epsgCode, (boolean)longitudeFirst);
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new RuntimeException(epsgCode + " was not recognized as a crs code", e);
        }
        catch (FactoryException e) {
            throw new RuntimeException("Error occurred while parsing: " + epsgCode, e);
        }
    }

    static /* synthetic */ ApplicationContext access$000(GenericMapAttribute x0) {
        return x0.applicationContext;
    }

    static /* synthetic */ MapfishParser access$100(GenericMapAttribute x0) {
        return x0.mapfishJsonParser;
    }

    static /* synthetic */ ZoomLevels access$200(GenericMapAttribute x0) {
        return x0.zoomLevels;
    }

    static /* synthetic */ Double access$300(GenericMapAttribute x0) {
        return x0.zoomSnapTolerance;
    }

    static /* synthetic */ ZoomLevelSnapStrategy access$400(GenericMapAttribute x0) {
        return x0.zoomLevelSnapStrategy;
    }

    static /* synthetic */ Boolean access$500(GenericMapAttribute x0) {
        return x0.zoomSnapGeodetic;
    }
}

