/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.mapfish.print.config.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomFontLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFontLoader.class);

    public CustomFontLoader(Set<String> paths) {
        for (String path : paths) {
            try {
                this.loadFont(path);
            }
            catch (FontFormatException e) {
                throw new ConfigurationException("Font could not be created " + path, (Throwable)e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Can not read font file " + path, (Throwable)e);
            }
        }
    }

    private void loadFont(String path) throws FontFormatException, IOException {
        File fontFile;
        URL url = CustomFontLoader.class.getClassLoader().getResource(path);
        if (url != null) {
            fontFile = new File(url.getFile());
            if (!fontFile.canRead()) {
                throw new ConfigurationException("Can not read font file " + fontFile.getAbsolutePath());
            }
        } else {
            throw new ConfigurationException("Can not read font file " + path);
        }
        Font font = Font.createFont(0, fontFile);
        this.registerFont(font, fontFile);
    }

    private void registerFont(Font font, File fontFile) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        boolean registered = ge.registerFont(font);
        if (!registered) {
            LOGGER.warn("Font " + fontFile.getAbsolutePath() + " could not be registered. Is there already a system font with the same name?");
        } else {
            LOGGER.info("Font " + fontFile.getAbsolutePath() + " registered successfully");
        }
    }
}

