/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import javax.annotation.Nonnull;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.grid.GridLabelFormat;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.GridType;
import org.mapfish.print.map.geotools.grid.GridUtils;
import org.mapfish.print.map.geotools.grid.LabelPositionCollector;
import org.mapfish.print.map.geotools.grid.LineGridStyle;
import org.mapfish.print.map.geotools.grid.LinearCoordinateSequence;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.MathTransform;

final class LineGridStrategy
implements GridType.GridTypeStrategy {
    LineGridStrategy() {
    }

    public Style defaultStyle(Template template, GridParam layerData) {
        return LineGridStyle.get((GridParam)layerData);
    }

    public FeatureSourceSupplier createFeatureSource(Template template, GridParam layerData, LabelPositionCollector labels) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    private DefaultFeatureCollection createFeaturesFromNumberOfLines(@Nonnull MapfishMapContext mapContext, @Nonnull SimpleFeatureBuilder featureBuilder, @Nonnull GridParam layerData, @Nonnull LabelPositionCollector labels) {
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        double xSpace = bounds.getWidth() / (double)(layerData.numberOfLines[0] + 1);
        double ySpace = bounds.getHeight() / (double)(layerData.numberOfLines[1] + 1);
        double minX = bounds.getMinimum(0) + xSpace;
        double minY = bounds.getMinimum(1) + ySpace;
        return this.sharedCreateFeatures(labels, featureBuilder, layerData, mapContext, xSpace, ySpace, minX, minY);
    }

    @Nonnull
    private DefaultFeatureCollection createFeaturesFromSpacing(@Nonnull MapfishMapContext mapContext, @Nonnull SimpleFeatureBuilder featureBuilder, @Nonnull GridParam layerData, @Nonnull LabelPositionCollector labels) {
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        double xSpace = layerData.spacing[0];
        double ySpace = layerData.spacing[1];
        double minX = GridUtils.calculateFirstLine((ReferencedEnvelope)bounds, (GridParam)layerData, (int)0);
        double minY = GridUtils.calculateFirstLine((ReferencedEnvelope)bounds, (GridParam)layerData, (int)1);
        return this.sharedCreateFeatures(labels, featureBuilder, layerData, mapContext, xSpace, ySpace, minX, minY);
    }

    private DefaultFeatureCollection sharedCreateFeatures(LabelPositionCollector labels, SimpleFeatureBuilder featureBuilder, GridParam layerData, MapfishMapContext mapContext, double xSpace, double ySpace, double minX, double minY) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        CoordinateReferenceSystem mapCrs = bounds.getCoordinateReferenceSystem();
        String unit = layerData.calculateLabelUnit(mapCrs);
        MathTransform labelTransform = layerData.calculateLabelTransform(mapCrs);
        AxisDirection direction = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection();
        int numDimensions = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        Polygon rotatedBounds = GridUtils.calculateBounds((MapfishMapContext)mapContext);
        AffineTransform worldToScreenTransform = GridUtils.getWorldToScreenTransform((MapfishMapContext)mapContext);
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        double pointSpacing = bounds.getSpan(1) / (double)layerData.pointsInLine;
        int i = 0;
        for (double x = minX; x < bounds.getMaxX(); x += xSpace) {
            SimpleFeature feature = this.createFeature(featureBuilder, geometryFactory, layerData, direction, numDimensions, pointSpacing, x, bounds.getMinimum(1), ++i, 1);
            features.add(feature);
            GridUtils.topBorderLabel((LabelPositionCollector)labels, (GeometryFactory)geometryFactory, (Polygon)rotatedBounds, (String)unit, (double)x, (AffineTransform)worldToScreenTransform, (MathTransform)labelTransform, (GridLabelFormat)layerData.getGridLabelFormat());
            GridUtils.bottomBorderLabel((LabelPositionCollector)labels, (GeometryFactory)geometryFactory, (Polygon)rotatedBounds, (String)unit, (double)x, (AffineTransform)worldToScreenTransform, (MathTransform)labelTransform, (GridLabelFormat)layerData.getGridLabelFormat());
        }
        pointSpacing = bounds.getSpan(0) / (double)layerData.pointsInLine;
        int j = 0;
        for (double y = minY; y < bounds.getMaxY(); y += ySpace) {
            SimpleFeature feature = this.createFeature(featureBuilder, geometryFactory, layerData, direction, numDimensions, pointSpacing, bounds.getMinimum(0), y, ++j, 0);
            features.add(feature);
            GridUtils.rightBorderLabel((LabelPositionCollector)labels, (GeometryFactory)geometryFactory, (Polygon)rotatedBounds, (String)unit, (double)y, (AffineTransform)worldToScreenTransform, (MathTransform)labelTransform, (GridLabelFormat)layerData.getGridLabelFormat());
            GridUtils.leftBorderLabel((LabelPositionCollector)labels, (GeometryFactory)geometryFactory, (Polygon)rotatedBounds, (String)unit, (double)y, (AffineTransform)worldToScreenTransform, (MathTransform)labelTransform, (GridLabelFormat)layerData.getGridLabelFormat());
        }
        return features;
    }

    private SimpleFeature createFeature(SimpleFeatureBuilder featureBuilder, GeometryFactory geometryFactory, GridParam layerData, AxisDirection direction, int numDimensions, double spacing, double x, double y, int i, int ordinate) {
        featureBuilder.reset();
        int numPoints = layerData.pointsInLine + 1;
        LinearCoordinateSequence coordinateSequence = new LinearCoordinateSequence().setDimension(numDimensions).setOrigin(x, y).setVariableAxis(ordinate).setNumPoints(numPoints).setSpacing(spacing).setOrdinate0AxisDirection(direction);
        LineString geom = geometryFactory.createLineString((CoordinateSequence)coordinateSequence);
        featureBuilder.set("geom", (Object)geom);
        return featureBuilder.buildFeature("grid." + (ordinate == 1 ? (char)'x' : 'y') + "." + i);
    }

    static /* synthetic */ DefaultFeatureCollection access$000(LineGridStrategy x0, MapfishMapContext x1, SimpleFeatureBuilder x2, GridParam x3, LabelPositionCollector x4) {
        return x0.createFeaturesFromNumberOfLines(x1, x2, x3, x4);
    }

    static /* synthetic */ DefaultFeatureCollection access$100(LineGridStrategy x0, MapfishMapContext x1, SimpleFeatureBuilder x2, GridParam x3, LabelPositionCollector x4) {
        return x0.createFeaturesFromSpacing(x1, x2, x3, x4);
    }
}

