/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceUtil;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.StreamRepositoryService;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.output.MapfishPrintRepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;

class MapfishPrintRepositoryService
implements StreamRepositoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapfishPrintRepositoryService.class);
    private final MfClientHttpRequestFactory httpRequestFactory;
    private JasperReportsContext jasperReportsContext;

    MapfishPrintRepositoryService(@Nonnull MfClientHttpRequestFactory httpRequestFactory) {
        this.httpRequestFactory = httpRequestFactory;
        this.jasperReportsContext = DefaultJasperReportsContext.getInstance();
    }

    public InputStream getInputStream(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            uri = new File(uriString).toURI();
        }
        try {
            ClientHttpResponse response = this.httpRequestFactory.createRequest(uri, HttpMethod.GET).execute();
            return new ResponseClosingStream(response);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Resource getResource(String uri) {
        throw new UnsupportedOperationException();
    }

    public void saveResource(String uri, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        try {
            InputStream inputStream;
            if (resourceType.isAssignableFrom(InputStreamResource.class) && (inputStream = this.getInputStream(uri)) != null) {
                InputStreamResource resource = new InputStreamResource();
                resource.setInputStream(inputStream);
                return (K)((Resource)resourceType.cast(resource));
            }
            PersistenceUtil persistenceUtil = PersistenceUtil.getInstance((JasperReportsContext)this.jasperReportsContext);
            PersistenceService persistenceService = persistenceUtil.getService(FileRepositoryService.class, resourceType);
            if (persistenceService != null) {
                return (K)((Resource)resourceType.cast(persistenceService.load(uri, (RepositoryService)this)));
            }
        }
        catch (IllegalStateException e) {
            LOGGER.info("Resource not found {} ({}).", (Object)uri, (Object)e.toString());
        }
        catch (Exception e) {
            LOGGER.trace(String.format("Error on getting resource %s.", uri), (Throwable)e);
        }
        return null;
    }

    public OutputStream getOutputStream(String uri) {
        throw new UnsupportedOperationException();
    }
}

