/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.processor.http.matcher.InetHostMatcher;

public class AddressHostMatcher
extends InetHostMatcher {
    private String ip = null;
    private String mask = null;
    private InetAddress maskAddress = null;

    protected final List<InetHostMatcher.AddressMask> createAuthorizedIPs() throws UnknownHostException, SocketException {
        InetAddress[] ips = InetAddress.getAllByName(this.ip);
        ArrayList<InetHostMatcher.AddressMask> authorizedIPs = new ArrayList<InetHostMatcher.AddressMask>(ips.length);
        InetAddress theMask = this.getMaskAddress();
        for (InetAddress actualIp : ips) {
            authorizedIPs.add(new InetHostMatcher.AddressMask(actualIp, theMask));
        }
        return authorizedIPs;
    }

    private InetAddress getMaskAddress() throws UnknownHostException {
        if (this.maskAddress == null && this.mask != null) {
            this.maskAddress = InetAddress.getByName(this.mask);
        }
        return this.maskAddress;
    }

    public final void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.ip == null) {
            validationErrors.add((Throwable)new ConfigurationException("No IP address defined " + this.getClass().getName()));
        }
    }

    public final void setIp(String ip) {
        this.clearAuthorizedIPs();
        this.ip = ip;
    }

    public final void setMask(String mask) {
        this.clearAuthorizedIPs();
        this.maskAddress = null;
        this.mask = mask;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AddressHostMatcher");
        sb.append("{ip='").append(this.ip).append('\'');
        if (this.mask != null) {
            sb.append(", mask='").append(this.mask).append('\'');
        }
        if (this.port >= 0) {
            sb.append(", port=").append(this.port);
        }
        if (this.pathRegex != null) {
            sb.append(", pathRegexp=").append(this.pathRegex);
        }
        sb.append(", reject=").append(this.isReject());
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        result = 31 * result + (this.maskAddress == null ? 0 : this.maskAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressHostMatcher other = (AddressHostMatcher)obj;
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.mask == null ? other.mask != null : !this.mask.equals(other.mask)) {
            return false;
        }
        return !(this.maskAddress == null ? other.maskAddress != null : !this.maskAddress.equals(other.maskAddress));
    }
}

