/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.mapfish.print.attribute.LegendAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.ImagesSubReport;
import org.mapfish.print.processor.jasper.JasperReportBuilder;
import org.mapfish.print.processor.jasper.LegendProcessor;
import org.mapfish.print.processor.jasper.TableDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class LegendProcessor
extends AbstractProcessor<Input, Output> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegendProcessor.class);
    private static final String NAME_COLUMN = "name";
    private static final String ICON_COLUMN = "icon";
    private static final String REPORT_COLUMN = "report";
    private static final String LEVEL_COLUMN = "level";
    @Autowired
    private JasperReportBuilder jasperReportBuilder;
    @Autowired
    private MetricRegistry metricRegistry;
    @Resource(name="requestForkJoinPool")
    private ForkJoinPool requestForkJoinPool;
    private Dimension missingImageSize = new Dimension(24, 24);
    private BufferedImage missingImage;
    private Color missingImageColor = Color.PINK;
    private String template;
    private Integer maxWidth = null;
    private Double dpi = 72.0;
    private boolean scaled = false;

    protected LegendProcessor() {
        super(Output.class);
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setDpi(Double dpi) {
        this.dpi = dpi;
    }

    public void setScaled(boolean scaled) {
        this.scaled = scaled;
    }

    public Input createInputParameter() {
        return new Input();
    }

    public Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        ArrayList legendList = new ArrayList();
        String[] legendColumns = new String[]{NAME_COLUMN, ICON_COLUMN, REPORT_COLUMN, LEVEL_COLUMN};
        LegendAttribute.LegendAttributeValue legendAttributes = values.legend;
        this.fillLegend(values.clientHttpRequestFactoryProvider.get(), legendAttributes, legendList, context, values.tempTaskDirectory);
        Object[][] legend = new Object[legendList.size()][];
        JRTableModelDataSource dataSource = new JRTableModelDataSource((TableModel)new TableDataSource(legendColumns, (Object[][])legendList.toArray((T[])legend)));
        String compiledTemplatePath = this.compileTemplate(values.template.getConfiguration());
        return new Output(dataSource, legendList.size(), compiledTemplatePath);
    }

    private String compileTemplate(Configuration configuration) throws JRException {
        if (this.template != null) {
            File file = new File(configuration.getDirectory(), this.template);
            return this.jasperReportBuilder.compileJasperReport(configuration, file).getAbsolutePath();
        }
        return null;
    }

    private void createTasks(MfClientHttpRequestFactory clientHttpRequestFactory, LegendAttribute.LegendAttributeValue legendAttributes, Processor.ExecutionContext context, File tempTaskDirectory, int level, List<Callable<Object[]>> tasks) {
        int insertNameIndex = tasks.size();
        URL[] icons = legendAttributes.icons;
        if (icons != null && icons.length > 0) {
            for (URL uRL : icons) {
                tasks.add((Callable<Object[]>)new IconTask(this, uRL, context, level, tempTaskDirectory, clientHttpRequestFactory));
            }
        }
        if (legendAttributes.classes != null) {
            for (URL uRL : legendAttributes.classes) {
                this.createTasks(clientHttpRequestFactory, (LegendAttribute.LegendAttributeValue)uRL, context, tempTaskDirectory, level + 1, tasks);
            }
        }
        if (!tasks.isEmpty()) {
            tasks.add(insertNameIndex, (Callable<Object[]>)new NameTask(this, legendAttributes.name, level));
        }
    }

    private void fillLegend(MfClientHttpRequestFactory clientHttpRequestFactory, LegendAttribute.LegendAttributeValue legendAttributes, List<Object[]> legendList, Processor.ExecutionContext context, File tempTaskDirectory) throws ExecutionException, JRException, InterruptedException, IOException {
        ArrayList tasks = new ArrayList();
        this.createTasks(clientHttpRequestFactory, legendAttributes, context, tempTaskDirectory, 0, tasks);
        List futures = this.requestForkJoinPool.invokeAll(tasks);
        for (Future future : futures) {
            legendList.add((Object[])future.get());
        }
    }

    private URI createSubReport(BufferedImage originalImage, File tempTaskDirectory) throws IOException, JRException {
        assert (this.maxWidth != null);
        double scaleFactor = this.getScaleFactor();
        BufferedImage image = originalImage;
        if ((double)image.getWidth() * scaleFactor > (double)this.maxWidth.intValue()) {
            image = this.scaled ? this.scaleToMaxWidth(image, scaleFactor) : this.cropToMaxWidth(image, scaleFactor);
        }
        URI imageFile = this.writeToFile(image, tempTaskDirectory);
        ImagesSubReport subReport = new ImagesSubReport((List)Lists.newArrayList((Object[])new URI[]{imageFile}), new Dimension((int)Math.round((double)image.getWidth() * scaleFactor), (int)Math.round((double)image.getHeight() * scaleFactor)), this.dpi.doubleValue());
        File compiledReport = File.createTempFile("legend-report-", ".jasper", tempTaskDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }

    private BufferedImage cropToMaxWidth(BufferedImage image, double scaleFactor) {
        int width = (int)Math.round((double)this.maxWidth.intValue() / scaleFactor);
        return image.getSubimage(0, 0, width, image.getHeight());
    }

    private BufferedImage scaleToMaxWidth(BufferedImage image, double scaleFactor) {
        double factor = (double)this.maxWidth.intValue() / scaleFactor / (double)image.getWidth();
        BufferedImage result = new BufferedImage((int)Math.round((double)image.getWidth() * factor), (int)Math.round((double)image.getHeight() * factor), image.getType());
        AffineTransform at = new AffineTransform();
        at.scale(factor, factor);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        return scaleOp.filter(image, result);
    }

    private double getScaleFactor() {
        return 72.0 / this.dpi;
    }

    private URI writeToFile(BufferedImage image, File tempTaskDirectory) throws IOException {
        File path = File.createTempFile("legend-", ".png", tempTaskDirectory);
        ImageIO.write((RenderedImage)image, "png", path);
        return path.toURI();
    }

    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    private synchronized BufferedImage getMissingImage() {
        if (this.missingImage == null) {
            this.missingImage = new BufferedImage(this.missingImageSize.width, this.missingImageSize.height, 1);
            Graphics2D graphics = this.missingImage.createGraphics();
            try {
                graphics.setBackground(this.missingImageColor);
                graphics.clearRect(0, 0, this.missingImageSize.width, this.missingImageSize.height);
            }
            finally {
                graphics.dispose();
            }
        }
        return this.missingImage;
    }

    static /* synthetic */ void access$000(LegendProcessor x0, Processor.ExecutionContext x1) {
        x0.checkCancelState(x1);
    }

    static /* synthetic */ MetricRegistry access$100(LegendProcessor x0) {
        return x0.metricRegistry;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ BufferedImage access$300(LegendProcessor x0) {
        return x0.getMissingImage();
    }

    static /* synthetic */ Integer access$400(LegendProcessor x0) {
        return x0.maxWidth;
    }

    static /* synthetic */ URI access$500(LegendProcessor x0, BufferedImage x1, File x2) throws IOException, JRException {
        return x0.createSubReport(x1, x2);
    }
}

