/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.google.common.base.Strings;
import com.google.common.io.Closer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.processor.map.NorthArrowGraphic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

/*
 * Exception performing whole class analysis ignored.
 */
public final class NorthArrowGraphic {
    private static final Logger LOGGER = LoggerFactory.getLogger(NorthArrowGraphic.class);
    private static final String DEFAULT_GRAPHIC = "NorthArrow_10.svg";
    private static final String SVG_NS = "http://www.w3.org/2000/svg";

    private NorthArrowGraphic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URI create(Dimension targetSize, String graphicFile, Color backgroundColor, Double rotation, File workingDir, MfClientHttpRequestFactory clientHttpRequestFactory) throws Exception {
        try (Closer closer = Closer.create();){
            RasterReference input = NorthArrowGraphic.loadGraphic((String)graphicFile, (MfClientHttpRequestFactory)clientHttpRequestFactory, (Closer)closer);
            if (graphicFile == null || graphicFile.toLowerCase().trim().endsWith("svg")) {
                URI uRI = NorthArrowGraphic.createSvg((Dimension)targetSize, (RasterReference)input, (Double)rotation, (Color)backgroundColor, (File)workingDir);
                return uRI;
            }
            URI uRI = NorthArrowGraphic.createRaster((Dimension)targetSize, (RasterReference)input, (Double)rotation, (Color)backgroundColor, (File)workingDir);
            return uRI;
        }
    }

    private static RasterReference loadGraphic(String graphicFile, MfClientHttpRequestFactory clientHttpRequestFactory, Closer closer) throws IOException, URISyntaxException {
        if (Strings.isNullOrEmpty((String)graphicFile)) {
            URL file = NorthArrowGraphic.class.getResource("NorthArrow_10.svg");
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(file.toURI())));
            return new RasterReference((InputStream)closer.register((Closeable)inputStream), file.toURI());
        }
        URI uri = graphicFile.startsWith("file:") ? new URI(graphicFile.replace("\\", "/")) : new URI(graphicFile);
        ClientHttpRequest request = clientHttpRequestFactory.createRequest(uri, HttpMethod.GET);
        ClientHttpResponse response = (ClientHttpResponse)closer.register((Closeable)request.execute());
        return new RasterReference((InputStream)new BufferedInputStream(response.getBody()), uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI createRaster(Dimension targetSize, RasterReference rasterReference, Double rotation, Color backgroundColor, File workingDir) throws IOException {
        File path = File.createTempFile("north-arrow-", ".tiff", workingDir);
        BufferedImage newImage = new BufferedImage(targetSize.width, targetSize.height, 6);
        Graphics2D graphics2d = null;
        try {
            int newHeight;
            int newWidth;
            graphics2d = newImage.createGraphics();
            BufferedImage originalImage = ImageIO.read(RasterReference.access$000((RasterReference)rasterReference));
            if (originalImage == null) {
                LOGGER.warn("Unable to load NorthArrow graphic: " + RasterReference.access$100((RasterReference)rasterReference) + ", it is not an image format that can be decoded");
                throw new IllegalArgumentException();
            }
            graphics2d.setColor(backgroundColor);
            graphics2d.fillRect(0, 0, targetSize.width, targetSize.height);
            if (originalImage.getWidth() > originalImage.getHeight()) {
                newWidth = targetSize.width;
                newHeight = Math.min(targetSize.height, (int)Math.ceil((double)newWidth / ((double)originalImage.getWidth() / (double)originalImage.getHeight())));
            } else {
                newHeight = targetSize.height;
                newWidth = Math.min(targetSize.width, (int)Math.ceil((double)newHeight / ((double)originalImage.getHeight() / (double)originalImage.getWidth())));
            }
            int deltaX = (int)Math.floor((double)(targetSize.width - newWidth) / 2.0);
            int deltaY = (int)Math.floor((double)(targetSize.height - newHeight) / 2.0);
            if (!FloatingPointUtil.equals((double)rotation, (double)0.0)) {
                AffineTransform rotate = AffineTransform.getRotateInstance(rotation, (double)targetSize.width / 2.0, (double)targetSize.height / 2.0);
                graphics2d.setTransform(rotate);
            }
            graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2d.drawImage(originalImage, deltaX, deltaY, newWidth, newHeight, null);
            ImageIO.write((RenderedImage)newImage, "tiff", path);
        }
        finally {
            if (graphics2d != null) {
                graphics2d.dispose();
            }
        }
        return path.toURI();
    }

    private static URI createSvg(Dimension targetSize, RasterReference rasterReference, Double rotation, Color backgroundColor, File workingDir) throws IOException {
        SVGElement svgRoot = NorthArrowGraphic.parseSvg((InputStream)RasterReference.access$000((RasterReference)rasterReference));
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document newDocument = impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        SVGElement newSvgRoot = (SVGElement)newDocument.getDocumentElement();
        newSvgRoot.setAttributeNS(null, "width", Integer.toString(targetSize.width));
        newSvgRoot.setAttributeNS(null, "height", Integer.toString(targetSize.height));
        NorthArrowGraphic.setSvgBackground((Color)backgroundColor, (Dimension)targetSize, (Document)newDocument, (SVGElement)newSvgRoot);
        NorthArrowGraphic.embedSvgGraphic((SVGElement)svgRoot, (SVGElement)newSvgRoot, (Document)newDocument, (Dimension)targetSize, (Double)rotation);
        File path = NorthArrowGraphic.writeSvgToFile((Document)newDocument, (File)workingDir);
        return path.toURI();
    }

    private static void setSvgBackground(Color backgroundColor, Dimension targetSize, Document newDocument, SVGElement newSvgRoot) {
        Element rect = newDocument.createElementNS("http://www.w3.org/2000/svg", "rect");
        rect.setAttributeNS(null, "x", "0");
        rect.setAttributeNS(null, "y", "0");
        rect.setAttributeNS(null, "width", Integer.toString(targetSize.width));
        rect.setAttributeNS(null, "height", Integer.toString(targetSize.height));
        String bgColor = ColorParser.toRGB((Color)backgroundColor);
        rect.setAttributeNS(null, "fill", bgColor);
        String opacity = Double.toString((double)backgroundColor.getAlpha() / 255.0);
        rect.setAttributeNS(null, "fill-opacity", opacity);
        newSvgRoot.appendChild((Node)rect);
    }

    private static void embedSvgGraphic(SVGElement svgRoot, SVGElement newSvgRoot, Document newDocument, Dimension targetSize, Double rotation) {
        String originalWidth = svgRoot.getAttributeNS(null, "width");
        String originalHeight = svgRoot.getAttributeNS(null, "height");
        if (!Strings.isNullOrEmpty((String)originalWidth) && !Strings.isNullOrEmpty((String)originalHeight)) {
            Element wrapperContainer = newDocument.createElementNS("http://www.w3.org/2000/svg", "g");
            wrapperContainer.setAttributeNS(null, "transform", NorthArrowGraphic.getRotateTransformation((Dimension)targetSize, (double)rotation));
            newSvgRoot.appendChild((Node)wrapperContainer);
            Element wrapperSvg = newDocument.createElementNS("http://www.w3.org/2000/svg", "svg");
            wrapperSvg.setAttributeNS(null, "width", "100%");
            wrapperSvg.setAttributeNS(null, "height", "100%");
            wrapperSvg.setAttributeNS(null, "viewBox", "0 0 " + originalWidth + " " + originalHeight);
            wrapperContainer.appendChild(wrapperSvg);
            Node svgRootImported = newDocument.importNode((Node)svgRoot, true);
            wrapperSvg.appendChild(svgRootImported);
        } else if (Strings.isNullOrEmpty((String)originalWidth) && Strings.isNullOrEmpty((String)originalHeight)) {
            Element wrapperContainer = newDocument.createElementNS("http://www.w3.org/2000/svg", "g");
            wrapperContainer.setAttributeNS(null, "transform", NorthArrowGraphic.getRotateTransformation((Dimension)targetSize, (double)rotation));
            newSvgRoot.appendChild((Node)wrapperContainer);
            Node svgRootImported = newDocument.importNode((Node)svgRoot, true);
            wrapperContainer.appendChild(svgRootImported);
        } else {
            throw new IllegalArgumentException("Unsupported or invalid north-arrow SVG graphic: The same unit (px, em, %, ...) must be used for `width` and `height`.");
        }
    }

    private static String getRotateTransformation(Dimension targetSize, double rotation) {
        return "rotate(" + Double.toString(Math.toDegrees(rotation)) + " " + Integer.toString(targetSize.width / 2) + " " + Integer.toString(targetSize.height / 2) + ")";
    }

    private static SVGElement parseSvg(InputStream inputStream) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        SVGDocument document = (SVGDocument)f.createDocument("", inputStream);
        return (SVGElement)document.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeSvgToFile(Document document, File workingDir) throws IOException {
        File path = File.createTempFile("north-arrow-", ".svg", workingDir);
        try (FileWriterWithEncoding fw = null;){
            fw = new FileWriterWithEncoding(path, Charset.forName("UTF-8").newEncoder());
            DOMUtilities.writeDocument((Document)document, (Writer)fw);
            fw.flush();
        }
        return path;
    }
}

