/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationFactory;
import org.mapfish.print.config.WorkingDirectories;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.springframework.beans.factory.annotation.Autowired;

public class MapPrinter {
    private static final String OUTPUT_FORMAT_BEAN_NAME_ENDING = "OutputFormat";
    private static final String MAP_OUTPUT_FORMAT_BEAN_NAME_ENDING = "MapOutputFormat";
    private Configuration configuration;
    @Autowired
    private Map<String, OutputFormat> outputFormat;
    @Autowired
    private ConfigurationFactory configurationFactory;
    private File configFile;
    @Autowired
    private WorkingDirectories workingDirectories;

    public final void setConfiguration(File newConfigFile) throws IOException {
        this.setConfiguration(newConfigFile.toURI(), Files.toByteArray((File)newConfigFile));
    }

    public final void setConfiguration(URI newConfigFile, byte[] configFileData) throws IOException {
        this.configFile = new File(newConfigFile);
        this.configuration = this.configurationFactory.getConfig(this.configFile, (InputStream)new ByteArrayInputStream(configFileData));
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final void printClientConfig(JSONWriter json) throws JSONException {
        this.configuration.printClientConfig(json);
    }

    public static PJsonObject parseSpec(String spec) {
        JSONObject jsonSpec;
        try {
            jsonSpec = new JSONObject(spec);
        }
        catch (JSONException e) {
            throw new RuntimeException("Cannot parse the spec file: " + spec, e);
        }
        return new PJsonObject(jsonSpec, "spec");
    }

    public final OutputFormat getOutputFormat(PJsonObject specJson) {
        String format = specJson.getString("outputFormat");
        boolean mapExport = this.configuration.getTemplate(specJson.getString("layout")).isMapExport();
        String beanName = format + (mapExport ? MAP_OUTPUT_FORMAT_BEAN_NAME_ENDING : OUTPUT_FORMAT_BEAN_NAME_ENDING);
        if (!this.outputFormat.containsKey(beanName)) {
            throw new RuntimeException("Format '" + format + "' with mapExport '" + mapExport + "' is not supported.");
        }
        return (OutputFormat)this.outputFormat.get(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(String jobId, PJsonObject specJson, OutputStream out) throws Exception {
        OutputFormat format = this.getOutputFormat(specJson);
        File taskDirectory = this.workingDirectories.getTaskDirectory();
        try {
            format.print(jobId, specJson, this.getConfiguration(), this.configFile.getParentFile(), taskDirectory, out);
        }
        finally {
            this.workingDirectories.removeDirectory(taskDirectory);
        }
    }

    public final Set<String> getOutputFormatsNames() {
        TreeSet<String> formats = new TreeSet<String>();
        for (String formatBeanName : this.outputFormat.keySet()) {
            int endingIndex = formatBeanName.indexOf(MAP_OUTPUT_FORMAT_BEAN_NAME_ENDING);
            if (endingIndex < 0) {
                endingIndex = formatBeanName.indexOf(OUTPUT_FORMAT_BEAN_NAME_ENDING);
            }
            formats.add(formatBeanName.substring(0, endingIndex));
        }
        return formats;
    }
}

