/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.access;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.access.AccessAssertion;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public final class RoleAccessAssertion
implements AccessAssertion {
    private static final String JSON_ROLES = "roles";
    private Set<String> requiredRoles;

    public AccessAssertion setRequiredRoles(Collection<String> assertionRequiredRoles) {
        if (this.requiredRoles != null) {
            throw new AssertionError((Object)(this.getClass() + "#setRequiredRoles() may only be called once any further calls result in an exception"));
        }
        if (assertionRequiredRoles == null) {
            this.requiredRoles = Collections.unmodifiableSet(Collections.emptySet());
        } else if (assertionRequiredRoles instanceof Set) {
            Set roles = (Set)assertionRequiredRoles;
            this.requiredRoles = Collections.unmodifiableSet(roles);
        } else {
            this.requiredRoles = Collections.unmodifiableSet(Sets.newHashSet(assertionRequiredRoles));
        }
        return this;
    }

    public void assertAccess(String resourceDescription, Object protectedResource) {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null || context.getAuthentication() == null) {
            throw new AuthenticationCredentialsNotFoundException(resourceDescription + " requires an authenticated user");
        }
        if (this.requiredRoles.isEmpty()) {
            if (!context.getAuthentication().getAuthorities().isEmpty()) {
                return;
            }
        } else {
            Collection authorities = Collections2.transform((Collection)context.getAuthentication().getAuthorities(), (Function)new /* Unavailable Anonymous Inner Class!! */);
            for (String acc : this.requiredRoles) {
                if (!authorities.contains(acc)) continue;
                return;
            }
        }
        throw new AccessDeniedException("User " + context.getAuthentication().getPrincipal() + " does not have one of the required roles to access: " + resourceDescription);
    }

    public JSONObject marshal() {
        JSONObject marshalData = new JSONObject();
        JSONArray roles = new JSONArray();
        try {
            marshalData.put(JSON_ROLES, (Object)roles);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        if (this.requiredRoles != null) {
            for (String role : this.requiredRoles) {
                roles.put((Object)role);
            }
        }
        return marshalData;
    }

    public void unmarshal(JSONObject encodedAssertion) {
        try {
            this.requiredRoles = Sets.newHashSet();
            JSONArray roles = encodedAssertion.getJSONArray(JSON_ROLES);
            for (int i = 0; i < roles.length(); ++i) {
                this.requiredRoles.add(roles.getString(i));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.requiredRoles == null) {
            validationErrors.add((Throwable)new ConfigurationException("requiredRoles must be defined"));
        }
    }

    public boolean equals(Object o) {
        if (o instanceof RoleAccessAssertion) {
            return ((RoleAccessAssertion)o).requiredRoles.equals(this.requiredRoles);
        }
        return false;
    }

    public int hashCode() {
        return this.requiredRoles.hashCode();
    }

    public AccessAssertion copy() {
        RoleAccessAssertion assertion = new RoleAccessAssertion();
        assertion.requiredRoles = Collections.unmodifiableSet(new HashSet(this.requiredRoles));
        return assertion;
    }
}

