/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.mapfish.print.processor.http.matcher.URIMatcher;
import org.mapfish.print.processor.http.matcher.UriMatchers;

public class HttpCredential
implements ConfigurationObject {
    private String username;
    private char[] password;
    private UriMatchers matchers = new UriMatchers();

    public void setMatchers(List<? extends URIMatcher> matchers) {
        this.matchers.setMatchers(matchers);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    protected String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Do not set a null password, simply exclude it from configuration file.  If there is supposed to be a password perhaps it has illegal characters, surround password with quotes");
        }
        this.password = password.toCharArray();
    }

    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.username == null) {
            validationErrors.add(new IllegalStateException("The parameter 'username' is required."));
        }
    }

    public boolean matches(MatchInfo matchInfo) throws SocketException, UnknownHostException, MalformedURLException {
        return this.matchers.matches(matchInfo);
    }

    @Nullable
    public final Credentials toCredentials(AuthScope authscope) {
        try {
            if (!this.matches(MatchInfo.fromAuthScope((AuthScope)authscope))) {
                return null;
            }
        }
        catch (MalformedURLException | SocketException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
        if (this.username == null) {
            return null;
        }
        String passwordString = this.password != null ? new String(this.password) : null;
        return new UsernamePasswordCredentials(this.username, passwordString);
    }
}

