/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.mapfish.print.http.HttpRequestCache;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class HttpRequestCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestCache.class);
    private final List<CachedClientHttpRequest> requests = new ArrayList();
    private final File temporaryDirectory;
    private final MetricRegistry registry;
    private boolean cached = false;

    public HttpRequestCache(File temporaryDirectory, MetricRegistry registry) {
        this.temporaryDirectory = temporaryDirectory;
        this.registry = registry;
    }

    private CachedClientHttpRequest save(CachedClientHttpRequest request) {
        this.requests.add(request);
        return request;
    }

    public ClientHttpRequest register(ClientHttpRequest originalRequest) {
        return this.save(new CachedClientHttpRequest(this, originalRequest));
    }

    public ClientHttpRequest register(MfClientHttpRequestFactory factory, URI uri) throws IOException {
        return this.register(factory.createRequest(uri, HttpMethod.GET));
    }

    public void cache(ForkJoinPool requestForkJoinPool) {
        if (!this.cached) {
            requestForkJoinPool.invokeAll(this.requests);
            this.cached = true;
        } else {
            LOGGER.warn("Attempting to cache twice!");
        }
    }

    static /* synthetic */ File access$000(HttpRequestCache x0) {
        return x0.temporaryDirectory;
    }

    static /* synthetic */ boolean access$100(HttpRequestCache x0) {
        return x0.cached;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ MetricRegistry access$300(HttpRequestCache x0) {
        return x0.registry;
    }
}

