/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.HttpCredential;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;

public final class MfCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider fallback = new SystemDefaultCredentialsProvider();

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        throw new UnsupportedOperationException("Credentials should be set the default Java way or in the configuration yaml file.");
    }

    public Credentials getCredentials(AuthScope authscope) {
        Configuration config = MfClientHttpRequestFactoryImpl.getCurrentConfiguration();
        if (config != null) {
            ArrayList allCredentials = Lists.newArrayList((Iterable)config.getCredentials());
            allCredentials.addAll(config.getProxies());
            for (HttpCredential credential : allCredentials) {
                Credentials credentials = credential.toCredentials(authscope);
                if (credentials == null) continue;
                return credentials;
            }
        }
        return this.fallback.getCredentials(authscope);
    }

    public void clear() {
        throw new UnsupportedOperationException("Credentials should be set the default Java way or in the configuration yaml file.");
    }
}

