/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map;

import com.vividsolutions.jts.geom.Coordinate;
import javax.annotation.Nonnull;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.map.DistanceUnit;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Scale
implements Comparable<Scale> {
    private final double resolution;
    private final DistanceUnit unit;
    private static final Logger LOGGER = LoggerFactory.getLogger(Scale.class);

    public Scale(double denominator, @Nonnull CoordinateReferenceSystem projection, double dpi) {
        this(denominator, DistanceUnit.fromProjection((CoordinateReferenceSystem)projection), dpi);
    }

    public Scale(double denominator, @Nonnull DistanceUnit unit, double dpi) {
        this(1.0 / (unit.convertTo(1.0 / denominator, DistanceUnit.IN) * dpi), unit);
    }

    private Scale(double resolution, @Nonnull DistanceUnit unit) {
        this.resolution = resolution;
        this.unit = unit;
    }

    private Scale(double resolution, @Nonnull CoordinateReferenceSystem projection) {
        this.resolution = resolution;
        this.unit = DistanceUnit.fromProjection((CoordinateReferenceSystem)projection);
    }

    public double getResolution() {
        return this.resolution;
    }

    public double getResolutionInInches() {
        return this.unit.convertTo(this.resolution, DistanceUnit.IN);
    }

    public DistanceUnit getUnit() {
        return this.unit;
    }

    public double getDenominator(boolean geodetic, @Nonnull CoordinateReferenceSystem projection, double dpi, Coordinate position) {
        return geodetic ? this.getGeodeticDenominator(projection, dpi, position) : this.getDenominator(dpi);
    }

    public double getDenominator(double dpi) {
        double resolutionInInches = this.getResolutionInInches();
        return resolutionInInches * dpi;
    }

    public double getDenominator() {
        return this.getDenominator(72.0);
    }

    public double getGeodeticDenominator(@Nonnull CoordinateReferenceSystem projection, double dpi, Coordinate position) {
        if (this.unit == DistanceUnit.DEGREES) {
            return this.getDenominator(dpi);
        }
        try {
            double width = 1.0;
            double geoWidthInches = this.getResolutionInInches() * width;
            double geoWidth = DistanceUnit.IN.convertTo(geoWidthInches, this.unit);
            double minGeoX = position.y - geoWidth / 2.0;
            double maxGeoX = minGeoX + geoWidth;
            GeodeticCalculator calculator = new GeodeticCalculator(projection);
            double centerY = position.y;
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)projection, (CoordinateReferenceSystem)GenericMapAttribute.parseProjection((String)"EPSG:4326", (Boolean)true));
            Coordinate start = JTS.transform((Coordinate)new Coordinate(minGeoX, centerY), null, (MathTransform)transform);
            Coordinate end = JTS.transform((Coordinate)new Coordinate(maxGeoX, centerY), null, (MathTransform)transform);
            calculator.setStartingGeographicPoint(start.x, start.y);
            calculator.setDestinationGeographicPoint(end.x, end.y);
            double geoWidthInEllipsoidUnits = calculator.getOrthodromicDistance();
            DistanceUnit ellipsoidUnit = DistanceUnit.fromString((String)calculator.getEllipsoid().getAxisUnit().toString());
            double geoWidthInInches = ellipsoidUnit.convertTo(geoWidthInEllipsoidUnits, DistanceUnit.IN);
            return geoWidthInInches * (dpi / width);
        }
        catch (FactoryException e) {
            LOGGER.error("Unable to do the geodetic calculation on the scale", (Throwable)e);
        }
        catch (TransformException e) {
            LOGGER.error("Unable to do the geodetic calculation on the scale", (Throwable)e);
        }
        return this.getDenominator(dpi);
    }

    public static double getDenominator(boolean geodetic, double scaleDenominator, @Nonnull CoordinateReferenceSystem projection, double dpi, Coordinate position) {
        return geodetic ? Scale.getGeodeticDenominator((double)scaleDenominator, (CoordinateReferenceSystem)projection, (double)dpi, (Coordinate)position) : scaleDenominator;
    }

    public static double getGeodeticDenominator(double scaleDenominator, @Nonnull CoordinateReferenceSystem projection, double dpi, Coordinate position) {
        return new Scale(scaleDenominator, DistanceUnit.fromProjection((CoordinateReferenceSystem)projection), dpi).getGeodeticDenominator(projection, dpi, position);
    }

    public Scale toResolution(double newResolution) {
        return Scale.fromResolution((double)newResolution, (DistanceUnit)this.unit);
    }

    public static Scale fromResolution(double resolution, @Nonnull DistanceUnit projectionUnit) {
        return new Scale(resolution, projectionUnit);
    }

    public static Scale fromResolution(double resolution, @Nonnull CoordinateReferenceSystem projection) {
        return new Scale(resolution, projection);
    }

    @Override
    public int compareTo(Scale scale) {
        if (!this.unit.equals((Object)scale.unit)) {
            throw new RuntimeException("Unable to compare scales in different units");
        }
        return Double.compare(this.resolution, scale.resolution);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scale scale = (Scale)o;
        if (Double.compare(scale.resolution, this.resolution) != 0) {
            return false;
        }
        return this.unit == scale.unit;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.resolution);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("Scale{resolution=%s}", this.resolution);
    }
}

