/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.eclipse.emf.common.util.URI;
import org.geotools.xml.impl.HTTPURIHandler;
import org.geotools.xml.resolver.SchemaCache;
import org.geotools.xml.resolver.SchemaResolver;
import org.mapfish.print.config.WorkingDirectories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

class CachingUrihandler
extends HTTPURIHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingUrihandler.class);
    @Autowired
    private WorkingDirectories workingDirectories;
    private SchemaResolver resolver;

    CachingUrihandler() {
    }

    @PostConstruct
    public final void init() {
        this.resolver = new SchemaResolver(new SchemaCache(this.getCacheLocation(), true, true));
    }

    private File getCacheLocation() {
        return new File(this.workingDirectories.getWorking(), "xsdCache");
    }

    public boolean canHandle(URI uri) {
        return super.canHandle(uri) && uri.path().endsWith(".xsd");
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        String resolved = this.resolver.resolve(uri.toString());
        LOGGER.debug("Resolved {} to {}", (Object)uri, (Object)resolved);
        URI resolvedUri = URI.createURI((String)resolved);
        if (super.canHandle(resolvedUri)) {
            return super.createInputStream(resolvedUri, options);
        }
        URL resolvedUrl = new URL(resolved);
        if (resolvedUrl.getProtocol().equals("file")) {
            return new FileInputStream(resolvedUrl.getPath());
        }
        throw new IOException("Don't know how to handle " + resolved);
    }
}

