/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style.json;

import com.google.common.base.Optional;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.styling.SLD;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ColorParser {
    private static final float MAX_INT_COLOR = 255.0f;
    private static final String NUMBER_PATTERN = "\\s*(\\d*\\.?\\d*[%f]?)\\s*";
    private static final Pattern RGB_COLOR_EXTRACTOR = Pattern.compile("rgb\\s*\\(\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*\\)");
    private static final Pattern RGBA_COLOR_EXTRACTOR = Pattern.compile("rgba\\s*\\(\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*\\)");
    private static final Pattern HSL_COLOR_EXTRACTOR = Pattern.compile("hsl\\s*\\(\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*\\)");
    private static final Pattern HSLA_COLOR_EXTRACTOR = Pattern.compile("hsla\\s*\\(\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*,\\s*(\\d*\\.?\\d*[%f]?)\\s*\\)");

    private ColorParser() {
    }

    public static Color toColor(String colorString) {
        String trimmedString = colorString.trim();
        Color color = null;
        if (trimmedString.startsWith("#")) {
            int shortHexCode = 4;
            if (trimmedString.length() == 4) {
                StringBuilder builder = new StringBuilder("#");
                for (int i = 1; i < trimmedString.length(); ++i) {
                    builder.append(trimmedString.charAt(i));
                    builder.append(trimmedString.charAt(i));
                }
                color = SLD.toColor((String)builder.toString());
            } else {
                color = SLD.toColor((String)trimmedString);
            }
        }
        if (color == null) {
            color = ColorParser.parseRgbColor((String)trimmedString);
        }
        if (color == null) {
            color = ColorParser.parseRgbaColor((String)trimmedString);
        }
        if (color == null) {
            color = ColorParser.parseHslColor((String)trimmedString);
        }
        if (color == null) {
            color = ColorParser.parseHslaColor((String)trimmedString);
        }
        if (color == null) {
            Field[] fields;
            for (Field field : fields = Color.class.getFields()) {
                if (field.getType() != Color.class || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !field.getName().equalsIgnoreCase(trimmedString)) continue;
                try {
                    return (Color)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
            }
            color = Color.decode(trimmedString);
        }
        return color;
    }

    private static Color parseRgbColor(String colorString) {
        Matcher matcher = RGB_COLOR_EXTRACTOR.matcher(colorString);
        if (matcher.matches()) {
            String red = matcher.group(1);
            String green = matcher.group(2);
            String blue = matcher.group(3);
            return ColorParser.toColorRGBA((String)red, (String)green, (String)blue, (String)"255");
        }
        return null;
    }

    private static Color parseRgbaColor(String colorString) {
        Matcher matcher = RGBA_COLOR_EXTRACTOR.matcher(colorString);
        if (matcher.matches()) {
            String red = matcher.group(1);
            String green = matcher.group(2);
            String blue = matcher.group(3);
            String alpha = matcher.group(4);
            return ColorParser.toColorRGBA((String)red, (String)green, (String)blue, (String)alpha);
        }
        return null;
    }

    private static Color parseHslColor(String colorString) {
        Matcher matcher = HSL_COLOR_EXTRACTOR.matcher(colorString);
        if (matcher.matches()) {
            String hue = matcher.group(1);
            String saturation = matcher.group(2);
            String luminance = matcher.group(3);
            String alpha = "255";
            return ColorParser.toColorFromHSLA((String)hue, (String)saturation, (String)luminance, (String)alpha);
        }
        return null;
    }

    private static Color parseHslaColor(String colorString) {
        Matcher matcher = HSLA_COLOR_EXTRACTOR.matcher(colorString);
        if (matcher.matches()) {
            String hue = matcher.group(1);
            String saturation = matcher.group(2);
            String luminance = matcher.group(3);
            String alpha = matcher.group(4);
            return ColorParser.toColorFromHSLA((String)hue, (String)saturation, (String)luminance, (String)alpha);
        }
        return null;
    }

    private static Color toColorRGBA(String red, String green, String blue, String alpha) {
        float finalRed = ((Float)ColorParser.parsePercent((String)red).or(ColorParser.parseInt((String)red)).or(ColorParser.parseFloat((String)red)).or(ColorParser.parseDouble((String)red)).get()).floatValue();
        float finalGreen = ((Float)ColorParser.parsePercent((String)green).or(ColorParser.parseInt((String)green)).or(ColorParser.parseFloat((String)green)).or(ColorParser.parseDouble((String)green)).get()).floatValue();
        float finalBlue = ((Float)ColorParser.parsePercent((String)blue).or(ColorParser.parseInt((String)blue)).or(ColorParser.parseFloat((String)blue)).or(ColorParser.parseDouble((String)blue)).get()).floatValue();
        float finalAlpha = ((Float)ColorParser.parsePercent((String)alpha).or(ColorParser.parseInt((String)alpha)).or(ColorParser.parseFloat((String)alpha)).or(ColorParser.parseDouble((String)alpha)).or((Object)Float.valueOf(1.0f))).floatValue();
        return new Color(finalRed, finalGreen, finalBlue, finalAlpha);
    }

    private static Optional<Float> parsePercent(String colorString) {
        if (colorString.endsWith("%")) {
            return Optional.of((Object)Float.valueOf(((Float)ColorParser.parseDouble((String)colorString.substring(0, colorString.length() - 1)).get()).floatValue() / 100.0f));
        }
        return Optional.absent();
    }

    private static Color toColorFromHSLA(String hue, String saturation, String luminance, String alpha) {
        float finalHue = ((Float)ColorParser.parsePercent((String)hue).or(ColorParser.parseInt((String)hue)).or(ColorParser.parseFloat((String)hue)).or(ColorParser.parseDouble((String)hue)).get()).floatValue();
        float finalSaturation = ((Float)ColorParser.parsePercent((String)saturation).or(ColorParser.parseInt((String)saturation)).or(ColorParser.parseFloat((String)saturation)).or(ColorParser.parseDouble((String)saturation)).get()).floatValue();
        float finalLuminance = ((Float)ColorParser.parsePercent((String)luminance).or(ColorParser.parseInt((String)luminance)).or(ColorParser.parseFloat((String)luminance)).or(ColorParser.parseDouble((String)luminance)).get()).floatValue();
        float finalAlpha = ((Float)ColorParser.parsePercent((String)alpha).or(ColorParser.parseInt((String)alpha)).or(ColorParser.parseFloat((String)alpha)).or(ColorParser.parseDouble((String)alpha)).or((Object)Float.valueOf(1.0f))).floatValue();
        if (finalSaturation < 0.0f || finalSaturation > 1.0f) {
            String message = "Color parameter outside of expected range - Saturation (" + saturation + ")";
            throw new IllegalArgumentException(message);
        }
        if (finalLuminance < 0.0f || finalLuminance > 1.0f) {
            String message = "Color parameter outside of expected range - Luminance (" + luminance + ")";
            throw new IllegalArgumentException(message);
        }
        if (finalAlpha < 0.0f || finalAlpha > 1.0f) {
            String message = "Color parameter outside of expected range - Alpha (" + alpha + ")";
            throw new IllegalArgumentException(message);
        }
        float q = (double)finalLuminance < 0.5 ? finalLuminance * (1.0f + finalSaturation) : finalLuminance + finalSaturation - finalSaturation * finalLuminance;
        float p = 2.0f * finalLuminance - q;
        float red = ColorParser.hueToRGB((float)p, (float)q, (float)(finalHue + 0.33333334f));
        float green = ColorParser.hueToRGB((float)p, (float)q, (float)finalHue);
        float blue = ColorParser.hueToRGB((float)p, (float)q, (float)(finalHue - 0.33333334f));
        return new Color(red, green, blue, finalAlpha);
    }

    private static float hueToRGB(float p, float q, float hue) {
        float finalHue = hue;
        if (finalHue < 0.0f) {
            finalHue += 1.0f;
        }
        if (finalHue > 1.0f) {
            finalHue -= 1.0f;
        }
        if (6.0f * finalHue < 1.0f) {
            return p + (q - p) * 6.0f * finalHue;
        }
        if (2.0f * finalHue < 1.0f) {
            return q;
        }
        if (3.0f * finalHue < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - finalHue);
        }
        return p;
    }

    private static Optional<Float> parseFloat(String stringForm) {
        try {
            return Optional.of((Object)Float.valueOf(Float.parseFloat(stringForm)));
        }
        catch (NumberFormatException e) {
            return Optional.absent();
        }
    }

    private static Optional<Float> parseDouble(String stringForm) {
        try {
            return Optional.of((Object)Float.valueOf((float)Double.parseDouble(stringForm)));
        }
        catch (NumberFormatException e) {
            return Optional.absent();
        }
    }

    private static Optional<Float> parseInt(String stringForm) {
        try {
            int i = Integer.parseInt(stringForm);
            if (i == 0) {
                return Optional.of((Object)Float.valueOf(0.0f));
            }
            return Optional.of((Object)Float.valueOf((float)i / 255.0f));
        }
        catch (NumberFormatException e) {
            return Optional.absent();
        }
    }

    public static boolean canParseColor(String colorString) {
        try {
            return ColorParser.toColor((String)colorString) != null;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static String toRGB(Color color) {
        return "rgb(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }
}

